/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import org.openvpms.archetype.rules.finance.discount.DiscountRules;
import org.openvpms.archetype.rules.finance.tax.CustomerTaxRules;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ServiceRatioService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;

public class PricingContext {
    private final Party practice;
    private final Currency currency;
    private final Party location;
    private final ProductPriceRules priceRules;
    private final DiscountRules discountRules;
    private final ServiceRatioService serviceRatios;
    private final PricingGroup pricingGroup;
    private final CustomerTaxRules taxRules;
    private final boolean disableDiscounts;

    public PricingContext(Party practice, Party location, PracticeRules practiceRules, ProductPriceRules priceRules, DiscountRules discountRules, LocationRules locationRules, ServiceRatioService serviceRatios, IArchetypeService archetypeService) {
        this.practice = practice;
        this.currency = practiceRules.getCurrency(practice);
        if (this.currency == null) {
            throw new IllegalStateException("Practice has no currency set");
        }
        this.location = location;
        this.pricingGroup = new PricingGroup(locationRules.getPricingGroup(location));
        this.priceRules = priceRules;
        this.discountRules = discountRules;
        this.serviceRatios = serviceRatios;
        this.taxRules = new CustomerTaxRules(practice, archetypeService);
        this.disableDiscounts = archetypeService.getBean((IMObject)location).getBoolean("disableDiscounts");
    }

    public BigDecimal getPrice(Product product, Party customer, ProductPrice price, BigDecimal serviceRatio) {
        BigDecimal result = BigDecimal.ZERO;
        BigDecimal taxExPrice = price.getPrice();
        if (taxExPrice != null) {
            if (serviceRatio != null) {
                taxExPrice = taxExPrice.multiply(serviceRatio);
            }
            BigDecimal taxRate = this.taxRules.getTaxRate(product, customer);
            result = this.priceRules.getTaxIncPrice(taxExPrice, taxRate, this.currency);
        }
        return result;
    }

    public ProductPrice getFixedPrice(Product product, Date date) {
        return this.priceRules.getProductPrice(product, "productPrice.fixedPrice", date, this.pricingGroup.getGroup());
    }

    public ProductPrice getUnitPrice(Product product, Date date) {
        return this.priceRules.getProductPrice(product, "productPrice.unitPrice", date, this.pricingGroup.getGroup());
    }

    public BigDecimal getServiceRatio(Product product, Date date) {
        return this.serviceRatios.getServiceRatio(product, null, this.location, date);
    }

    public BigDecimal getMaxDiscount(ProductPrice price) {
        return this.priceRules.getMaxDiscount(price);
    }

    public BigDecimal getDiscount(Party customer, Party patient, Product product, BigDecimal fixedCost, BigDecimal fixedPrice, BigDecimal fixedPriceMaxDiscount, BigDecimal unitCost, BigDecimal unitPrice, BigDecimal unitPriceMaxDiscount, BigDecimal quantity, Date date) {
        BigDecimal amount = BigDecimal.ZERO;
        if (!this.disableDiscounts) {
            amount = this.discountRules.calculateDiscount(date, this.practice, customer, patient, product, fixedCost, unitCost, fixedPrice, unitPrice, quantity, fixedPriceMaxDiscount, unitPriceMaxDiscount);
        }
        return amount;
    }

    public BigDecimal getCost(ProductPrice price) {
        return this.priceRules.getCostPrice(price);
    }

    public BigDecimal getTax(BigDecimal total, Product product, Party customer) {
        return this.taxRules.calculateTax(total, (Collection)this.taxRules.getTaxRates(product, customer), true);
    }

    public Party getLocation() {
        return this.location;
    }
}

