/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.math.BigDecimal;
import java.util.Date;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.billing.charge.ChargeBuilder;
import org.openvpms.billing.charge.ChargeItemBuilder;
import org.openvpms.billing.exception.BillingException;
import org.openvpms.billing.internal.charge.AbstractChargeBuilder;
import org.openvpms.billing.internal.charge.BuildContext;
import org.openvpms.billing.internal.charge.BuilderServices;
import org.openvpms.billing.internal.charge.ChargeAmounts;
import org.openvpms.billing.internal.charge.ChargeBuilderImpl;
import org.openvpms.billing.internal.i18n.BillingMessages;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.customer.transaction.Charge;
import org.openvpms.domain.customer.transaction.ChargeItem;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.product.BaseProduct;
import org.openvpms.domain.product.Template;

public class ChargeItemBuilderImpl<C extends Charge<I>, I extends ChargeItem, CB extends ChargeBuilder<C, I, CB, IB>, IB extends ChargeItemBuilder<C, I, CB, IB>>
extends AbstractChargeBuilder
implements ChargeItemBuilder<C, I, CB, IB> {
    private final ChargeBuilderImpl<C, I, CB, IB> parent;
    private Patient patient;
    private Product product;
    private Template template;
    private int group;
    private boolean print;
    private BigDecimal quantity;
    private BigDecimal minQuantity;
    private User clinician;
    private static final String PATIENT = "patient";
    private static final String PRODUCT = "product";
    private static final String STOCK_LOCATION = "stockLocation";
    private static final String QUANTITY = "quantity";
    private static final String CLINICIAN = "clinician";
    private static final String FIXED_COST = "fixedCost";
    private static final String FIXED_PRICE = "fixedPrice";
    private static final String UNIT_COST = "unitCost";
    private static final String UNIT_PRICE = "unitPrice";
    private static final String SERVICE_RATIO = "serviceRatio";
    private static final String DISCOUNT = "discount";
    private static final String TOTAL = "total";
    private static final String TAX = "tax";
    private static final String TEMPLATE = "template";
    private static final String GROUP = "group";
    private static final String MIN_QUANTITY = "minQuantity";
    private static final String PRINT = "print";

    public ChargeItemBuilderImpl(String archetype, ChargeBuilderImpl<C, I, CB, IB> parent, BuilderServices services) {
        super(archetype, services);
        this.parent = parent;
    }

    public Patient getPatient() {
        return this.patient;
    }

    public IB patient(Patient patient) {
        this.patient = patient;
        return this.getThis();
    }

    public Product getProduct() {
        return this.product;
    }

    public IB product(Product product) {
        this.product = product instanceof BaseProduct ? product : (Product)this.getServices().getDomainService().create((IMObject)product, BaseProduct.class);
        this.template = null;
        this.minQuantity = null;
        this.print = true;
        this.group = 0;
        return this.getThis();
    }

    public IB template(Template template, BigDecimal minQuantity, boolean print, int group) {
        this.template = template;
        this.minQuantity = minQuantity;
        this.print = print;
        return this.group(group);
    }

    public Template getTemplate() {
        return this.template;
    }

    public IB group(int group) {
        this.group = group;
        return this.getThis();
    }

    public BigDecimal getQuantity() {
        return this.quantity != null ? this.quantity : BigDecimal.ZERO;
    }

    public IB quantity(int quantity) {
        return this.quantity(BigDecimal.valueOf(quantity));
    }

    public IB quantity(BigDecimal quantity) {
        this.quantity = quantity;
        return this.getThis();
    }

    public User getClinician() {
        return this.clinician;
    }

    public IB clinician(User clinician) {
        this.clinician = clinician;
        return this.getThis();
    }

    public CB add() {
        this.parent.add(this.getThis());
        return this.parent.getThis();
    }

    public FinancialAct build(Date date, BuildContext context) {
        this.checkPreconditions();
        FinancialAct act = this.getObject();
        context.addChange((IMObject)act);
        IMObjectBean bean = this.getBean((IMObject)act);
        this.build(act, bean, date, context);
        return act;
    }

    protected void checkPreconditions() {
        if (this.product == null) {
            throw new BillingException(BillingMessages.valueRequired(PRODUCT));
        }
        if (this.patient == null) {
            throw new BillingException(BillingMessages.valueRequired(PATIENT));
        }
        if (this.quantity == null) {
            throw new BillingException(BillingMessages.valueRequired(QUANTITY));
        }
        Reference owner = this.getServices().getPatientRules().getOwnerReference((Party)this.patient);
        Customer customer = this.parent.getCustomer();
        if (!customer.getObjectReference().equals((Object)owner)) {
            throw new BillingException(BillingMessages.customerNotOwner(customer.getName(), this.patient.getName()));
        }
    }

    protected void build(FinancialAct act, IMObjectBean bean, Date date, BuildContext context) {
        act.setActivityStartTime(date);
        bean.setTarget(PATIENT, (IMObject)this.patient);
        bean.setTarget(PRODUCT, (IMObject)this.product);
        if (this.product.isA(new String[]{"product.medication", "product.merchandise"})) {
            Party stockLocation = this.getServices().getStockRules().getStockLocation(this.product, (Party)this.parent.getLocation());
            if (stockLocation != null) {
                bean.setTarget(STOCK_LOCATION, (IMObject)stockLocation);
            } else {
                bean.removeValues(STOCK_LOCATION);
            }
        }
        bean.setValue(QUANTITY, (Object)this.quantity);
        if (this.clinician != null) {
            bean.setTarget(CLINICIAN, (IMObject)this.clinician);
        }
        ChargeAmounts prices = new ChargeAmounts(this.parent.getCustomer(), this.patient, this.product, this.quantity, date, context.getPricingContext());
        bean.setValue(FIXED_COST, (Object)prices.getFixedCost());
        bean.setValue(FIXED_PRICE, (Object)prices.getFixedPrice());
        bean.setValue(UNIT_COST, (Object)prices.getUnitCost());
        bean.setValue(UNIT_PRICE, (Object)prices.getUnitPrice());
        bean.setValue(SERVICE_RATIO, (Object)prices.getServiceRatio());
        bean.setValue(DISCOUNT, (Object)prices.getDiscount());
        BigDecimal total = prices.getTotal();
        bean.setValue(TOTAL, (Object)total);
        bean.setValue(TAX, (Object)prices.getTax());
        if (this.template != null) {
            Relationship participation = bean.setTarget(TEMPLATE, (IMObject)this.template);
            IMObjectBean participationBean = bean.getBean((IMObject)participation);
            participationBean.setValue(GROUP, (Object)this.group);
            bean.setValue(MIN_QUANTITY, (Object)this.minQuantity);
            if (!this.print && MathRules.isZero((BigDecimal)total)) {
                bean.setValue(PRINT, (Object)false);
            }
        }
    }

    protected IB getThis() {
        return (IB)this;
    }

    protected ChargeBuilderImpl<C, I, CB, IB> getParent() {
        return this.parent;
    }
}

