/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.util.Date;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.billing.internal.charge.BuilderServices;
import org.openvpms.billing.internal.charge.InvoiceContext;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.product.Template;

class TemplateVisitNoteBuilder {
    private final Patient patient;
    private final Template template;
    private final User clinician;
    private final String note;
    private final BuilderServices builderServices;

    public TemplateVisitNoteBuilder(Patient patient, Template template, String note, User clinician, BuilderServices builderServices) {
        this.patient = patient;
        this.template = template;
        this.note = note;
        this.clinician = clinician;
        this.builderServices = builderServices;
    }

    public boolean matches(Patient patient, Template template) {
        return this.patient.equals(patient) && this.template.equals(template);
    }

    public void build(Date date, InvoiceContext context) {
        MedicalRecordRules rules = this.builderServices.getMedicalRecordRules();
        Act record = rules.createNote(date, (Party)this.patient, this.note, this.clinician);
        context.addRecord(record, date);
    }
}

