/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.billing.charge.ChargeObjects;
import org.openvpms.billing.charge.InvoiceBuilder;
import org.openvpms.billing.charge.InvoiceItemBuilder;
import org.openvpms.billing.charge.InvoiceItems;
import org.openvpms.billing.charge.InvoiceObjects;
import org.openvpms.billing.exception.BillingException;
import org.openvpms.billing.internal.charge.AlertBuilder;
import org.openvpms.billing.internal.charge.BuildContext;
import org.openvpms.billing.internal.charge.BuilderServices;
import org.openvpms.billing.internal.charge.ChargeBuilderImpl;
import org.openvpms.billing.internal.charge.InvoiceContext;
import org.openvpms.billing.internal.charge.InvoiceItemBuilderImpl;
import org.openvpms.billing.internal.charge.InvoiceItemsImpl;
import org.openvpms.billing.internal.charge.InvoiceObjectsImpl;
import org.openvpms.billing.internal.charge.ReminderBuilder;
import org.openvpms.billing.internal.charge.TemplateVisitNoteBuilder;
import org.openvpms.billing.internal.i18n.BillingMessages;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.customer.transaction.Invoice;
import org.openvpms.domain.customer.transaction.InvoiceItem;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.product.Template;

public class InvoiceBuilderImpl
extends ChargeBuilderImpl<Invoice, InvoiceItem, InvoiceBuilder, InvoiceItemBuilder>
implements InvoiceBuilder {
    private final Map<Patient, List<ReminderBuilder>> reminderBuilders = new HashMap<Patient, List<ReminderBuilder>>();
    private final Map<Patient, List<AlertBuilder>> alertBuilders = new HashMap<Patient, List<AlertBuilder>>();
    private final List<TemplateVisitNoteBuilder> visitNoteBuilders = new ArrayList<TemplateVisitNoteBuilder>();

    public InvoiceBuilderImpl(BuilderServices services) {
        super("act.customerAccountChargesInvoice", services);
    }

    public InvoiceItemBuilderImpl newItem() {
        return new InvoiceItemBuilderImpl(this, this.getServices());
    }

    public InvoiceItems expand(Template template, Patient patient, BigDecimal quantity, User clinician) {
        String note = template.getVisitNote();
        if (!StringUtils.isEmpty((CharSequence)note) && this.visitNoteBuilders.stream().noneMatch(builder -> builder.matches(patient, template))) {
            this.visitNoteBuilders.add(new TemplateVisitNoteBuilder(patient, template, note, clinician, this.getServices()));
        }
        return (InvoiceItems)super.expand(template, patient, quantity, clinician);
    }

    public InvoiceItems getChangedItems() {
        return (InvoiceItems)super.getChangedItems();
    }

    public InvoiceObjects buildObjects() {
        return (InvoiceObjects)super.buildObjects();
    }

    @Override
    protected FinancialAct getObject() {
        Customer customer = this.getCustomer();
        if (customer == null) {
            throw new BillingException(BillingMessages.valueRequired("customer"));
        }
        CustomerAccountRules rules = this.getServices().getCustomerAccountRules();
        FinancialAct invoice = rules.getInvoice((Party)customer);
        if (invoice == null) {
            invoice = super.getObject();
        }
        return invoice;
    }

    protected InvoiceItems createChargeItems(List<InvoiceItemBuilder> builders) {
        return new InvoiceItemsImpl(builders);
    }

    @Override
    protected ChargeObjects<Invoice, InvoiceItem> createChargeObjects(BuildContext context) {
        return new InvoiceObjectsImpl((InvoiceContext)context, this.getServices().getDomainService());
    }

    @Override
    protected BuildContext createBuildContext(IMObjectBean charge) {
        return new InvoiceContext(charge, this.createPricingContext(), this.getArchetypeService(), this.getServices().getReminderRules());
    }

    protected void addReminder(ReminderBuilder builder) {
        List builders = this.reminderBuilders.computeIfAbsent(builder.getPatient(), k -> new ArrayList());
        builders.add(builder);
    }

    protected void addAlert(AlertBuilder builder) {
        List builders = this.alertBuilders.computeIfAbsent(builder.getPatient(), k -> new ArrayList());
        builders.add(builder);
    }

    @Override
    protected void build(FinancialAct charge, IMObjectBean bean, Date date, BuildContext context) {
        super.build(charge, bean, date, context);
        InvoiceContext invoiceContext = (InvoiceContext)context;
        this.buildReminders(invoiceContext);
        this.buildAlerts(invoiceContext);
        this.buildVisitNotes(date, invoiceContext);
    }

    @Override
    protected void reset() {
        super.reset();
        this.reminderBuilders.clear();
        this.visitNoteBuilders.clear();
    }

    private void buildVisitNotes(Date date, InvoiceContext context) {
        for (TemplateVisitNoteBuilder visitNoteBuilder : this.visitNoteBuilders) {
            visitNoteBuilder.build(date, context);
        }
    }

    private void buildReminders(InvoiceContext context) {
        for (List<ReminderBuilder> builders : this.reminderBuilders.values()) {
            builders = this.removeDuplicateReminders(builders);
            for (ReminderBuilder builder : builders) {
                builder.build(context);
            }
        }
    }

    private void buildAlerts(InvoiceContext context) {
        for (List<AlertBuilder> builders : this.alertBuilders.values()) {
            builders = this.removeDuplicateAlerts(builders);
            for (AlertBuilder builder : builders) {
                builder.build(context);
            }
        }
    }

    private List<ReminderBuilder> removeDuplicateReminders(List<ReminderBuilder> builders) {
        List<ReminderBuilder> result;
        if (builders.size() > 1) {
            HashMap<Entity, ReminderBuilder> map = new HashMap<Entity, ReminderBuilder>();
            for (ReminderBuilder builder : builders) {
                ReminderBuilder existing = (ReminderBuilder)map.get(builder.getReminderType());
                if (existing == null) {
                    map.put(builder.getReminderType(), builder);
                    continue;
                }
                int compareTo = existing.getDueDate().compareTo(builder.getDueDate());
                if (compareTo <= 0 && (compareTo != 0 || existing.getProduct().getId() <= builder.getProduct().getId())) continue;
                map.put(builder.getReminderType(), builder);
            }
            result = new ArrayList(map.values());
        } else {
            result = builders;
        }
        return result;
    }

    private List<AlertBuilder> removeDuplicateAlerts(List<AlertBuilder> builders) {
        List<AlertBuilder> result;
        if (builders.size() > 1) {
            HashMap<Entity, AlertBuilder> map = new HashMap<Entity, AlertBuilder>();
            for (AlertBuilder builder : builders) {
                map.putIfAbsent(builder.getAlertType(), builder);
            }
            result = new ArrayList(map.values());
        } else {
            result = builders;
        }
        return result;
    }
}

