/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Selection;
import org.openvpms.archetype.rules.act.ActCalculator;
import org.openvpms.billing.charge.ChargeBuilder;
import org.openvpms.billing.charge.ChargeItemBuilder;
import org.openvpms.billing.charge.ChargeItems;
import org.openvpms.billing.charge.ChargeObjects;
import org.openvpms.billing.exception.BillingException;
import org.openvpms.billing.internal.charge.AbstractChargeBuilder;
import org.openvpms.billing.internal.charge.BuildContext;
import org.openvpms.billing.internal.charge.BuilderServices;
import org.openvpms.billing.internal.charge.ChargeItemBuilderImpl;
import org.openvpms.billing.internal.charge.ChargeItemsImpl;
import org.openvpms.billing.internal.charge.PricingContext;
import org.openvpms.billing.internal.charge.ProductQuantity;
import org.openvpms.billing.internal.charge.TemplateExpander;
import org.openvpms.billing.internal.i18n.BillingMessages;
import org.openvpms.component.math.Weight;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.RelatedIMObjects;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.customer.transaction.Charge;
import org.openvpms.domain.customer.transaction.ChargeItem;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.practice.Location;
import org.openvpms.domain.product.Template;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class ChargeBuilderImpl<C extends Charge<I>, I extends ChargeItem, CB extends ChargeBuilder<C, I, CB, IB>, IB extends ChargeItemBuilder<C, I, CB, IB>>
extends AbstractChargeBuilder
implements ChargeBuilder<C, I, CB, IB> {
    private final Party practice;
    private final Set<IB> builders = new LinkedHashSet<IB>();
    private final List<ActIdentity> identities = new ArrayList<ActIdentity>();
    private IMObjectBean currentCharge;
    private Location location;
    private Customer customer;
    private User clinician;
    private int nextSequence;
    private int templateGroup;
    private TemplateExpander templateExpander;

    public ChargeBuilderImpl(String archetype, BuilderServices services) {
        super(archetype, services);
        this.practice = services.getPricingContextFactory().getPractice();
        if (this.practice == null) {
            throw new IllegalStateException("No practice");
        }
    }

    public Location getLocation() {
        return this.location;
    }

    public CB location(Location location) {
        if (this.templateExpander != null) {
            throw new IllegalStateException("Cannot change location once templates expanded");
        }
        this.location = location;
        return this.getThis();
    }

    public Customer getCustomer() {
        return this.customer;
    }

    public CB customer(Customer customer) {
        this.customer = customer;
        return this.getThis();
    }

    public User getClinician() {
        return this.clinician;
    }

    public CB clinician(User clinician) {
        this.clinician = clinician;
        return this.getThis();
    }

    public CB addIdentity(String archetype, String identity) {
        ActIdentity id = this.create(archetype, ActIdentity.class);
        id.setIdentity(identity);
        this.identities.add(id);
        return this.getThis();
    }

    public ChargeItems<C, I, CB, IB> expand(Template template, Patient patient, BigDecimal quantity, User clinician) {
        ArrayList<IB> builders = new ArrayList<IB>();
        Weight weight = patient.getWeight();
        Collection<ProductQuantity> expanded = this.getTemplateExpander().expand(template, weight, quantity);
        if (expanded.isEmpty()) {
            throw new BillingException(BillingMessages.templateExpansionGeneratedNoItems(template.getName(), weight));
        }
        for (ProductQuantity productQuantity : expanded) {
            IB builder = this.add(template, patient, productQuantity, clinician);
            builders.add(builder);
        }
        ++this.templateGroup;
        return this.createChargeItems(builders);
    }

    public ChargeItems<C, I, CB, IB> getChangedItems() {
        return this.createChargeItems(new ArrayList<IB>(this.builders));
    }

    public IB add(IB builder) {
        Object result;
        Product product = builder.getProduct();
        if (product instanceof Template) {
            ChargeItems<C, I, CB, IB> expanded = this.expand((Template)product, builder.getPatient(), builder.getQuantity(), builder.getClinician());
            result = (ChargeItemBuilder)expanded.getItems().get(0);
        } else {
            this.builders.add(builder);
            result = builder;
        }
        return result;
    }

    public C build() {
        return (C)this.buildObjects().getCharge();
    }

    public ChargeObjects<C, I> buildObjects() {
        if (this.customer == null) {
            throw new BillingException(BillingMessages.valueRequired("customer"));
        }
        Date date = new Date();
        IMObjectBean bean = this.getCurrentCharge();
        FinancialAct charge = (FinancialAct)bean.getObject(FinancialAct.class);
        BuildContext context = this.createBuildContext(bean);
        this.build(charge, bean, date, context);
        this.saveInTransaction(context);
        this.reset();
        return this.createChargeObjects(context);
    }

    protected IMObjectBean getCurrentCharge() {
        if (this.currentCharge == null) {
            this.currentCharge = this.init();
        }
        return this.currentCharge;
    }

    protected ChargeItems<C, I, CB, IB> createChargeItems(List<IB> builders) {
        return new ChargeItemsImpl(builders);
    }

    protected abstract ChargeObjects<C, I> createChargeObjects(BuildContext var1);

    protected void save(BuildContext context) {
        context.save();
    }

    protected CB getThis() {
        return (CB)this;
    }

    protected void build(FinancialAct charge, IMObjectBean bean, Date date, BuildContext context) {
        context.addChange((IMObject)charge);
        if (charge.isNew()) {
            charge.setActivityStartTime(date);
            bean.setTarget("customer", (IMObject)this.customer);
            bean.setTarget("location", (IMObject)this.location);
        }
        if (this.clinician != null) {
            bean.setTarget("clinician", (IMObject)this.clinician);
        }
        for (ActIdentity actIdentity : this.identities) {
            this.checkIdentity(actIdentity, charge);
            charge.addIdentity(actIdentity);
        }
        ArrayList<FinancialAct> items = new ArrayList<FinancialAct>();
        for (ChargeItemBuilder itemBuilder : this.builders) {
            ChargeItemBuilderImpl builder = (ChargeItemBuilderImpl)itemBuilder;
            FinancialAct item = builder.build(date, context);
            ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)item);
            relationship.setSequence(this.nextSequence++);
            item.addActRelationship(relationship);
            items.add(item);
        }
        BigDecimal bigDecimal = charge.getTotal();
        BigDecimal tax = charge.getTaxAmount();
        ActCalculator calculator = new ActCalculator(this.getArchetypeService());
        BigDecimal bigDecimal2 = bigDecimal.add(calculator.sum((Act)charge, items, "total"));
        tax = tax.add(calculator.sum((Act)charge, items, "tax"));
        bean.setValue("amount", (Object)bigDecimal2);
        bean.setValue("tax", (Object)tax);
    }

    protected void reset() {
        this.currentCharge = null;
        this.templateExpander = null;
        this.builders.clear();
        this.identities.clear();
    }

    protected BuildContext createBuildContext(IMObjectBean charge) {
        return new BuildContext(charge, this.createPricingContext(), this.getArchetypeService());
    }

    protected PricingContext createPricingContext() {
        return this.getServices().getPricingContextFactory().createContext(this.practice, (Party)this.location);
    }

    private void initLocation(IMObjectBean charge) {
        Party existing;
        if (!charge.getObject().isNew() && (existing = (Party)charge.getTarget("location", Party.class)) != null) {
            this.location = (Location)this.getServices().getDomainService().create((IMObject)existing, Location.class);
        }
        if (this.location == null) {
            throw new BillingException(BillingMessages.valueRequired("location"));
        }
    }

    private void saveInTransaction(final BuildContext context) {
        TransactionTemplate template = new TransactionTemplate(this.getServices().getTransactionManager());
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                ChargeBuilderImpl.this.save(context);
            }
        });
    }

    private IB add(Template template, Patient patient, ProductQuantity productQuantity, User clinician) {
        ChargeItemBuilder item = this.newItem();
        item.patient(patient).product(productQuantity.getProduct()).quantity(productQuantity.getHighQuantity()).clinician(clinician).add();
        ChargeItemBuilderImpl builder = (ChargeItemBuilderImpl)item;
        builder.template(template, productQuantity.getLowQuantity(), productQuantity.getPrint(), this.templateGroup);
        return (IB)item;
    }

    private IMObjectBean init() {
        this.nextSequence = 0;
        this.templateGroup = 0;
        FinancialAct charge = this.getObject();
        IMObjectBean bean = this.getBean((IMObject)charge);
        this.initLocation(bean);
        if (!charge.isNew()) {
            RelatedIMObjects items = (RelatedIMObjects)bean.getRelated("items", Act.class, ActRelationship.class).policy(Policies.newPolicy(ActRelationship.class).orderBySequence().build());
            List relationships = items.getRelationships();
            if (!relationships.isEmpty()) {
                this.nextSequence = ((ActRelationship)relationships.get(relationships.size() - 1)).getSequence() + 1;
            }
            int max = -1;
            for (Act item : items.getObjects()) {
                IMObjectBean itemBean = this.getBean((IMObject)item);
                Participation template = (Participation)itemBean.getObject("template", Participation.class);
                if (template == null) continue;
                max = Math.max(max, this.getBean((IMObject)template).getInt("group"));
            }
            this.templateGroup = max >= 0 ? max + 1 : 0;
        }
        return bean;
    }

    private TemplateExpander getTemplateExpander() {
        if (this.templateExpander == null) {
            if (this.customer == null) {
                throw new IllegalStateException("Customer must be set to expand templates");
            }
            this.getCurrentCharge();
            BuilderServices services = this.getServices();
            boolean useLocationProducts = services.getPricingContextFactory().useLocationProducts(this.practice);
            this.templateExpander = new TemplateExpander(useLocationProducts, this.practice, (Party)this.location, services.getStockRules(), services.getProductRules(), services.getDomainService());
        }
        return this.templateExpander;
    }

    private void checkIdentity(ActIdentity identity, FinancialAct charge) {
        for (ActIdentity existing : charge.getIdentities()) {
            if (!existing.getIdentity().equals(identity.getIdentity()) || !existing.getArchetype().equals(identity.getArchetype())) continue;
            throw new IllegalStateException("Duplicate identity: " + identity.getArchetype() + ":" + identity.getIdentity());
        }
        ArchetypeService service = this.getArchetypeService();
        CriteriaBuilder builder = service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Long.class);
        Root from = query.from(FinancialAct.class, new String[]{charge.getArchetype()});
        query.select((Selection)from.get("id"));
        Join identities = from.join("identities", identity.getArchetype());
        identities.on((Expression)builder.equal((Expression)identities.get("identity"), (Object)identity.getIdentity()));
        Long id = (Long)service.createQuery(query).getFirstResult();
        if (id != null) {
            throw new IllegalStateException("Duplicate identity: " + identity.getArchetype() + ":" + identity.getIdentity() + " found on charge " + id);
        }
    }
}

