/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import org.openvpms.billing.internal.charge.BuilderServices;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class AbstractChargeBuilder {
    private final String archetype;
    private final BuilderServices services;

    public AbstractChargeBuilder(String archetype, BuilderServices services) {
        this.archetype = archetype;
        this.services = services;
    }

    protected FinancialAct getObject() {
        return this.create(this.archetype, FinancialAct.class);
    }

    protected <T extends IMObject> T create(String archetype, Class<T> type) {
        return (T)this.getArchetypeService().create(archetype, type);
    }

    protected IMObjectBean getBean(IMObject object) {
        return this.getArchetypeService().getBean(object);
    }

    protected ArchetypeService getArchetypeService() {
        return this.services.getArchetypeService();
    }

    protected BuilderServices getServices() {
        return this.services;
    }
}

