/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.i18n;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.i18n.Message;
import org.openvpms.component.i18n.Messages;
import org.openvpms.component.math.Weight;

public class BillingMessages {
    private static final Messages messages = new Messages("BILLING", BillingMessages.class.getName());

    public static Message valueRequired(String name) {
        return messages.create(1, new Object[]{name});
    }

    public static Message customerNotOwner(String customer, String patient) {
        return messages.create(2, new Object[]{customer, patient});
    }

    public static Message templateExpansionGeneratedNoItems(String template, Weight weight) {
        return messages.create(3, new Object[]{template, weight.getWeight()});
    }

    public static Message weightRequired(String product, String template) {
        return messages.create(4, new Object[]{product, template});
    }

    public static Message templateProductNotAvailableAtLocation(String product, String template, String location) {
        return messages.create(5, new Object[]{product, template, location});
    }

    public static Message recursiveTemplateExpansion(String template, String nestedTemplate, List<String> names) {
        return messages.create(6, new Object[]{template, nestedTemplate, StringUtils.join(names, (String)", ")});
    }
}

