/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.stock.StockRules;
import org.openvpms.billing.exception.BillingException;
import org.openvpms.billing.internal.charge.ProductQuantity;
import org.openvpms.billing.internal.i18n.BillingMessages;
import org.openvpms.component.math.Weight;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.product.Template;
import org.openvpms.domain.product.TemplateItem;

public class TemplateExpander {
    private final boolean useLocationProducts;
    private final Party location;
    private final Party stockLocation;
    private final StockRules stockRules;
    private final ProductRules productRules;
    private final DomainService domainService;

    public TemplateExpander(boolean useLocationProducts, Party location, Party stockLocation, StockRules stockRules, ProductRules productRules, DomainService domainService) {
        this.useLocationProducts = useLocationProducts;
        this.location = location;
        this.stockLocation = stockLocation;
        this.stockRules = stockRules;
        this.productRules = productRules;
        this.domainService = domainService;
    }

    public Collection<ProductQuantity> expand(Template template, Weight weight, BigDecimal quantity) {
        LinkedHashMap<ProductQuantity, ProductQuantity> includes = new LinkedHashMap<ProductQuantity, ProductQuantity>();
        ArrayDeque<Product> parents = new ArrayDeque<Product>();
        this.expand(template, template, weight, includes, quantity, quantity, false, parents);
        return includes.values();
    }

    protected void expand(Template template, Template root, Weight weight, Map<ProductQuantity, ProductQuantity> includes, BigDecimal lowQuantity, BigDecimal highQuantity, boolean zeroPrice, Deque<Product> parents) {
        if (template.isActive()) {
            if (!parents.contains(template)) {
                parents.push((Product)template);
                for (TemplateItem item : template.getItems()) {
                    this.add(item, template, root, weight, includes, lowQuantity, highQuantity, zeroPrice, parents);
                }
                parents.pop();
            } else {
                ArrayList<Product> products = new ArrayList<Product>(parents);
                Collections.reverse(products);
                products.add((Product)template);
                List<String> names = products.stream().map(IMObject::getName).collect(Collectors.toList());
                throw new BillingException(BillingMessages.recursiveTemplateExpansion(root.getName(), template.getName(), names));
            }
        }
    }

    protected void add(TemplateItem item, Template template, Template root, Weight weight, Map<ProductQuantity, ProductQuantity> includes, BigDecimal lowQuantity, BigDecimal highQuantity, boolean zeroPrice, Deque<Product> parents) {
        Product product = item.getProduct();
        if (item.requiresWeight() && weight.isZero()) {
            throw new BillingException(BillingMessages.weightRequired(product.getName(), template.getName()));
        }
        if (!item.requiresWeight() || item.inWeightRange(weight)) {
            boolean zero;
            this.checkAvailability(item, template);
            BigDecimal newLowQty = item.getLowQuantity().multiply(lowQuantity);
            BigDecimal newHighQty = item.getHighQuantity().multiply(highQuantity);
            boolean bl = zero = item.getZeroPrice() || zeroPrice;
            if (product instanceof Template) {
                this.expand((Template)product, root, weight, includes, newLowQty, newHighQty, zero, parents);
            } else {
                ProductQuantity current = new ProductQuantity(product, newLowQty, newHighQty, zero, item.getPrint());
                ProductQuantity existing = includes.get(current);
                if (existing == null) {
                    includes.put(current, current);
                } else {
                    existing.add(newLowQty, newHighQty);
                }
            }
        }
    }

    private Party checkProductLocation(Product product) {
        Party result = null;
        if (product.isA(new String[]{"product.medication", "product.merchandise"})) {
            if (this.stockLocation != null && !this.stockRules.hasStockRelationship(product, this.stockLocation)) {
                result = this.stockLocation;
            }
        } else if (product.isA(new String[]{"product.service", "product.template"}) && this.location != null && !this.productRules.canUseProductAtLocation(product, this.location)) {
            result = this.location;
        }
        return result;
    }

    private void checkAvailability(TemplateItem item, Template template) {
        Product product;
        Party location;
        if (this.useLocationProducts && (location = this.checkProductLocation(product = item.getProduct())) != null && !item.getSkipIfMissing()) {
            throw new BillingException(BillingMessages.templateProductNotAvailableAtLocation(template.getName(), product.getName(), location.getName()));
        }
    }
}

