/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.billing.internal.charge;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openvpms.billing.charge.ChargeBuilder;
import org.openvpms.billing.charge.ChargeItemBuilder;
import org.openvpms.billing.charge.ChargeItems;
import org.openvpms.component.model.product.Product;
import org.openvpms.domain.customer.transaction.Charge;
import org.openvpms.domain.customer.transaction.ChargeItem;

public class ChargeItemsImpl<C extends Charge<I>, I extends ChargeItem, CB extends ChargeBuilder<C, I, CB, IB>, IB extends ChargeItemBuilder<C, I, CB, IB>>
implements ChargeItems<C, I, CB, IB> {
    private final List<IB> items;

    public ChargeItemsImpl(List<IB> items) {
        this.items = items;
    }

    public Optional<IB> getItem(Product product) {
        return this.items.stream().filter(item -> Objects.equals(product, item.getProduct())).findFirst();
    }

    public List<IB> getItems() {
        return this.items;
    }
}

