/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.tools;

import java.io.File;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.apache.commons.lang3.RandomUtils;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.component.business.domain.im.act.Act;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class TestRosterGenerator {
    private final ArchetypeService service;

    public TestRosterGenerator(ArchetypeService service) {
        this.service = service;
    }

    public void generate() {
        List<User> users = this.getEntities("security.user", User.class);
        List<Entity> areas = this.getEntities("entity.rosterArea", Entity.class);
        if (users.isEmpty()) {
            throw new IllegalStateException("Need at least one active user");
        }
        if (areas.isEmpty()) {
            throw new IllegalStateException("Need at least one active roster area");
        }
        Date date = DateRules.getToday();
        for (int i = 0; i < 14; ++i) {
            for (Entity area : areas) {
                System.out.println("Generating roster for " + area.getName() + " on " + date);
                IMObjectBean bean = this.service.getBean((IMObject)area);
                Party location = (Party)bean.getTarget("location", Party.class);
                for (User user : users) {
                    String status = this.getStatus();
                    String error = null;
                    if ("ERROR".equals(status)) {
                        error = "A sync error";
                    }
                    this.createEvent(area, location, user, date, status, error);
                }
            }
            date = DateRules.getNextDate((Date)date);
        }
    }

    public static void main(String[] args) {
        String contextPath = "openvpms-archetypes-test-context.xml";
        Object context = !new File(contextPath).exists() ? new ClassPathXmlApplicationContext(contextPath) : new FileSystemXmlApplicationContext(contextPath);
        TestRosterGenerator generator = new TestRosterGenerator((ArchetypeService)context.getBean(IArchetypeRuleService.class));
        generator.generate();
    }

    private String getStatus() {
        String result;
        int i = RandomUtils.nextInt((int)0, (int)3);
        switch (i) {
            case 0: {
                result = "PENDING";
                break;
            }
            case 1: {
                result = "SYNC";
                break;
            }
            default: {
                result = "ERROR";
            }
        }
        return result;
    }

    private void createEvent(Entity area, Party location, User user, Date date, String status, String error) {
        Date startTime = DateRules.getDate((Date)date, (int)8, (DateUnits)DateUnits.HOURS);
        Date endTime = DateRules.getDate((Date)date, (int)17, (DateUnits)DateUnits.HOURS);
        ActIdentity identity = this.createIdentity(status, error);
        Act act = (Act)this.service.create("act.rosterEvent", Act.class);
        act.addIdentity(identity);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setValue("startTime", (Object)startTime);
        bean.setValue("endTime", (Object)endTime);
        bean.setTarget("user", (IMObject)user);
        bean.setTarget("schedule", (IMObject)area);
        bean.setTarget("location", (IMObject)location);
        bean.save();
    }

    private ActIdentity createIdentity(String status, String error) {
        ActIdentity identity = (ActIdentity)this.service.create("actIdentity.syncTest", ActIdentity.class);
        IMObjectBean bean = this.service.getBean((IMObject)identity);
        bean.setValue("status", (Object)status);
        bean.setValue("error", (Object)error);
        bean.setValue("identity", (Object)UUID.randomUUID().toString());
        return identity;
    }

    private <T extends IMObject> List<T> getEntities(String archetype, Class<T> type) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(type);
        Root from = query.from(type, new String[]{archetype});
        query.where((Expression)builder.equal((Expression)from.get("active"), (Object)true));
        query.orderBy(new Order[]{builder.asc((Expression)from.get("id"))});
        return this.service.createQuery(query).getResultList();
    }
}

