/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.user;

import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.user.TestAuthorityBuilder;
import org.openvpms.archetype.test.builder.user.TestRoleBuilder;
import org.openvpms.archetype.test.builder.user.TestUserBuilder;
import org.openvpms.component.business.domain.im.security.ArchetypeAwareGrantedAuthority;
import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestUserFactory {
    private final ArchetypeService service;
    private final UserRules userRules;
    private final TestDocumentFactory documentFactory;

    public TestUserFactory(ArchetypeService service, UserRules userRules, TestDocumentFactory documentFactory) {
        this.service = service;
        this.userRules = userRules;
        this.documentFactory = documentFactory;
    }

    public User createUser() {
        return (User)this.newUser().build();
    }

    public User createUser(String username) {
        return (User)this.newUser().username(username).build();
    }

    public User createUser(String firstName, String lastName) {
        return (User)this.newUser().firstName(firstName).lastName(lastName).build();
    }

    public User createEmployee() {
        return (User)this.newUser().firstName(ValueStrategy.randomString()).lastName(ValueStrategy.randomString()).build();
    }

    public User createClinician() {
        return (User)this.newUser().clinician().build();
    }

    public User createClinician(String firstName, String lastName) {
        return (User)this.newUser().firstName(firstName).lastName(lastName).clinician().build();
    }

    public User createClinician(String title, String firstName, String lastName) {
        return (User)this.newUser().title(title).firstName(firstName).lastName(lastName).clinician().build();
    }

    public User createAdministrator() {
        return (User)this.newUser().administrator().build();
    }

    public TestUserBuilder newUser() {
        return new TestUserBuilder(this.service, this.userRules, this.documentFactory);
    }

    public TestUserBuilder updateUser(User user) {
        return new TestUserBuilder(user, this.service, this.userRules, this.documentFactory);
    }

    public SecurityRole createRole(ArchetypeAwareGrantedAuthority ... authorities) {
        return (SecurityRole)this.newRole().authorities(authorities).build();
    }

    public TestRoleBuilder newRole() {
        return new TestRoleBuilder(this.service);
    }

    public ArchetypeAwareGrantedAuthority createAuthority(String method, String archetype) {
        return (ArchetypeAwareGrantedAuthority)this.newAuthority().method(method).archetype(archetype).build();
    }

    public TestAuthorityBuilder newAuthority() {
        return new TestAuthorityBuilder(this.service);
    }
}

