/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.supplier;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.party.AbstractTestPartyBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.PeriodRelationship;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestVetBuilder
extends AbstractTestPartyBuilder<Party, TestVetBuilder> {
    private final Map<Party, Date> practices = new LinkedHashMap<Party, Date>();
    private String title;
    private ValueStrategy firstName = ValueStrategy.random();
    private ValueStrategy lastName = ValueStrategy.random("zvet");

    public TestVetBuilder(ArchetypeService service) {
        super("party.supplierVeterinarian", Party.class, service);
        this.title("DR");
        this.firstName = ValueStrategy.random();
        this.lastName = ValueStrategy.random();
    }

    public TestVetBuilder title(String title) {
        this.title = title;
        return this;
    }

    public TestVetBuilder firstName(String firstName) {
        this.firstName = ValueStrategy.value(firstName);
        return this;
    }

    public TestVetBuilder lastName(String lastName) {
        this.lastName = ValueStrategy.value(lastName);
        return this;
    }

    public TestVetBuilder addPractice(Party practice) {
        return this.addPractice(practice, new Date());
    }

    public TestVetBuilder addPractice(Party practice, Date started) {
        this.practices.put(practice, started);
        return this;
    }

    @Override
    protected void build(Party object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.title != null) {
            ((TestLookupBuilder)new TestLookupBuilder("lookup.personTitle", this.getService()).code(this.title)).build();
            bean.setValue("title", (Object)this.title);
        }
        bean.setValue("firstName", this.firstName.getValue());
        bean.setValue("lastName", this.lastName.getValue());
        if (!this.practices.isEmpty()) {
            for (Map.Entry<Party, Date> entry : this.practices.entrySet()) {
                Party practice = entry.getKey();
                PeriodRelationship relationship = (PeriodRelationship)bean.addSource("practices", (IMObject)practice, "veterinarians");
                relationship.setActiveStartTime(entry.getValue());
                toSave.add((IMObject)practice);
            }
            this.setEndDates(bean.getValues("practices", PeriodRelationship.class));
        }
    }
}

