/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.supplier;

import java.math.BigDecimal;
import org.openvpms.archetype.test.builder.act.AbstractTestActVerifier;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class TestSupplierActVerifier<V extends TestSupplierActVerifier<V>>
extends AbstractTestActVerifier<FinancialAct, V> {
    private ValueStrategy supplier = ValueStrategy.value(null);
    private ValueStrategy stockLocation = ValueStrategy.value(null);
    private ValueStrategy amount = ValueStrategy.value(null);
    private ValueStrategy tax = ValueStrategy.value(null);

    public TestSupplierActVerifier(ArchetypeService service) {
        super(service);
    }

    public V initialise(FinancialAct act) {
        IMObjectBean bean = this.getBean((IMObject)act);
        this.supplier(bean.getTargetRef("supplier"));
        this.stockLocation(bean.getTargetRef("stockLocation"));
        this.amount(bean.getBigDecimal("amount"));
        this.tax(bean.getBigDecimal("tax"));
        this.status(bean.getString("status"));
        return (V)((TestSupplierActVerifier)this.getThis());
    }

    public V supplier(Party supplier) {
        return this.supplier(supplier != null ? supplier.getObjectReference() : null);
    }

    public V supplier(Reference supplier) {
        this.supplier = ValueStrategy.value(supplier);
        return (V)((TestSupplierActVerifier)this.getThis());
    }

    public V stockLocation(Party stockLocation) {
        return this.stockLocation(stockLocation != null ? stockLocation.getObjectReference() : null);
    }

    public V stockLocation(Reference stockLocation) {
        this.stockLocation = ValueStrategy.value(stockLocation);
        return (V)((TestSupplierActVerifier)this.getThis());
    }

    public V amount(BigDecimal amount) {
        this.amount = ValueStrategy.value(amount);
        return (V)((TestSupplierActVerifier)this.getThis());
    }

    public V tax(BigDecimal tax) {
        this.tax = ValueStrategy.value(tax);
        return (V)((TestSupplierActVerifier)this.getThis());
    }

    @Override
    protected void verify(FinancialAct object, IMObjectBean bean) {
        super.verify(object, bean);
        this.checkEquals(this.supplier, bean.getTargetRef("supplier"));
        this.checkEquals(this.stockLocation, bean.getTargetRef("stockLocation"));
        this.checkEquals(this.amount, (Object)bean.getBigDecimal("amount"));
        this.checkEquals(this.tax, (Object)bean.getBigDecimal("tax"));
    }
}

