/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.supplier;

import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.openvpms.archetype.test.builder.act.AbstractTestActVerifier;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestSupplierActItemVerifier<B extends TestSupplierActItemVerifier<B>>
extends AbstractTestActVerifier<FinancialAct, B> {
    private ValueStrategy product = ValueStrategy.value(null);
    private ValueStrategy reorderCode = ValueStrategy.value(null);
    private ValueStrategy reorderDescription = ValueStrategy.value(null);
    private ValueStrategy packageSize = ValueStrategy.value(null);
    private ValueStrategy packageUnits = ValueStrategy.value(null);
    private ValueStrategy quantity = ValueStrategy.value(null);
    private ValueStrategy unitPrice = ValueStrategy.value(null);
    private ValueStrategy listPrice = ValueStrategy.value(null);
    private ValueStrategy tax = ValueStrategy.value(null);
    private ValueStrategy total = ValueStrategy.value(null);

    public TestSupplierActItemVerifier(ArchetypeService service) {
        super(service);
    }

    public B initialise(FinancialAct item) {
        IMObjectBean bean = this.getBean((IMObject)item);
        this.initialise(bean);
        return (B)((TestSupplierActItemVerifier)this.getThis());
    }

    public B product(Product product) {
        return this.product(product != null ? product.getObjectReference() : null);
    }

    public B product(Reference product) {
        this.product = ValueStrategy.value(product);
        return (B)((TestSupplierActItemVerifier)this.getThis());
    }

    public B reorderCode(String reorderCode) {
        this.reorderCode = ValueStrategy.value(reorderCode);
        return (B)((TestSupplierActItemVerifier)this.getThis());
    }

    public B reorderDescription(String reorderDescription) {
        this.reorderDescription = ValueStrategy.value(reorderDescription);
        return (B)((TestSupplierActItemVerifier)this.getThis());
    }

    public B packageSize(int packageSize) {
        this.packageSize = ValueStrategy.value(packageSize);
        return (B)((TestSupplierActItemVerifier)this.getThis());
    }

    public B packageUnits(String packageUnits) {
        this.packageUnits = ValueStrategy.value(packageUnits);
        return (B)((TestSupplierActItemVerifier)this.getThis());
    }

    public B quantity(int quantity) {
        return this.quantity(BigDecimal.valueOf(quantity));
    }

    public B quantity(BigDecimal quantity) {
        this.quantity = ValueStrategy.value(quantity);
        return (B)((TestSupplierActItemVerifier)this.getThis());
    }

    public B unitPrice(int unitPrice) {
        return this.unitPrice(BigDecimal.valueOf(unitPrice));
    }

    public B unitPrice(BigDecimal unitPrice) {
        this.unitPrice = ValueStrategy.value(unitPrice);
        return (B)((TestSupplierActItemVerifier)this.getThis());
    }

    public B listPrice(BigDecimal listPrice) {
        this.listPrice = ValueStrategy.value(listPrice);
        return (B)((TestSupplierActItemVerifier)this.getThis());
    }

    public B tax(BigDecimal tax) {
        this.tax = ValueStrategy.value(tax);
        return (B)((TestSupplierActItemVerifier)this.getThis());
    }

    public B total(BigDecimal total) {
        this.total = ValueStrategy.value(total);
        return (B)((TestSupplierActItemVerifier)this.getThis());
    }

    public FinancialAct verify(List<FinancialAct> items) {
        FinancialAct item = items.stream().filter(act -> {
            IMObjectBean bean = this.getBean((IMObject)act);
            return Objects.equals(this.product.getValue(), bean.getTargetRef("product"));
        }).findFirst().orElse(null);
        if (item == null) {
            Assert.fail((String)("Failed to find item for product=" + this.product));
        }
        this.verify(item);
        return item;
    }

    protected void initialise(IMObjectBean bean) {
        this.product(bean.getTargetRef("product"));
        this.reorderCode(bean.getString("reorderCode"));
        this.reorderDescription(bean.getString("reorderDescription"));
        this.packageSize(bean.getInt("packageSize"));
        this.packageUnits(bean.getString("packageUnits"));
        this.quantity(bean.getBigDecimal("quantity"));
        this.unitPrice(bean.getBigDecimal("unitPrice"));
        this.listPrice(bean.getBigDecimal("listPrice"));
        this.tax(bean.getBigDecimal("tax"));
        this.total(bean.getBigDecimal("total"));
    }

    @Override
    protected void verify(FinancialAct object, IMObjectBean bean) {
        super.verify(object, bean);
        this.checkEquals(this.product, bean.getTargetRef("product"));
        this.checkEquals(this.reorderCode, bean.getString("reorderCode"));
        this.checkEquals(this.reorderDescription, bean.getString("reorderDescription"));
        this.checkEquals(this.packageSize, bean.getValue("packageSize"));
        this.checkEquals(this.packageUnits, bean.getString("packageUnits"));
        this.checkEquals(this.quantity, (Object)bean.getBigDecimal("quantity"));
        this.checkEquals(this.unitPrice, (Object)bean.getBigDecimal("unitPrice"));
        this.checkEquals(this.listPrice, (Object)bean.getBigDecimal("listPrice"));
        this.checkEquals(this.tax, (Object)bean.getBigDecimal("tax"));
        this.checkEquals(this.total, (Object)bean.getBigDecimal("total"));
    }
}

