/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.scheduling;

import java.util.Set;
import java.util.UUID;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestSyncIdBuilder
extends AbstractTestIMObjectBuilder<ActIdentity, TestSyncIdBuilder> {
    private ValueStrategy identity = ValueStrategy.unset();
    private ValueStrategy status = ValueStrategy.unset();

    public TestSyncIdBuilder(ArchetypeService service) {
        super("actIdentity.syncTest", ActIdentity.class, service);
        this.identity(UUID.randomUUID().toString());
    }

    public TestSyncIdBuilder(String archetype, ArchetypeService service) {
        super(archetype, ActIdentity.class, service);
    }

    public TestSyncIdBuilder(ActIdentity object, ArchetypeService service) {
        super(object, service);
    }

    public TestSyncIdBuilder identity(String identity) {
        this.identity = ValueStrategy.value(identity);
        return this;
    }

    public TestSyncIdBuilder status(String status) {
        this.status = ValueStrategy.value(status);
        return this;
    }

    @Override
    public ActIdentity build() {
        return (ActIdentity)this.build(false);
    }

    @Override
    protected void build(ActIdentity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.identity.setValue(bean, "identity");
        this.status.setValue(bean, "status");
    }
}

