/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.scheduling;

import java.util.Set;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.scheduling.TestScheduleBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestRosterAreaBuilder
extends AbstractTestEntityBuilder<Entity, TestScheduleBuilder> {
    private Party location;
    private Entity[] schedules;

    public TestRosterAreaBuilder(ArchetypeService service) {
        super("entity.rosterArea", Entity.class, service);
        this.name(ValueStrategy.random("zrosterarea"));
    }

    public TestRosterAreaBuilder location(Party location) {
        this.location = location;
        return this;
    }

    public TestRosterAreaBuilder schedules(Entity ... schedules) {
        this.schedules = schedules;
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.location != null) {
            bean.setTarget("location", (IMObject)this.location);
        }
        if (this.schedules != null) {
            for (Entity schedule : this.schedules) {
                bean.addTarget("schedules", (IMObject)schedule);
            }
        }
    }
}

