/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.practice;

import java.util.Set;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.party.AbstractTestPartyBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestStockLocationBuilder
extends AbstractTestPartyBuilder<Party, TestStockLocationBuilder> {
    private Party[] locations;
    private User defaultAuthor;

    public TestStockLocationBuilder(ArchetypeService service) {
        super("party.organisationStockLocation", Party.class, service);
        this.name(ValueStrategy.random("zstock"));
    }

    public TestStockLocationBuilder(Party object, ArchetypeService service) {
        super(object, service);
    }

    public TestStockLocationBuilder locations(Party ... locations) {
        this.locations = locations;
        return this;
    }

    public TestStockLocationBuilder defaultAuthor(User defaultAuthor) {
        this.defaultAuthor = defaultAuthor;
        return this;
    }

    @Override
    protected void build(Party object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.locations != null) {
            for (Party location : this.locations) {
                bean.addSource("locations", (IMObject)location, "stockLocations");
                toSave.add((IMObject)location);
            }
        }
        if (this.defaultAuthor != null) {
            bean.setTarget("defaultAuthor", (IMObject)this.defaultAuthor);
        }
    }
}

