/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.practice;

import org.openvpms.archetype.test.builder.eft.TestEFTPOSTerminalBuilder;
import org.openvpms.archetype.test.builder.practice.TestDepartmentBuilder;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestMailServerBuilder;
import org.openvpms.archetype.test.builder.practice.TestOTCBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeBuilder;
import org.openvpms.archetype.test.builder.practice.TestStockLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestTillBuilder;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestPracticeFactory {
    private final ArchetypeService service;

    public TestPracticeFactory(ArchetypeService service) {
        this.service = service;
    }

    public Party getPractice() {
        return (Party)this.newPractice().build();
    }

    public TestPracticeBuilder newPractice() {
        return new TestPracticeBuilder(this.service);
    }

    public TestPracticeBuilder updatePractice(Party practice) {
        return new TestPracticeBuilder(practice, this.service);
    }

    public Party createLocation() {
        return (Party)this.newLocation().build();
    }

    public TestLocationBuilder newLocation() {
        return new TestLocationBuilder(this.service);
    }

    public TestLocationBuilder updateLocation(Party location) {
        return new TestLocationBuilder(location, this.service);
    }

    public Entity createEFTPOSTerminal() {
        return (Entity)this.newEFTPOSTerminal().build();
    }

    public TestEFTPOSTerminalBuilder newEFTPOSTerminal() {
        return new TestEFTPOSTerminalBuilder(this.service);
    }

    public Entity createTill() {
        return (Entity)this.newTill().build();
    }

    public TestTillBuilder newTill() {
        return new TestTillBuilder(this.service);
    }

    public TestTillBuilder updateTill(Entity till) {
        return new TestTillBuilder(till, this.service);
    }

    public Party createStockLocation(Party ... locations) {
        return (Party)this.newStockLocation().locations(locations).build();
    }

    public TestStockLocationBuilder newStockLocation() {
        return new TestStockLocationBuilder(this.service);
    }

    public TestStockLocationBuilder updateStockLocation(Party stockLocation) {
        return new TestStockLocationBuilder(stockLocation, this.service);
    }

    public Party createOTC() {
        return (Party)this.newOTC().build();
    }

    public TestOTCBuilder newOTC() {
        return new TestOTCBuilder(this.service);
    }

    public Entity createDepartment() {
        return (Entity)this.newDepartment().build();
    }

    public TestDepartmentBuilder newDepartment() {
        return new TestDepartmentBuilder(this.service);
    }

    public TestDepartmentBuilder updateDepartment(Entity department) {
        return new TestDepartmentBuilder(department, this.service);
    }

    public TestMailServerBuilder newMailServer() {
        return new TestMailServerBuilder(this.service);
    }
}

