/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.practice;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.lookup.TestCurrencyBuilder;
import org.openvpms.archetype.test.builder.lookup.TestTaxTypeBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.practice.AbstractTestOrganisationBuilder;
import org.openvpms.archetype.test.builder.user.TestUserBuilder;
import org.openvpms.component.math.WeightUnits;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestPracticeBuilder
extends AbstractTestOrganisationBuilder<TestPracticeBuilder> {
    private final List<Lookup> taxes = new ArrayList<Lookup>();
    private boolean removeTaxes = false;
    private Entity mailServer;
    private boolean removeMailServer = false;
    private String currencyCode;
    private Lookup currencyLookup;
    private User serviceUser;
    private Party[] locations;
    private ValueStrategy minQuantities = ValueStrategy.unset();
    private ValueStrategy minQuantitiesOverride = ValueStrategy.unset();
    private ValueStrategy departments = ValueStrategy.unset();
    private ValueStrategy showPricesTaxInclusive = ValueStrategy.unset();
    private ValueStrategy useLocationProducts = ValueStrategy.unset();
    private ValueStrategy useLoggedInClinician = ValueStrategy.unset();
    private ValueStrategy sellRestrictedDrugsOTC = ValueStrategy.unset();
    private ValueStrategy restrictOrdering = ValueStrategy.unset();
    private ValueStrategy pharmacyOrderDiscontinuePeriod = ValueStrategy.unset();
    private ValueStrategy pharmacyOrderDiscontinuePeriodUnits = ValueStrategy.unset();
    private ValueStrategy defaultWeightUnits = ValueStrategy.unset();
    private ValueStrategy prescriptionExpiryPeriod = ValueStrategy.unset();
    private ValueStrategy prescriptionExpiryUnits = ValueStrategy.unset();
    private ValueStrategy enablePlugins = ValueStrategy.unset();
    private ValueStrategy theme = ValueStrategy.unset();

    public TestPracticeBuilder(ArchetypeService service) {
        super("party.organisationPractice", service);
        this.name("zpractice");
        this.currencyCode = "AUD";
    }

    public TestPracticeBuilder(Party object, ArchetypeService service) {
        super(object, service);
    }

    public TestPracticeBuilder locations(Party ... locations) {
        this.locations = locations;
        return this;
    }

    public TestPracticeBuilder currency(String currency) {
        this.currencyCode = currency;
        return this;
    }

    public TestPracticeBuilder currency(Lookup currency) {
        this.currencyLookup = currency;
        return this.currency(currency != null ? currency.getCode() : null);
    }

    public TestPracticeBuilder taxTypes(BigDecimal ... rates) {
        this.removeTaxTypes();
        for (BigDecimal rate : rates) {
            this.addTaxType(rate);
        }
        return this;
    }

    public TestPracticeBuilder addTaxType(BigDecimal rate) {
        return this.addTaxType((Lookup)new TestTaxTypeBuilder(this.getService()).rate(rate).build(false));
    }

    public TestPracticeBuilder addTaxType(Lookup taxType) {
        this.taxes.add(taxType);
        return this;
    }

    public TestPracticeBuilder removeTaxTypes() {
        this.removeTaxes = true;
        this.taxes.clear();
        return this;
    }

    public TestPracticeBuilder mailServer(Entity mailServer) {
        this.mailServer = mailServer;
        this.removeMailServer = mailServer == null;
        return this;
    }

    public TestPracticeBuilder serviceUser() {
        return this.serviceUser((User)new TestUserBuilder(this.getService(), null, null).build());
    }

    public TestPracticeBuilder serviceUser(User serviceUser) {
        this.serviceUser = serviceUser;
        return this;
    }

    public TestPracticeBuilder minimumQuantities(boolean enable) {
        this.minQuantities = ValueStrategy.value(enable);
        return this;
    }

    public TestPracticeBuilder minimumQuantitiesOverride(String code) {
        this.minQuantitiesOverride = ValueStrategy.value(code);
        return this;
    }

    public TestPracticeBuilder departments(boolean departments) {
        this.departments = ValueStrategy.value(departments);
        return this;
    }

    public TestPracticeBuilder showPricesTaxInclusive(boolean showPricesTaxInclusive) {
        this.showPricesTaxInclusive = ValueStrategy.value(showPricesTaxInclusive);
        return this;
    }

    public TestPracticeBuilder useLocationProducts(boolean useLocationProducts) {
        this.useLocationProducts = ValueStrategy.value(useLocationProducts);
        return this;
    }

    public TestPracticeBuilder useLoggedInClinician(boolean useLoggedInClinician) {
        this.useLoggedInClinician = ValueStrategy.value(useLoggedInClinician);
        return this;
    }

    public TestPracticeBuilder sellRestrictedDrugsOTC(boolean sellRestrictedDrugsOTC) {
        this.sellRestrictedDrugsOTC = ValueStrategy.value(sellRestrictedDrugsOTC);
        return this;
    }

    public TestPracticeBuilder restrictOrdering(boolean restrictOrdering) {
        this.restrictOrdering = ValueStrategy.value(restrictOrdering);
        return this;
    }

    public TestPracticeBuilder pharmacyOrderDiscontinuePeriod(int period, DateUnits units) {
        this.pharmacyOrderDiscontinuePeriod = ValueStrategy.value(period);
        this.pharmacyOrderDiscontinuePeriodUnits = ValueStrategy.value(units.toString());
        return this;
    }

    public TestPracticeBuilder defaultWeightUnits(WeightUnits units) {
        this.defaultWeightUnits = ValueStrategy.value(units != null ? units.toString() : null);
        return this;
    }

    public TestPracticeBuilder prescriptionExpiryPeriod(int period, DateUnits units) {
        this.prescriptionExpiryPeriod = ValueStrategy.value(period);
        this.prescriptionExpiryUnits = ValueStrategy.value(units.toString());
        return this;
    }

    public TestPracticeBuilder enablePlugins() {
        return this.enablePlugins(true);
    }

    public TestPracticeBuilder enablePlugins(boolean enablePlugins) {
        this.enablePlugins = ValueStrategy.value(enablePlugins);
        return this;
    }

    public TestPracticeBuilder theme(String theme) {
        this.theme = ValueStrategy.value(theme);
        return this;
    }

    @Override
    protected Party getObject(String archetype) {
        Party practice = (Party)this.getExisting();
        if (practice == null && !(practice = this.getSingleton("party.organisationPractice", Party.class)).isNew()) {
            this.resetValues(practice);
        }
        return practice;
    }

    @Override
    protected void build(Party object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.locations != null) {
            for (Party location : this.locations) {
                bean.addTarget("locations", (IMObject)location, "practice");
                toSave.add((IMObject)location);
            }
            this.locations = null;
        }
        if (this.currencyLookup == null && this.currencyCode != null) {
            this.currencyLookup = (Lookup)((TestCurrencyBuilder)new TestCurrencyBuilder(this.getService()).code(this.currencyCode)).build();
        }
        if (this.currencyLookup != null) {
            bean.setValue("currency", (Object)this.currencyLookup.getCode());
        }
        if (this.serviceUser != null) {
            bean.setTarget("serviceUser", (IMObject)this.serviceUser);
        }
        this.minQuantities.setValue(bean, "minimumQuantities");
        this.minQuantitiesOverride.setValue(bean, "minimumQuantitiesOverride");
        this.departments.setValue(bean, "departments");
        this.showPricesTaxInclusive.setValue(bean, "showPricesTaxInclusive");
        this.useLocationProducts.setValue(bean, "useLocationProducts");
        this.useLoggedInClinician.setValue(bean, "useLoggedInClinician");
        this.sellRestrictedDrugsOTC.setValue(bean, "sellRestrictedDrugsOTC");
        this.restrictOrdering.setValue(bean, "restrictOrdering");
        this.pharmacyOrderDiscontinuePeriod.setValue(bean, "pharmacyOrderDiscontinuePeriod");
        this.pharmacyOrderDiscontinuePeriodUnits.setValue(bean, "pharmacyOrderDiscontinuePeriodUnits");
        if (this.removeTaxes) {
            bean.removeValues("taxes");
        }
        for (Lookup tax : this.taxes) {
            object.addClassification(tax);
        }
        this.taxes.clear();
        this.removeTaxes = false;
        if (this.mailServer != null) {
            bean.setTarget("mailServer", (IMObject)this.mailServer);
        } else if (this.removeMailServer) {
            bean.removeValues("mailServer");
        }
        this.defaultWeightUnits.setValue(bean, "defaultWeightUnits");
        this.prescriptionExpiryPeriod.setValue(bean, "prescriptionExpiryPeriod");
        this.prescriptionExpiryUnits.setValue(bean, "prescriptionExpiryUnits");
        this.enablePlugins.setValue(bean, "enablePlugins");
        this.theme.setValue(bean, "theme");
    }

    private void resetValues(Party practice) {
        IMObjectBean bean = this.getBean((IMObject)practice);
        for (Contact contact : bean.getValues("contacts", Contact.class)) {
            practice.removeContact(contact);
        }
        for (Party location : bean.getTargets("locations", Party.class)) {
            bean.removeTarget("locations", (IMObject)location);
        }
        for (Lookup tax : bean.getValues("taxes", Lookup.class)) {
            bean.removeValue("taxes", (IMObject)tax);
        }
        this.useLocationProducts.reset(bean, "useLocationProducts");
        this.useLoggedInClinician.reset(bean, "useLoggedInClinician");
        this.sellRestrictedDrugsOTC.reset(bean, "sellRestrictedDrugsOTC");
        this.restrictOrdering.reset(bean, "restrictOrdering");
        this.defaultWeightUnits.reset(bean, "defaultWeightUnits");
        this.prescriptionExpiryPeriod.reset(bean, "prescriptionExpiryPeriod");
        this.prescriptionExpiryUnits.reset(bean, "prescriptionExpiryUnits");
        bean.removeValues("serviceUser");
    }
}

