/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient.reminder;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.patient.reminder.ReminderType;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.lookup.AbstractTestLookupBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.lookup.TestSpeciesBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderCountBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestReminderTypeBuilder
extends AbstractTestEntityBuilder<Entity, TestReminderTypeBuilder> {
    private final List<Entity> reminderCounts = new ArrayList<Entity>();
    private ValueStrategy groupBy = ValueStrategy.unset();
    private ValueStrategy interactive = ValueStrategy.unset();
    private ValueStrategy defaultInterval = ValueStrategy.unset();
    private ValueStrategy defaultUnits = ValueStrategy.unset();
    private ValueStrategy cancelInterval = ValueStrategy.unset();
    private ValueStrategy cancelUnits = ValueStrategy.unset();
    private ValueStrategy sensitivityInterval = ValueStrategy.unset();
    private ValueStrategy sensitivityUnits = ValueStrategy.unset();
    private String[] species;
    private String[] groups;

    public TestReminderTypeBuilder(ArchetypeService service) {
        super("entity.reminderType", Entity.class, service);
        this.name(ValueStrategy.random("zremindertype"));
    }

    public TestReminderTypeBuilder(Entity object, ArchetypeService service) {
        super(object, service);
    }

    public TestReminderTypeBuilder groupBy(ReminderType.GroupBy groupBy) {
        this.groupBy = ValueStrategy.value(groupBy != null ? groupBy.toString() : null);
        return this;
    }

    public TestReminderTypeBuilder interactive(boolean interactive) {
        this.interactive = ValueStrategy.value(interactive);
        return this;
    }

    public TestReminderTypeBuilder defaultInterval(int interval, DateUnits units) {
        this.defaultInterval = ValueStrategy.value(interval);
        this.defaultUnits = ValueStrategy.value(units.toString());
        return this;
    }

    public TestReminderTypeBuilder cancelInterval(int interval, DateUnits units) {
        this.cancelInterval = ValueStrategy.value(interval);
        this.cancelUnits = ValueStrategy.value(units.toString());
        return this;
    }

    public TestReminderTypeBuilder sensitivityInterval(int interval, DateUnits units) {
        this.sensitivityInterval = ValueStrategy.value(interval);
        this.sensitivityUnits = ValueStrategy.value(units.toString());
        return this;
    }

    public TestReminderCountBuilder newCount() {
        return new TestReminderCountBuilder(this, this.getService());
    }

    public TestReminderTypeBuilder addReminderCount(Entity count) {
        this.reminderCounts.add(count);
        return this;
    }

    public TestReminderTypeBuilder addSpecies(String ... species) {
        this.species = species;
        return this;
    }

    public TestReminderTypeBuilder addGroups(Lookup ... groups) {
        for (Lookup group : groups) {
            this.addGroups(group.getCode());
        }
        return this;
    }

    public TestReminderTypeBuilder addGroups(String ... groups) {
        this.groups = groups;
        return this;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        Lookup lookup;
        AbstractTestLookupBuilder builder;
        super.build(object, bean, toSave, toRemove);
        this.groupBy.setValue(bean, "groupBy");
        this.interactive.setValue(bean, "interactive");
        this.defaultInterval.setValue(bean, "defaultInterval");
        this.defaultUnits.setValue(bean, "defaultUnits");
        this.cancelInterval.setValue(bean, "cancelInterval");
        this.cancelUnits.setValue(bean, "cancelUnits");
        this.sensitivityInterval.setValue(bean, "sensitivityInterval");
        this.sensitivityUnits.setValue(bean, "sensitivityUnits");
        for (Entity count : this.reminderCounts) {
            bean.addTarget("counts", (IMObject)count);
            toSave.add((IMObject)count);
        }
        this.reminderCounts.clear();
        if (this.species != null && this.species.length != 0) {
            builder = new TestSpeciesBuilder(this.getService());
            for (String code : this.species) {
                lookup = (Lookup)((TestSpeciesBuilder)builder.code(code)).build();
                object.addClassification(lookup);
            }
        }
        if (this.groups != null) {
            builder = new TestLookupBuilder("lookup.reminderGroup", this.getService());
            for (String group : this.groups) {
                lookup = (Lookup)((TestLookupBuilder)builder.code(group)).build();
                object.addClassification(lookup);
            }
        }
    }
}

