/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.patient.reminder;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderRuleBuilder;
import org.openvpms.archetype.test.builder.patient.reminder.TestReminderTypeBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestReminderCountBuilder
extends AbstractTestEntityBuilder<Entity, TestReminderTypeBuilder> {
    private final TestReminderTypeBuilder parent;
    private ValueStrategy count = ValueStrategy.unset();
    private ValueStrategy interval = ValueStrategy.unset();
    private ValueStrategy units = ValueStrategy.unset();
    private Entity template;
    private final List<Entity> rules = new ArrayList<Entity>();

    public TestReminderCountBuilder(TestReminderTypeBuilder parent, ArchetypeService service) {
        super("entity.reminderCount", Entity.class, service);
        this.parent = parent;
    }

    public TestReminderCountBuilder count(int count) {
        this.count = ValueStrategy.value(count);
        return this;
    }

    public TestReminderCountBuilder interval(int interval, DateUnits units) {
        this.interval = ValueStrategy.value(interval);
        this.units = ValueStrategy.value(units);
        return this;
    }

    public TestReminderCountBuilder template(Entity template) {
        this.template = template;
        return this;
    }

    public TestReminderRuleBuilder newRule() {
        return new TestReminderRuleBuilder(this, this.getService());
    }

    public TestReminderCountBuilder addRule(Entity rule) {
        this.rules.add(rule);
        return this;
    }

    public TestReminderTypeBuilder add() {
        Entity count = (Entity)this.build();
        this.parent.addReminderCount(count);
        return this.parent;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.count.setValue(bean, "count");
        this.interval.setValue(bean, "interval");
        this.units.setValue(bean, "units");
        bean.setTarget("template", (IMObject)this.template);
        for (Entity rule : this.rules) {
            bean.addTarget("rules", (IMObject)rule);
            toSave.add((IMObject)rule);
        }
        this.rules.clear();
    }
}

