/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.party;

import java.util.Set;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.party.AbstractTestContactBuilder;
import org.openvpms.archetype.test.builder.party.AbstractTestPartyBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestLocationContactBuilder<T extends Party, P extends AbstractTestPartyBuilder<T, P>>
extends AbstractTestContactBuilder<T, P, TestLocationContactBuilder<T, P>> {
    private ValueStrategy address = ValueStrategy.unset();
    private ValueStrategy suburbCode = ValueStrategy.unset();
    private ValueStrategy suburbName = ValueStrategy.unset();
    private ValueStrategy stateCode = ValueStrategy.unset();
    private ValueStrategy stateName = ValueStrategy.unset();
    private ValueStrategy postcode = ValueStrategy.unset();

    public TestLocationContactBuilder(ArchetypeService service) {
        super("contact.location", service);
    }

    public TestLocationContactBuilder(P parent, ArchetypeService service) {
        super(parent, "contact.location", service);
    }

    public TestLocationContactBuilder(Contact object, ArchetypeService service) {
        super(object, service);
    }

    public TestLocationContactBuilder<T, P> address(String address) {
        this.address = ValueStrategy.value(address);
        return this;
    }

    public TestLocationContactBuilder<T, P> suburb(String code, String name) {
        this.suburbCode(code);
        return this.suburbName(name);
    }

    public TestLocationContactBuilder<T, P> suburbCode(String suburbCode) {
        this.suburbCode = ValueStrategy.value(suburbCode);
        return this;
    }

    public TestLocationContactBuilder<T, P> suburbName(String suburbName) {
        this.suburbName = ValueStrategy.value(suburbName);
        return this;
    }

    public TestLocationContactBuilder<T, P> state(String stateCode, String stateName) {
        this.stateCode(stateCode);
        return this.stateName(stateName);
    }

    public TestLocationContactBuilder<T, P> stateCode(String stateCode) {
        this.stateCode = ValueStrategy.value(stateCode);
        return this;
    }

    public TestLocationContactBuilder<T, P> stateName(String stateName) {
        this.stateName = ValueStrategy.value(stateName);
        return this;
    }

    public TestLocationContactBuilder<T, P> postcode(String postcode) {
        this.postcode = ValueStrategy.value(postcode);
        return this;
    }

    @Override
    protected void build(Contact object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        String code;
        Lookup state = null;
        Lookup suburb = null;
        if (this.stateCode.isSet()) {
            state = (Lookup)((TestLookupBuilder)((TestLookupBuilder)new TestLookupBuilder("lookup.state", this.getService()).code(this.stateCode)).name(this.stateName)).build();
        }
        if (this.suburbCode.isSet()) {
            TestLookupBuilder builder = (TestLookupBuilder)((TestLookupBuilder)new TestLookupBuilder("lookup.suburb", this.getService()).code(this.suburbCode)).name(this.suburbName);
            if (state != null) {
                builder.source(state);
            }
            suburb = (Lookup)builder.build();
            if (state == null && this.stateCode.isUnset() && (state = (Lookup)this.getBean((IMObject)suburb).getSource("target", Lookup.class)) != null) {
                this.stateCode = ValueStrategy.value(state.getCode());
            }
        }
        this.address.setValue(bean, "address");
        this.suburbCode.setValue(bean, "suburb");
        this.stateCode.setValue(bean, "state");
        if (this.postcode.isUnset() && suburb != null && (code = this.getBean((IMObject)suburb).getString("postCode")) != null) {
            this.postcode = ValueStrategy.value(code);
        }
        this.postcode.setValue(bean, "postcode");
        super.build(object, bean, toSave, toRemove);
    }
}

