/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.object;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.openvpms.component.model.object.IMObject;

public class BuiltObjects {
    private final IMObject root;
    private final Set<IMObject> objects;

    public BuiltObjects(IMObject root, Set<IMObject> objects) {
        this.root = root;
        this.objects = objects;
    }

    public IMObject getRoot() {
        return this.root;
    }

    public <T extends IMObject> T getRoot(Class<T> type) {
        return (T)((IMObject)type.cast(this.root));
    }

    public List<IMObject> getObjects(String archetype) {
        return this.objects.stream().filter(object -> object.isA(archetype)).collect(Collectors.toList());
    }

    public <T extends IMObject> List<T> getObjects(String archetype, Class<T> type) {
        return this.getObjects(archetype).stream().map(type::cast).collect(Collectors.toList());
    }

    public <T extends IMObject> T getObject(String archetype, Class<T> type) {
        List<T> matches = this.getObjects(archetype, type);
        Assert.assertEquals((long)1L, (long)matches.size());
        return (T)((IMObject)matches.get(0));
    }
}

