/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.lookup;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.test.builder.lookup.AbstractTestLookupBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestTaxTypeBuilder
extends AbstractTestLookupBuilder<TestTaxTypeBuilder> {
    private ValueStrategy rate = ValueStrategy.unset();
    private ValueStrategy taxScheme = ValueStrategy.unset();
    private ValueStrategy taxCategory = ValueStrategy.unset();

    public TestTaxTypeBuilder(ArchetypeService service) {
        super("lookup.taxType", service);
        this.code(ValueStrategy.random("ZTAXTYPE").toString());
    }

    public TestTaxTypeBuilder rate(int rate) {
        return this.rate(BigDecimal.valueOf(rate));
    }

    public TestTaxTypeBuilder rate(BigDecimal rate) {
        this.rate = ValueStrategy.value(rate);
        return this;
    }

    public TestTaxTypeBuilder taxScheme(String taxScheme) {
        this.taxScheme = ValueStrategy.value(taxScheme);
        return this;
    }

    public TestTaxTypeBuilder taxCategory(String taxCategory) {
        this.taxCategory = ValueStrategy.value(taxCategory);
        return this;
    }

    @Override
    protected void build(Lookup object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.rate.setValue(bean, "rate");
        this.taxScheme.setValue(bean, "taxScheme");
        this.taxCategory.setValue(bean, "taxCategory");
    }
}

