/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.laboratory;

import java.util.UUID;
import org.openvpms.archetype.test.builder.laboratory.TestDeviceBuilder;
import org.openvpms.archetype.test.builder.laboratory.TestHL7LaboratoryBuilder;
import org.openvpms.archetype.test.builder.laboratory.TestHL7LaboratoryGroupBuilder;
import org.openvpms.archetype.test.builder.laboratory.TestInvestigationTypeBuilder;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryBuilder;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryHL7TestBuilder;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryTestBuilder;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestLaboratoryFactory {
    private final ArchetypeService service;

    public TestLaboratoryFactory(ArchetypeService service) {
        this.service = service;
    }

    public Entity createInvestigationType() {
        return (Entity)this.newInvestigationType().build();
    }

    public Entity createInvestigationType(Entity laboratory) {
        return (Entity)this.newInvestigationType().laboratory(laboratory).build();
    }

    public TestInvestigationTypeBuilder newInvestigationType() {
        return new TestInvestigationTypeBuilder(this.service);
    }

    public Entity createLaboratory() {
        return (Entity)this.newLaboratory().build();
    }

    public Entity createLaboratory(Party ... locations) {
        return (Entity)this.newLaboratory().locations(locations).build();
    }

    public TestLaboratoryBuilder newLaboratory() {
        return new TestLaboratoryBuilder(this.service);
    }

    public TestLaboratoryBuilder newLaboratory(String archetype) {
        return new TestLaboratoryBuilder(archetype, this.service);
    }

    public Entity createDevice(Entity laboratory) {
        return (Entity)this.newDevice().laboratory(laboratory).build();
    }

    public Entity createDevice(Entity laboratory, Party ... locations) {
        return (Entity)this.newDevice().laboratory(laboratory).locations(locations).build();
    }

    public TestDeviceBuilder newDevice() {
        return new TestDeviceBuilder(this.service);
    }

    public TestDeviceBuilder newDevice(String archetype) {
        return new TestDeviceBuilder(archetype, this.service);
    }

    public Entity createTest(Entity investigationType) {
        return (Entity)((TestLaboratoryTestBuilder)this.newTest().investigationType(investigationType)).build();
    }

    public TestLaboratoryTestBuilder newTest() {
        return new TestLaboratoryTestBuilder(this.service);
    }

    public Entity createHL7Laboratory(Party location, User user) {
        return (Entity)this.newHL7Laboratory().location(location).user(user).build();
    }

    public TestHL7LaboratoryBuilder newHL7Laboratory() {
        return new TestHL7LaboratoryBuilder(this.service);
    }

    public Entity createHL7LaboratoryGroup(Entity ... laboratories) {
        return (Entity)new TestHL7LaboratoryGroupBuilder(this.service).laboratories(laboratories).build();
    }

    public Entity createHL7Test(Entity investigationType) {
        return (Entity)((TestLaboratoryHL7TestBuilder)this.newHL7Test().investigationType(investigationType)).build();
    }

    public TestLaboratoryHL7TestBuilder newHL7Test() {
        return new TestLaboratoryHL7TestBuilder(this.service);
    }

    public ActIdentity createOrderIdentity() {
        ActIdentity identity = (ActIdentity)this.service.create("actIdentity.laboratoryOrderTest", ActIdentity.class);
        identity.setIdentity(UUID.randomUUID().toString());
        return identity;
    }
}

