/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.job.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.job.AbstractTestJobBuilder;
import org.openvpms.archetype.test.builder.job.account.TestAccountReminderCountBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestAccountReminderJobBuilder
extends AbstractTestJobBuilder<TestAccountReminderJobBuilder> {
    private final List<Entity> counts = new ArrayList<Entity>();
    private BigDecimal minBalance;
    private List<Entity> builtCounts = new ArrayList<Entity>();

    public TestAccountReminderJobBuilder(ArchetypeService service) {
        super("entity.jobAccountReminder", service);
    }

    public TestAccountReminderJobBuilder minBalance(BigDecimal minBalance) {
        this.minBalance = minBalance;
        return this;
    }

    public TestAccountReminderJobBuilder count(int interval, DateUnits units, Entity template) {
        return this.count().interval(interval, units).template(template).add();
    }

    public TestAccountReminderCountBuilder count() {
        return new TestAccountReminderCountBuilder(this, this.getService());
    }

    public TestAccountReminderJobBuilder add(Entity count) {
        this.counts.add(count);
        return this;
    }

    public List<Entity> getCounts() {
        return this.builtCounts;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.minBalance != null) {
            bean.setValue("minBalance", (Object)this.minBalance);
        }
        for (Entity count : this.counts) {
            int sequence = this.getNextSequence(bean, "reminders");
            EntityLink relationship = (EntityLink)bean.addTarget("reminders", (IMObject)count);
            relationship.setSequence(sequence);
        }
        toSave.addAll(this.counts);
        this.builtCounts = new ArrayList<Entity>(this.counts);
        this.counts.clear();
    }
}

