/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.job.account;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.builder.doc.TestSMSTemplateBuilder;
import org.openvpms.archetype.test.builder.entity.AbstractTestEntityBuilder;
import org.openvpms.archetype.test.builder.job.account.TestAccountReminderJobBuilder;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestAccountReminderCountBuilder
extends AbstractTestEntityBuilder<Entity, TestAccountReminderCountBuilder> {
    private final TestAccountReminderJobBuilder parent;
    private Integer interval;
    private DateUnits units;
    private Entity template;

    public TestAccountReminderCountBuilder(TestAccountReminderJobBuilder parent, ArchetypeService service) {
        super("entity.accountReminderCount", Entity.class, service);
        this.parent = parent;
    }

    public TestAccountReminderCountBuilder interval(int interval, DateUnits units) {
        this.interval = interval;
        this.units = units;
        return this;
    }

    public TestAccountReminderCountBuilder template(String template) {
        return this.template((Entity)new TestSMSTemplateBuilder("entity.documentTemplateSMSAccount", this.getService()).contentType("XPATH").content(template).build());
    }

    public TestAccountReminderCountBuilder template(Entity template) {
        this.template = template;
        return this;
    }

    public TestAccountReminderJobBuilder add() {
        HashSet<IMObject> objects = new HashSet<IMObject>();
        Entity count = (Entity)this.build(objects, new LinkedHashSet<Reference>());
        this.parent.add(count);
        this.parent.collect(objects);
        return this.parent;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.interval != null) {
            bean.setValue("interval", (Object)this.interval);
        }
        if (this.units != null) {
            bean.setValue("units", (Object)this.units.toString());
        }
        if (this.template != null) {
            bean.setTarget("smsTemplate", (IMObject)this.template);
            toSave.add((IMObject)this.template);
        }
    }
}

