/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.insurance;

import org.openvpms.archetype.test.builder.insurance.TestClaimBuilder;
import org.openvpms.archetype.test.builder.insurance.TestClaimItemBuilder;
import org.openvpms.archetype.test.builder.insurance.TestInsurerBuilder;
import org.openvpms.archetype.test.builder.insurance.TestPolicyBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestInsuranceFactory {
    private final ArchetypeService service;

    public TestInsuranceFactory(ArchetypeService service) {
        this.service = service;
    }

    public Party createInsurer() {
        return (Party)this.newInsurer().build();
    }

    public Party createInsurer(String name) {
        return (Party)((TestInsurerBuilder)this.newInsurer().name(name)).build();
    }

    public TestInsurerBuilder newInsurer() {
        return new TestInsurerBuilder(this.service);
    }

    public TestInsurerBuilder updateInsurer(Party insurer) {
        return new TestInsurerBuilder(insurer, this.service);
    }

    public Act createPolicy(Party customer, Party patient, Party insurer, String policyNumber) {
        return (Act)this.newPolicy().customer(customer).patient(patient).insurer(insurer).policyNumber(policyNumber).build();
    }

    public TestPolicyBuilder newPolicy() {
        return new TestPolicyBuilder(this.service);
    }

    public TestPolicyBuilder updatePolicy(Act policy) {
        return new TestPolicyBuilder(policy, this.service);
    }

    public TestClaimBuilder newClaim() {
        return new TestClaimBuilder(this.service);
    }

    public TestClaimItemBuilder newClaimItem() {
        return new TestClaimItemBuilder(null, this.service);
    }

    public TestClaimBuilder updateClaim(FinancialAct claim) {
        return new TestClaimBuilder(claim, this.service);
    }

    public Entity createInsuranceService() {
        Entity insuranceService = (Entity)this.service.create("entity.insuranceServiceTest", Entity.class);
        insuranceService.setName(ValueStrategy.random("Test Insurance Service").toString());
        this.service.save((IMObject)insuranceService);
        return insuranceService;
    }
}

