/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.insurance;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.openvpms.archetype.test.builder.insurance.TestClaimAttachmentBuilder;
import org.openvpms.archetype.test.builder.insurance.TestClaimItemBuilder;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestClaimBuilder
extends AbstractTestIMObjectBuilder<FinancialAct, TestClaimBuilder> {
    private final List<FinancialAct> items = new ArrayList<FinancialAct>();
    private final List<FinancialAct> builtItems = new ArrayList<FinancialAct>();
    private final List<TestClaimAttachmentBuilder> attachments = new ArrayList<TestClaimAttachmentBuilder>();
    private final List<DocumentAct> builtAttachments = new ArrayList<DocumentAct>();
    private Act policy;
    private String insurerIdArchetype;
    private ValueStrategy insurerId;
    private User clinician;
    private Party location;
    private ValueStrategy date = ValueStrategy.unset();
    private User claimHandler;
    private ValueStrategy status = ValueStrategy.unset();
    private ValueStrategy gapClaim = ValueStrategy.unset();
    private ValueStrategy gapStatus = ValueStrategy.unset();
    private BigDecimal paid;
    private boolean fullyPaid;
    private ValueStrategy benefitAmount = ValueStrategy.unset();

    public TestClaimBuilder(ArchetypeService service) {
        super("act.patientInsuranceClaim", FinancialAct.class, service);
    }

    public TestClaimBuilder(FinancialAct object, ArchetypeService service) {
        super(object, service);
    }

    public TestClaimBuilder policy(Act policy) {
        this.policy = policy;
        return this;
    }

    public TestClaimBuilder claimId(String archetype, String id) {
        return this.claimId(archetype, ValueStrategy.value(id));
    }

    public TestClaimBuilder claimId(String archetype, ValueStrategy id) {
        this.insurerIdArchetype = archetype;
        this.insurerId = id;
        return this;
    }

    public TestClaimBuilder clinician(User clinician) {
        this.clinician = clinician;
        return this;
    }

    public TestClaimBuilder location(Party location) {
        this.location = location;
        return this;
    }

    public TestClaimBuilder date(String date) {
        return this.date(this.parseDate(date));
    }

    public TestClaimBuilder date(Date date) {
        this.date = ValueStrategy.value(date);
        return this;
    }

    public TestClaimBuilder claimHandler(User claimHandler) {
        this.claimHandler = claimHandler;
        return this;
    }

    public TestClaimBuilder status(String status) {
        this.status = ValueStrategy.value(status);
        return this;
    }

    public TestClaimBuilder gapClaim(boolean gapClaim) {
        this.gapClaim = ValueStrategy.value(gapClaim);
        return this;
    }

    public TestClaimBuilder gapStatus(String gapStatus) {
        this.gapStatus = ValueStrategy.value(gapStatus);
        return this;
    }

    public TestClaimBuilder paid(BigDecimal paid) {
        this.paid = paid;
        return this;
    }

    public TestClaimBuilder fullyPaid() {
        this.fullyPaid = true;
        return this;
    }

    public TestClaimBuilder benefitAmount(BigDecimal benefitAmount) {
        this.benefitAmount = ValueStrategy.value(benefitAmount);
        return this;
    }

    public TestClaimBuilder addItem(FinancialAct item) {
        this.items.add(item);
        return this;
    }

    public TestClaimItemBuilder item() {
        return new TestClaimItemBuilder(this, this.getService());
    }

    public TestClaimBuilder item(FinancialAct ... invoiceItems) {
        return this.item(new Date(), new Date(), invoiceItems);
    }

    public TestClaimBuilder item(Date treatmentStart, Date treatmentEnd, FinancialAct ... invoiceItems) {
        return this.item().treatmentDates(treatmentStart, treatmentEnd).invoiceItems(invoiceItems).add();
    }

    public List<FinancialAct> getItems() {
        return this.builtItems;
    }

    public TestClaimBuilder attachment(Act act) {
        return this.attachment().original(act).add();
    }

    public TestClaimBuilder attachments(Act ... acts) {
        for (Act act : acts) {
            this.attachment(act);
        }
        return this;
    }

    public TestClaimAttachmentBuilder attachment() {
        return new TestClaimAttachmentBuilder(this, this.getService());
    }

    public List<DocumentAct> getAttachments() {
        return this.builtAttachments;
    }

    protected void addAttachment(TestClaimAttachmentBuilder attachment) {
        this.attachments.add(attachment);
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        if (this.insurerIdArchetype != null && this.insurerId != null) {
            object.addIdentity(this.createActIdentity(this.insurerIdArchetype, this.insurerId));
        }
        IMObjectBean policyBean = this.getBean((IMObject)this.policy);
        if (this.policy != null) {
            bean.addTarget("policy", (IMObject)this.policy, "claims");
            bean.setTarget("patient", policyBean.getTargetRef("patient"));
        }
        if (this.clinician != null) {
            bean.setTarget("clinician", (IMObject)this.clinician);
        }
        if (this.location != null) {
            bean.setTarget("location", (IMObject)this.location);
        }
        this.date.setValue(bean, "startTime");
        if (this.claimHandler != null) {
            bean.setTarget("user", (IMObject)this.claimHandler);
        }
        this.status.setValue(bean, "status");
        this.gapClaim.setValue(bean, "gapClaim");
        this.gapStatus.setValue(bean, "status2");
        if (!this.items.isEmpty()) {
            BigDecimal total = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            this.builtItems.clear();
            for (FinancialAct item : this.items) {
                bean.addTarget("items", (IMObject)item, "claim");
                total = total.add(item.getTotal());
                tax = tax.add(item.getTaxAmount());
                toSave.add((IMObject)item);
                this.builtItems.add(item);
            }
            bean.setValue("amount", (Object)total);
            bean.setValue("tax", (Object)tax);
        }
        if (this.paid != null) {
            bean.setValue("paid", (Object)this.paid);
        }
        if (this.fullyPaid) {
            bean.setValue("paid", (Object)bean.getBigDecimal("amount"));
        }
        this.benefitAmount.setValue(bean, "benefitAmount");
        this.builtAttachments.clear();
        for (TestClaimAttachmentBuilder builder : this.attachments) {
            DocumentAct attachment = (DocumentAct)builder.build(toSave, toRemove);
            if (attachment.isNew()) {
                bean.addTarget("attachments", (IMObject)attachment, "claim");
            }
            toSave.add((IMObject)attachment);
            this.builtAttachments.add(attachment);
        }
        this.items.clear();
        this.attachments.clear();
    }

    public static enum Status {
        PENDING,
        POSTED,
        SUBMITTED,
        ACCEPTED,
        SETTLED,
        DECLINED,
        CANCELLING,
        CANCELLED;

    }
}

