/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.doc;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.TemplateHelper;
import org.openvpms.archetype.test.builder.doc.AbstractTestDocumentTemplateBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplatePrinterBuilder;
import org.openvpms.archetype.test.builder.doc.TestEmailTemplateBuilder;
import org.openvpms.archetype.test.builder.doc.TestSMSTemplateBuilder;
import org.openvpms.archetype.test.builder.lookup.TestLookupBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDocumentTemplateBuilder
extends AbstractTestDocumentTemplateBuilder<TestDocumentTemplateBuilder> {
    private final Map<EntityRelationship, Party> printers = new LinkedHashMap<EntityRelationship, Party>();
    private String type;
    private boolean singletonByType;
    private boolean singletonByContent;
    private String contentName;
    private ValueStrategy userLevel = ValueStrategy.unset();
    private String reportType;
    private ValueStrategy printMode = ValueStrategy.unset();
    private ValueStrategy paperSize = ValueStrategy.unset();
    private ValueStrategy orientation = ValueStrategy.unset();
    private ValueStrategy outputFormat = ValueStrategy.unset();
    private ValueStrategy copies = ValueStrategy.unset();
    private ValueStrategy paperHeight = ValueStrategy.unset();
    private ValueStrategy paperWidth = ValueStrategy.unset();
    private ValueStrategy paperUnits = ValueStrategy.unset();
    private Entity emailTemplate;
    private Entity smsTemplate;
    private static final Logger log = LoggerFactory.getLogger(TestDocumentTemplateBuilder.class);

    public TestDocumentTemplateBuilder(ArchetypeService service, DocumentHandlers handlers) {
        super("entity.documentTemplate", service, handlers);
        this.name(ValueStrategy.random("zdocumenttemplate"));
    }

    TestDocumentTemplateBuilder(Entity template, ArchetypeService service, DocumentHandlers handlers) {
        super(template, service, handlers);
    }

    public TestDocumentTemplateBuilder type(String type) {
        this.type = type;
        return this;
    }

    public TestDocumentTemplateBuilder singletonByType() {
        this.singletonByType = true;
        return this;
    }

    public TestDocumentTemplateBuilder singletonByContent(String name) {
        this.singletonByContent = true;
        this.contentName = name;
        return this;
    }

    public TestDocumentTemplateBuilder userLevel(String userLevel) {
        this.userLevel = ValueStrategy.value(userLevel);
        return this;
    }

    public TestDocumentTemplateBuilder reportType(String reportType) {
        this.reportType = reportType;
        return this;
    }

    public TestDocumentTemplateBuilder printMode(DocumentTemplate.PrintMode printMode) {
        this.printMode = ValueStrategy.value(printMode != null ? printMode.toString() : null);
        return this;
    }

    public TestDocumentTemplateBuilder paperSize(String paperSize) {
        this.paperSize = ValueStrategy.value(paperSize);
        return this;
    }

    public TestDocumentTemplateBuilder orientation(String orientation) {
        this.orientation = ValueStrategy.value(orientation);
        return this;
    }

    public TestDocumentTemplateBuilder outputFormat(String outputFormat) {
        this.outputFormat = ValueStrategy.value(outputFormat);
        return this;
    }

    public TestDocumentTemplateBuilder copies(int copies) {
        this.copies = ValueStrategy.value(copies);
        return this;
    }

    public TestDocumentTemplateBuilder paperHeight(BigDecimal paperHeight) {
        this.paperHeight = ValueStrategy.value(paperHeight);
        return this;
    }

    public TestDocumentTemplateBuilder paperWidth(BigDecimal paperWidth) {
        this.paperWidth = ValueStrategy.value(paperWidth);
        return this;
    }

    public TestDocumentTemplateBuilder paperUnits(String paperUnits) {
        this.paperUnits = ValueStrategy.value(paperUnits);
        return this;
    }

    public TestEmailTemplateBuilder emailTemplate() {
        return this.emailTemplate("entity.documentTemplateEmailUser");
    }

    public TestEmailTemplateBuilder emailTemplate(String archetype) {
        return new TestEmailTemplateBuilder(this, archetype, this.getService(), this.getHandlers());
    }

    public TestDocumentTemplateBuilder emailTemplate(String subject, String content) {
        return this.emailTemplate().subject(subject).content(content).add();
    }

    public TestDocumentTemplateBuilder emailTemplate(Entity emailTemplate) {
        this.emailTemplate = emailTemplate;
        return this;
    }

    public Entity getEmailTemplate() {
        return this.emailTemplate;
    }

    public TestSMSTemplateBuilder smsTemplate() {
        return new TestSMSTemplateBuilder(this, "entity.documentTemplateSMSReminder", this.getService());
    }

    public TestDocumentTemplateBuilder smsTemplate(Entity smsTemplate) {
        this.smsTemplate = smsTemplate;
        return this;
    }

    public TestDocumentTemplateBuilder smsTemplate(String content) {
        return this.smsTemplate().content(content).add();
    }

    public Entity getSMSTemplate() {
        return this.smsTemplate;
    }

    public TestDocumentTemplatePrinterBuilder printer() {
        return new TestDocumentTemplatePrinterBuilder(this, this.getService());
    }

    public TestDocumentTemplatePrinterBuilder printer(String printer) {
        return this.printer().printer(printer);
    }

    protected void addPrinter(EntityRelationship relationship, Party location) {
        this.printers.put(relationship, location);
    }

    @Override
    protected Entity getObject(String archetype) {
        Entity result = (Entity)this.getExisting();
        if (result == null) {
            TemplateHelper helper;
            DocumentAct act;
            if (this.singletonByType && this.type != null) {
                DocumentAct act2;
                TemplateHelper helper2 = new TemplateHelper(this.getService());
                result = helper2.getTemplateForType(this.type);
                if (result != null && (act2 = helper2.getDocumentAct(result)) != null) {
                    this.templateAct(act2);
                }
            } else if (this.singletonByContent && (act = (helper = new TemplateHelper(this.getService())).getDocumentAct(this.contentName)) != null) {
                this.templateAct(act);
                Entity template = (Entity)this.getBean((IMObject)act).getTarget("template", Entity.class);
                if (template.isA(archetype)) {
                    result = template;
                } else {
                    log.warn("Existing template {} will no longer be able to use content from {}", (Object)template.getObjectReference(), (Object)act.getObjectReference());
                }
            }
            if (result == null) {
                result = this.create(archetype, Entity.class);
            }
        }
        return result;
    }

    @Override
    protected void build(Entity object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        Lookup lookup;
        TestLookupBuilder lookupBuilder;
        super.build(object, bean, toSave, toRemove);
        if (this.type != null) {
            bean.removeValues("type");
            lookupBuilder = new TestLookupBuilder("lookup.documentTemplateType", this.getService());
            lookup = (Lookup)((TestLookupBuilder)lookupBuilder.code(this.type)).build();
            object.addClassification(lookup);
        }
        this.userLevel.setValue(bean, "userLevel");
        if (this.reportType != null) {
            lookupBuilder = new TestLookupBuilder("lookup.reportType", this.getService());
            lookup = (Lookup)((TestLookupBuilder)lookupBuilder.code(this.reportType)).build();
            bean.setValue("reportType", (Object)lookup.getCode());
        }
        this.printMode.setValue(bean, "printMode");
        this.paperSize.setValue(bean, "paperSize");
        this.orientation.setValue(bean, "orientation");
        this.outputFormat.setValue(bean, "outputFormat");
        this.copies.setValue(bean, "copies");
        this.paperHeight.setValue(bean, "paperHeight");
        this.paperWidth.setValue(bean, "paperWidth");
        this.paperUnits.setValue(bean, "paperUnits");
        if (this.emailTemplate != null) {
            bean.setTarget("email", (IMObject)this.emailTemplate);
            toSave.add((IMObject)this.emailTemplate);
        }
        if (this.smsTemplate != null) {
            bean.setTarget("sms", (IMObject)this.smsTemplate);
            toSave.add((IMObject)this.smsTemplate);
        }
        for (Map.Entry<EntityRelationship, Party> entry : this.printers.entrySet()) {
            EntityRelationship printer = entry.getKey();
            Party location = entry.getValue();
            printer.setSource(object.getObjectReference());
            printer.setTarget(location.getObjectReference());
            object.addEntityRelationship(printer);
            location.addEntityRelationship(printer);
            toSave.add((IMObject)location);
        }
        this.printers.clear();
    }
}

