/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.openvpms.archetype.test.builder.act.AbstractTestActVerifier;
import org.openvpms.archetype.test.builder.customer.account.TestChargeItemVerifier;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;

public abstract class TestChargeVerifier<V extends TestChargeVerifier<V, I>, I extends TestChargeItemVerifier<V, I>>
extends AbstractTestActVerifier<FinancialAct, V> {
    private final List<I> itemVerifiers = new ArrayList<I>();
    private ValueStrategy customer = ValueStrategy.value(null);
    private ValueStrategy clinician = ValueStrategy.value(null);
    private ValueStrategy amount = ValueStrategy.value(0);
    private ValueStrategy tax = ValueStrategy.value(0);

    public TestChargeVerifier(ArchetypeService service) {
        super(service);
    }

    public V customer(Party customer) {
        this.customer = ValueStrategy.value(this.getReference((IMObject)customer));
        return (V)((TestChargeVerifier)this.getThis());
    }

    public V clinician(User clinician) {
        this.clinician = ValueStrategy.value(this.getReference((IMObject)clinician));
        return (V)((TestChargeVerifier)this.getThis());
    }

    public V amount(int amount) {
        return this.amount(BigDecimal.valueOf(amount));
    }

    public V amount(BigDecimal amount) {
        this.amount = ValueStrategy.value(amount);
        return (V)((TestChargeVerifier)this.getThis());
    }

    public V tax(BigDecimal tax) {
        this.tax = ValueStrategy.value(tax);
        return (V)((TestChargeVerifier)this.getThis());
    }

    public abstract I item();

    public V add(I verifier) {
        this.itemVerifiers.add(verifier);
        return (V)((TestChargeVerifier)this.getThis());
    }

    @Override
    protected void verify(FinancialAct object, IMObjectBean bean) {
        super.verify(object, bean);
        this.checkEquals(this.customer, bean.getTargetRef("customer"));
        this.checkEquals(this.clinician, bean.getTargetRef("clinician"));
        this.checkEquals(this.amount, (Object)bean.getBigDecimal("amount"));
        this.checkEquals(this.tax, (Object)bean.getBigDecimal("tax"));
        List items = bean.getTargets("items", FinancialAct.class);
        Assert.assertEquals((long)this.itemVerifiers.size(), (long)items.size());
        for (TestChargeItemVerifier verifier : this.itemVerifiers) {
            FinancialAct verified = verifier.verify(items);
            items.remove(verified);
        }
    }
}

