/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test.builder.customer.account;

import java.math.BigDecimal;
import java.util.Set;
import org.openvpms.archetype.test.builder.customer.account.TestCashItemBuilder;
import org.openvpms.archetype.test.builder.customer.account.TestPaymentBuilder;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class TestCashPaymentItemBuilder
extends TestCashItemBuilder<TestPaymentBuilder, TestCashPaymentItemBuilder> {
    private ValueStrategy roundedAmount = ValueStrategy.unset();
    private ValueStrategy tendered = ValueStrategy.unset();

    public TestCashPaymentItemBuilder(TestPaymentBuilder parent, ArchetypeService service) {
        super(parent, "act.customerAccountPaymentCash", service);
    }

    public TestCashPaymentItemBuilder roundedAmount(BigDecimal roundedAmount) {
        this.roundedAmount = ValueStrategy.value(roundedAmount);
        return this;
    }

    public TestCashPaymentItemBuilder tendered(BigDecimal tendered) {
        this.tendered = ValueStrategy.value(tendered);
        return this;
    }

    @Override
    protected void build(FinancialAct object, IMObjectBean bean, Set<IMObject> toSave, Set<Reference> toRemove) {
        super.build(object, bean, toSave, toRemove);
        this.tendered.setValue(bean, "tendered");
        this.roundedAmount.setValue(bean, "roundedAmount");
    }
}

