/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.test;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Assert;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.AbstractJUnit4SpringContextTests;
import org.springframework.test.context.support.GenericXmlContextLoader;

@ContextConfiguration(value={"/applicationContext.xml"}, loader=GenericXmlContextLoader.class)
public abstract class ArchetypeServiceTest
extends AbstractJUnit4SpringContextTests {
    private final String archetypeServiceBeanName;
    private IArchetypeService service;
    @Autowired
    private LookupService lookups;

    public ArchetypeServiceTest() {
        this("archetypeRuleService");
    }

    public ArchetypeServiceTest(String archetypeServiceBeanName) {
        this.archetypeServiceBeanName = archetypeServiceBeanName;
    }

    protected IArchetypeService getArchetypeService() {
        if (this.service == null) {
            this.service = (IArchetypeService)this.applicationContext.getBean(this.archetypeServiceBeanName, IArchetypeService.class);
        }
        return this.service;
    }

    protected LookupService getLookupService() {
        return this.lookups;
    }

    protected org.openvpms.component.model.object.IMObject create(String archetype) {
        IMObject object = this.getArchetypeService().create(archetype);
        Assert.assertNotNull((Object)object);
        return object;
    }

    protected <T extends org.openvpms.component.model.object.IMObject> T create(String archetype, Class<T> type) {
        return (T)this.getArchetypeService().create(archetype, type);
    }

    protected void save(org.openvpms.component.model.object.IMObject object) {
        this.getArchetypeService().save(object);
    }

    @SafeVarargs
    protected final <T extends org.openvpms.component.model.object.IMObject> void save(T ... objects) {
        this.save((Collection<T>)Arrays.asList(objects));
    }

    protected <T extends org.openvpms.component.model.object.IMObject> void save(Collection<T> objects) {
        this.getArchetypeService().save(objects);
    }

    protected <T extends org.openvpms.component.model.object.IMObject> T get(T object) {
        return (T)this.get(object.getObjectReference());
    }

    protected org.openvpms.component.model.object.IMObject get(Reference ref) {
        return ref != null ? this.getArchetypeService().get(ref) : null;
    }

    protected <T extends org.openvpms.component.model.object.IMObject> T get(Reference ref, Class<T> type) {
        return (T)(ref != null ? this.getArchetypeService().get(ref, type) : null);
    }

    protected IMObjectBean getBean(org.openvpms.component.model.object.IMObject object) {
        return this.getArchetypeService().getBean(object);
    }

    protected IMObjectBean get(IMObjectBean bean) {
        org.openvpms.component.model.object.IMObject object = this.get(bean.getObject());
        return object != null ? this.getBean(object) : null;
    }

    protected void remove(org.openvpms.component.model.object.IMObject object) {
        this.getArchetypeService().remove(object);
    }

    protected void checkEquals(BigDecimal expected, BigDecimal actual) {
        TestHelper.checkEquals(expected, actual);
    }

    protected void checkEquals(String expected, BigDecimal actual) {
        this.checkEquals(new BigDecimal(expected), actual);
    }

    protected void checkEquals(int expected, BigDecimal actual) {
        this.checkEquals(BigDecimal.valueOf(expected), actual);
    }

    protected String getDisplayName(org.openvpms.component.model.object.IMObject object) {
        return DescriptorHelper.getDisplayName((org.openvpms.component.model.object.IMObject)object, (ArchetypeService)this.service);
    }

    protected String getDisplayName(String archetype) {
        return DescriptorHelper.getDisplayName((String)archetype, (ArchetypeService)this.service);
    }
}

