/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.user;

import java.util.Arrays;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.user.UserRules;
import org.openvpms.archetype.rules.util.EntityRelationshipHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.practice.TestLocationBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.domain.im.security.ArchetypeAwareGrantedAuthority;
import org.openvpms.component.business.domain.im.security.SecurityRole;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class UserRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;
    private UserRules rules;

    @Before
    public void setUp() {
        this.rules = new UserRules(this.getArchetypeService());
    }

    @Test
    public void testGetUser() {
        String username = ValueStrategy.random("zuser").toString();
        Assert.assertNull((Object)this.rules.getUser(username));
        User user = this.userFactory.createUser(username);
        Assert.assertEquals((Object)user, (Object)this.rules.getUser(username));
    }

    @Test
    public void testExists() {
        String username = ValueStrategy.random("zuser").toString();
        Assert.assertFalse((boolean)this.rules.exists(username));
        User user = this.userFactory.createUser(username);
        Assert.assertTrue((boolean)this.rules.exists(username));
        user.setActive(false);
        this.save((IMObject)user);
        Assert.assertTrue((boolean)this.rules.exists(username));
        this.remove((IMObject)user);
        Assert.assertFalse((boolean)this.rules.exists(username));
    }

    @Test
    public void testExistsExcludingUser() {
        String username = ValueStrategy.random("zuser").toString();
        User user1 = this.userFactory.createUser(username);
        Assert.assertFalse((boolean)this.rules.exists(username, user1));
        User user2 = (User)this.userFactory.newUser().username(username).build(false);
        Assert.assertTrue((boolean)this.rules.exists(username, user2));
        user1.setActive(false);
        this.save((IMObject)user1);
        Assert.assertTrue((boolean)this.rules.exists(username, user2));
        this.remove((IMObject)user1);
        Assert.assertFalse((boolean)this.rules.exists(username, user2));
    }

    @Test
    public void testIsClinician() {
        User user1 = this.userFactory.createUser();
        Assert.assertFalse((boolean)this.rules.isClinician(user1));
        User user2 = this.userFactory.createClinician();
        Assert.assertTrue((boolean)this.rules.isClinician(user2));
    }

    @Test
    public void testGetLocations() {
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        User user = (User)this.userFactory.newUser().addLocations(location1, location2).build();
        List locations = this.rules.getLocations(user);
        Assert.assertEquals((long)2L, (long)locations.size());
        Assert.assertTrue((boolean)locations.contains(location1));
        Assert.assertTrue((boolean)locations.contains(location2));
    }

    @Test
    public void testGetLocationsByUserAndPractice() {
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = this.practiceFactory.createLocation();
        Party location4 = (Party)((TestLocationBuilder)this.practiceFactory.newLocation().active(false)).build();
        Party practice = (Party)this.practiceFactory.newPractice().locations(location1, location2, location4).build(false);
        User user1 = (User)this.userFactory.newUser().addLocations(location1, location3, location4).build();
        List locations1 = this.rules.getLocations(user1, practice);
        Assert.assertEquals((long)1L, (long)locations1.size());
        Assert.assertTrue((boolean)locations1.contains(location1));
        Assert.assertFalse((boolean)locations1.contains(location2));
        Assert.assertFalse((boolean)locations1.contains(location3));
        Assert.assertFalse((boolean)locations1.contains(location4));
        User user2 = this.userFactory.createUser();
        List locations2 = this.rules.getLocations(user2, practice);
        Assert.assertEquals((long)2L, (long)locations2.size());
        Assert.assertTrue((boolean)locations2.contains(location1));
        Assert.assertTrue((boolean)locations2.contains(location2));
        Assert.assertFalse((boolean)locations2.contains(location3));
        Assert.assertFalse((boolean)locations2.contains(location4));
    }

    @Test
    public void testGetDefaultLocation() {
        User user = this.userFactory.createUser();
        Assert.assertNull((Object)this.rules.getDefaultLocation(user));
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = (Party)((TestLocationBuilder)this.practiceFactory.newLocation().active(false)).build();
        this.userFactory.updateUser(user).addLocations(location1, location2, location3).build();
        Party defaultLocation = this.rules.getDefaultLocation(user);
        Assert.assertNotNull((Object)defaultLocation);
        Assert.assertTrue((defaultLocation.equals(location1) || defaultLocation.equals(location2) ? 1 : 0) != 0);
        Relationship rel2 = (Relationship)this.getBean((IMObject)user).getValue("locations", Relationship.class, Predicates.targetEquals((IMObject)location2));
        Assert.assertNotNull((Object)rel2);
        EntityRelationshipHelper.setDefault((Entity)user, (String)"locations", (Relationship)rel2, (ArchetypeService)this.getArchetypeService());
        Assert.assertEquals((Object)location2, (Object)this.rules.getDefaultLocation(user));
        ((TestLocationBuilder)this.practiceFactory.updateLocation(location2).active(false)).build();
        Assert.assertEquals((Object)location1, (Object)this.rules.getDefaultLocation(user));
    }

    @Test
    public void testGetDepartments() {
        this.deactivateDepartments();
        User user1 = this.userFactory.createUser();
        this.checkDepartments(user1, new Entity[0]);
        Entity department1 = this.practiceFactory.createDepartment();
        Entity department2 = this.practiceFactory.createDepartment();
        Entity department3 = this.practiceFactory.createDepartment();
        this.checkDepartments(user1, department1, department2, department3);
        department2.setActive(false);
        this.save((IMObject)department2);
        this.checkDepartments(user1, department1, department3);
        User user2 = (User)this.userFactory.newUser().addDepartments(department1, department2).build();
        this.checkDepartments(user2, department1);
    }

    @Test
    public void testGetDefaultDepartment() {
        Entity department1 = this.practiceFactory.createDepartment();
        Entity department2 = this.practiceFactory.createDepartment();
        Entity department3 = this.practiceFactory.createDepartment();
        List<Entity> departments = Arrays.asList(department1, department2, department3);
        User user1 = this.userFactory.createUser();
        Assert.assertNull((Object)this.rules.getDefaultDepartment(user1, departments));
        User user2 = (User)this.userFactory.newUser().addDepartments(department1, department2).build();
        Assert.assertNull((Object)this.rules.getDefaultDepartment(user2, departments));
        User user3 = (User)this.userFactory.newUser().addDepartments(department1, department2, department3).defaultDepartment(department2).build();
        Assert.assertEquals((Object)department2, (Object)this.rules.getDefaultDepartment(user3, departments));
    }

    @Test
    public void testGetSignature() {
        User user1 = this.userFactory.createUser();
        Assert.assertNull((Object)this.rules.getSignature(user1));
        User user2 = (User)this.userFactory.newUser().signature().build();
        DocumentAct signature = this.rules.getSignature(user2);
        Assert.assertNotNull((Object)signature);
        Assert.assertTrue((boolean)signature.isA("act.documentSignature"));
        Assert.assertNotNull((Object)signature.getDocument());
    }

    @Test
    public void testIsAdministrator() {
        User user1 = this.userFactory.createUser();
        Assert.assertFalse((boolean)this.rules.isAdministrator(user1));
        User user2 = this.userFactory.createAdministrator();
        Assert.assertTrue((boolean)this.rules.isAdministrator(user2));
    }

    @Test
    public void testGetClinicians() {
        Party locationA = this.practiceFactory.createLocation();
        Party locationB = this.practiceFactory.createLocation();
        User user1 = this.userFactory.createUser();
        User user2 = (User)this.userFactory.newUser().addLocations(locationA).build();
        User user3 = (User)this.userFactory.newUser().clinician().addLocations(locationA).build();
        User user4 = (User)this.userFactory.newUser().clinician().addLocations(locationB).build();
        User user5 = (User)this.userFactory.newUser().clinician().addLocations(locationA, locationB).build();
        User user6 = this.userFactory.createClinician();
        List clinicians1 = this.rules.getClinicians(locationA);
        Assert.assertFalse((boolean)clinicians1.contains(user1));
        Assert.assertFalse((boolean)clinicians1.contains(user2));
        Assert.assertTrue((boolean)clinicians1.contains(user3));
        Assert.assertFalse((boolean)clinicians1.contains(user4));
        Assert.assertTrue((boolean)clinicians1.contains(user5));
        Assert.assertTrue((boolean)clinicians1.contains(user6));
        List clinicians2 = this.rules.getClinicians(locationB);
        Assert.assertFalse((boolean)clinicians2.contains(user1));
        Assert.assertFalse((boolean)clinicians2.contains(user2));
        Assert.assertFalse((boolean)clinicians2.contains(user3));
        Assert.assertTrue((boolean)clinicians2.contains(user4));
        Assert.assertTrue((boolean)clinicians2.contains(user5));
        Assert.assertTrue((boolean)clinicians2.contains(user5));
    }

    @Test
    public void testCanEditSaveRemove() {
        ArchetypeAwareGrantedAuthority createAll = this.userFactory.createAuthority("create", "*");
        ArchetypeAwareGrantedAuthority saveAll = this.userFactory.createAuthority("save", "*");
        ArchetypeAwareGrantedAuthority removeAll = this.userFactory.createAuthority("remove", "*");
        ArchetypeAwareGrantedAuthority createProducts = this.userFactory.createAuthority("create", "product.*");
        ArchetypeAwareGrantedAuthority saveProducts = this.userFactory.createAuthority("save", "product.*");
        ArchetypeAwareGrantedAuthority removeProducts = this.userFactory.createAuthority("remove", "product.*");
        ArchetypeAwareGrantedAuthority createMedication = this.userFactory.createAuthority("create", "product.medication");
        ArchetypeAwareGrantedAuthority saveMedication = this.userFactory.createAuthority("save", "product.medication");
        ArchetypeAwareGrantedAuthority removeMedication = this.userFactory.createAuthority("remove", "product.medication");
        User admin = (User)this.userFactory.newUser().administrator().addRoles(this.userFactory.createRole(createAll, saveAll, removeAll)).build();
        Assert.assertTrue((boolean)this.rules.canEdit(admin, "act.customerAccountChargesInvoice"));
        Assert.assertTrue((boolean)this.rules.canEdit(admin, "product.*"));
        Assert.assertTrue((boolean)this.rules.canSave(admin, "act.customerAccountChargesInvoice"));
        Assert.assertTrue((boolean)this.rules.canSave(admin, "product.*"));
        Assert.assertTrue((boolean)this.rules.canRemove(admin, "act.customerAccountChargesInvoice"));
        Assert.assertTrue((boolean)this.rules.canRemove(admin, "product.*"));
        User user1 = (User)this.userFactory.newUser().addRoles(this.userFactory.createRole(createAll, saveAll)).build();
        Assert.assertTrue((boolean)this.rules.canEdit(user1, "act.customerAccountChargesInvoice"));
        Assert.assertTrue((boolean)this.rules.canEdit(user1, "product.*"));
        Assert.assertTrue((boolean)this.rules.canSave(user1, "act.customerAccountChargesInvoice"));
        Assert.assertTrue((boolean)this.rules.canSave(user1, "product.*"));
        Assert.assertFalse((boolean)this.rules.canRemove(user1, "act.customerAccountChargesInvoice"));
        Assert.assertFalse((boolean)this.rules.canRemove(user1, "product.*"));
        User user2 = (User)this.userFactory.newUser().addRoles(this.userFactory.createRole(createAll)).build();
        Assert.assertFalse((boolean)this.rules.canEdit(user2, "act.customerAccountChargesInvoice"));
        Assert.assertFalse((boolean)this.rules.canEdit(user2, "product.*"));
        Assert.assertFalse((boolean)this.rules.canSave(user2, "act.customerAccountChargesInvoice"));
        Assert.assertFalse((boolean)this.rules.canSave(user2, "product.*"));
        Assert.assertFalse((boolean)this.rules.canRemove(user2, "act.customerAccountChargesInvoice"));
        Assert.assertFalse((boolean)this.rules.canRemove(user2, "product.*"));
        User user3 = (User)this.userFactory.newUser().addRoles(this.userFactory.createRole(saveAll)).build();
        Assert.assertFalse((boolean)this.rules.canEdit(user3, "act.customerAccountChargesInvoice"));
        Assert.assertFalse((boolean)this.rules.canEdit(user3, "product.*"));
        Assert.assertTrue((boolean)this.rules.canSave(user3, "act.customerAccountChargesInvoice"));
        Assert.assertTrue((boolean)this.rules.canSave(user3, "product.*"));
        Assert.assertFalse((boolean)this.rules.canRemove(user3, "act.customerAccountChargesInvoice"));
        Assert.assertFalse((boolean)this.rules.canRemove(user3, "product.*"));
        User user4 = (User)this.userFactory.newUser().addRoles(this.userFactory.createRole(removeAll)).build();
        Assert.assertFalse((boolean)this.rules.canEdit(user4, "act.customerAccountChargesInvoice"));
        Assert.assertFalse((boolean)this.rules.canEdit(user4, "product.*"));
        Assert.assertFalse((boolean)this.rules.canSave(user4, "act.customerAccountChargesInvoice"));
        Assert.assertFalse((boolean)this.rules.canSave(user4, "product.*"));
        Assert.assertTrue((boolean)this.rules.canRemove(user4, "act.customerAccountChargesInvoice"));
        Assert.assertTrue((boolean)this.rules.canRemove(user4, "product.*"));
        User user5 = (User)this.userFactory.newUser().addRoles(this.userFactory.createRole(createProducts, saveProducts, removeProducts)).build();
        Assert.assertFalse((boolean)this.rules.canEdit(user5, "act.customerAccountChargesInvoice"));
        Assert.assertTrue((boolean)this.rules.canEdit(user5, "product.*"));
        Assert.assertFalse((boolean)this.rules.canSave(user5, "act.customerAccountChargesInvoice"));
        Assert.assertTrue((boolean)this.rules.canSave(user5, "product.*"));
        Assert.assertFalse((boolean)this.rules.canRemove(user5, "act.customerAccountChargesInvoice"));
        Assert.assertTrue((boolean)this.rules.canRemove(user5, "product.*"));
        User user6 = (User)this.userFactory.newUser().addRoles(this.userFactory.createRole(createMedication, saveMedication, removeMedication)).build();
        Assert.assertTrue((boolean)this.rules.canEdit(user6, "product.medication"));
        Assert.assertTrue((boolean)this.rules.canSave(user6, "product.medication"));
        Assert.assertFalse((boolean)this.rules.canEdit(user6, "act.customerAccountChargesInvoice"));
        Assert.assertFalse((boolean)this.rules.canSave(user6, "act.customerAccountChargesInvoice"));
        Assert.assertFalse((boolean)this.rules.canEdit(user6, "product.*"));
        Assert.assertFalse((boolean)this.rules.canSave(user6, "product.*"));
        Assert.assertFalse((boolean)this.rules.canEdit(user6, "product.template"));
        Assert.assertFalse((boolean)this.rules.canSave(user6, "product.template"));
        Assert.assertTrue((boolean)this.rules.canRemove(user6, "product.medication"));
        Assert.assertFalse((boolean)this.rules.canRemove(user6, "act.customerAccountChargesInvoice"));
        Assert.assertFalse((boolean)this.rules.canRemove(user6, "product.*"));
        Assert.assertFalse((boolean)this.rules.canRemove(user6, "product.template"));
    }

    @Test
    public void testGetJobUsedBy() {
        User user1 = this.userFactory.createUser();
        User user2 = this.userFactory.createUser();
        Assert.assertNull((Object)this.rules.getJobUsedBy(user1));
        Assert.assertNull((Object)this.rules.getJobUsedBy(user2));
        IMObject job1 = this.create("entity.jobPharmacyOrderDiscontinuation");
        IMObjectBean bean1 = this.getBean(job1);
        bean1.addTarget("runAs", (IMObject)user1);
        bean1.save();
        Assert.assertEquals((Object)job1, (Object)this.rules.getJobUsedBy(user1));
        IMObject job2 = this.create("entity.jobPharmacyOrderDiscontinuation");
        IMObjectBean bean2 = this.getBean(job2);
        bean2.addTarget("runAs", (IMObject)user1);
        bean2.addTarget("notify", (IMObject)user2);
        bean2.save();
        Assert.assertEquals((Object)job2, (Object)this.rules.getJobUsedBy(user2));
        job1.setActive(false);
        this.save(job1);
        Assert.assertEquals((Object)job2, (Object)this.rules.getJobUsedBy(user1));
    }

    @Test
    public void testRoleExists() {
        SecurityRole role = (SecurityRole)this.userFactory.newRole().build(false);
        String name = role.getName();
        Assert.assertFalse((boolean)this.rules.roleExists(name, -1L));
        this.save((IMObject)role);
        Assert.assertTrue((boolean)this.rules.roleExists(name, -1L));
        Assert.assertFalse((boolean)this.rules.roleExists(name, role.getId()));
        role.setActive(false);
        this.save((IMObject)role);
        Assert.assertTrue((boolean)this.rules.roleExists(name, -1L));
        Assert.assertFalse((boolean)this.rules.roleExists(name, role.getId()));
    }

    @Test
    public void testAuthorityExists() {
        ArchetypeAwareGrantedAuthority authority = (ArchetypeAwareGrantedAuthority)this.userFactory.newAuthority().method("create").archetype("*").build(false);
        String name = authority.getName();
        Assert.assertFalse((boolean)this.rules.authorityExists(name, -1L));
        this.save((IMObject)authority);
        Assert.assertTrue((boolean)this.rules.authorityExists(name, -1L));
        Assert.assertFalse((boolean)this.rules.authorityExists(name, authority.getId()));
        authority.setActive(false);
        this.save((IMObject)authority);
        Assert.assertTrue((boolean)this.rules.authorityExists(name, -1L));
        Assert.assertFalse((boolean)this.rules.authorityExists(name, authority.getId()));
    }

    private void deactivateDepartments() {
        IArchetypeService service = this.getArchetypeService();
        CriteriaBuilder builder = service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root root = query.from(Entity.class, new String[]{"entity.department"});
        query.where((Expression)builder.equal((Expression)root.get("active"), (Object)true));
        for (Entity department : service.createQuery(query).getResultList()) {
            department.setActive(false);
            this.save((IMObject)department);
        }
    }

    private void checkDepartments(User user, Entity ... departments) {
        List<Entity> expected = Arrays.asList(departments);
        List actual = this.rules.getDepartments(user);
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        Assert.assertTrue((expected.containsAll(actual) && actual.containsAll(expected) ? 1 : 0) != 0);
    }
}

