/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.user;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.user.PasswordPolicy;
import org.openvpms.archetype.rules.user.PasswordValidator;
import org.openvpms.archetype.rules.user.TestPasswordPolicy;

public class PasswordValidatorTestCase {
    @Test
    public void testMinLength() {
        TestPasswordPolicy policy = new TestPasswordPolicy(5, 10, false, false, false, false);
        this.checkInvalid((PasswordPolicy)policy, "abcd", "Password must have at least 5 characters");
        this.checkValid((PasswordPolicy)policy, "abcde", "abcdef");
    }

    @Test
    public void testMaxLength() {
        TestPasswordPolicy policy = new TestPasswordPolicy(5, 5, false, false, false, false);
        this.checkInvalid((PasswordPolicy)policy, "abcdef", "Password must not be longer than 5 characters");
        this.checkValid((PasswordPolicy)policy, "abcde");
    }

    @Test
    public void testLowercase() {
        TestPasswordPolicy policy = new TestPasswordPolicy(4, 4, true, false, false, false);
        this.checkInvalid((PasswordPolicy)policy, "TEST", "Password must have at least one lowercase character");
        this.checkValid((PasswordPolicy)policy, "TESt", "tEST", "TEsT", "test");
    }

    @Test
    public void testUppercase() {
        TestPasswordPolicy policy = new TestPasswordPolicy(4, 4, false, true, false, false);
        this.checkInvalid((PasswordPolicy)policy, "test", "Password must have at least one uppercase character");
        this.checkValid((PasswordPolicy)policy, "Test", "tesT", "teSt", "TEST");
    }

    @Test
    public void testNumber() {
        TestPasswordPolicy policy = new TestPasswordPolicy(4, 10, false, false, true, false);
        this.checkInvalid((PasswordPolicy)policy, "test", "Password must have at least one number");
        this.checkValid((PasswordPolicy)policy, "1test", "test1", "te1st", "1234");
    }

    @Test
    public void testSpecial() {
        TestPasswordPolicy policy = new TestPasswordPolicy(4, 10, false, false, false, true);
        this.checkInvalid((PasswordPolicy)policy, "test", "Password must have at least one special character");
        String special = policy.getSpecialCharacters();
        String reserved = "-!\"/^$*+?.()|[]{}\\";
        for (char ch : reserved.toCharArray()) {
            Assert.assertTrue((special.indexOf(ch) != -1 ? 1 : 0) != 0);
        }
        for (char ch : special.toCharArray()) {
            this.checkValid((PasswordPolicy)policy, "test" + ch);
        }
    }

    @Test
    public void testSpace() {
        TestPasswordPolicy policy = new TestPasswordPolicy(4, 10, false, false, false, false);
        this.checkInvalid((PasswordPolicy)policy, " test", "Password cannot contain whitespace");
        this.checkInvalid((PasswordPolicy)policy, "te st ", "Password cannot contain whitespace");
        this.checkInvalid((PasswordPolicy)policy, "test ", "Password cannot contain whitespace");
        this.checkInvalid((PasswordPolicy)policy, "\ntest", "Password cannot contain whitespace");
        this.checkInvalid((PasswordPolicy)policy, "test\r", "Password cannot contain whitespace");
        this.checkInvalid((PasswordPolicy)policy, "tes\tt", "Password cannot contain whitespace");
    }

    @Test
    public void testInvalidCharacter() {
        TestPasswordPolicy policy = new TestPasswordPolicy(4, 10, false, false, false, false);
        this.checkInvalid((PasswordPolicy)policy, "test\u0000", "'\u0000' is not a valid password character");
        this.checkInvalid((PasswordPolicy)policy, "test\u0080", "'\u0080' is not a valid password character");
    }

    private void checkValid(PasswordPolicy policy, String ... passwords) {
        PasswordValidator validator = new PasswordValidator(policy);
        for (String password : passwords) {
            List errors = validator.validate(password);
            Assert.assertTrue((String)(password + ": " + StringUtils.join((Object[])new List[]{errors})), (boolean)errors.isEmpty());
        }
    }

    private void checkInvalid(PasswordPolicy policy, String password, String ... errors) {
        List<String> expected = Arrays.asList(errors);
        PasswordValidator validator = new PasswordValidator(policy);
        List actual = validator.validate(password);
        Assert.assertEquals((long)expected.size(), (long)actual.size());
        if (!expected.containsAll(actual) || !actual.containsAll(expected)) {
            Assert.fail((String)("Expected " + StringUtils.join((Object[])new List[]{expected}) + " but got " + StringUtils.join((Object[])new List[]{actual})));
        }
    }
}

