/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.time.DateUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.rules.supplier.AbstractSupplierTest;
import org.openvpms.archetype.rules.supplier.ProductOrder;
import org.openvpms.archetype.rules.supplier.SupplierRules;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierOrganisationBuilder;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderBuilder;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderItemBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.springframework.beans.factory.annotation.Autowired;

public class SupplierRulesTestCase
extends AbstractSupplierTest {
    private SupplierRules rules;
    private ProductRules productRules;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.rules = new SupplierRules(this.getArchetypeService());
        this.productRules = new ProductRules(this.getArchetypeService(), this.getLookupService());
    }

    @Test
    public void testGetReferralVet() {
        Party vet = this.supplierFactory.createVet();
        Party practice = (Party)this.supplierFactory.newVetPractice().addVets(vet).build();
        EntityRelationship relationship = (EntityRelationship)vet.getEntityRelationships().iterator().next();
        Party practice2 = this.rules.getReferralVetPractice(vet, new Date());
        Assert.assertEquals((Object)practice, (Object)practice2);
        Date start = new Date();
        Date end = new Date(start.getTime() + 1L);
        Date later = new Date(end.getTime() + 1L);
        relationship.setActiveStartTime(start);
        relationship.setActiveEndTime(end);
        Assert.assertNull((Object)this.rules.getReferralVetPractice(vet, later));
    }

    @Test
    public void testIsSuppliedBy() {
        Party supplier = this.getSupplier();
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMedication();
        Assert.assertFalse((boolean)this.rules.isSuppliedBy(supplier, product1));
        Assert.assertFalse((boolean)this.rules.isSuppliedBy(supplier, product2));
        ProductSupplier relationship = this.productRules.createProductSupplier(product1, supplier);
        Assert.assertNotNull((Object)relationship);
        Assert.assertTrue((boolean)this.rules.isSuppliedBy(supplier, product1));
        Assert.assertFalse((boolean)this.rules.isSuppliedBy(supplier, product2));
    }

    @Test
    public void testGetProductSuppliersForSupplier() {
        Party supplier = this.getSupplier();
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMedication();
        ProductSupplier rel1 = this.productRules.createProductSupplier(product1, supplier);
        ProductSupplier rel2 = this.productRules.createProductSupplier(product2, supplier);
        this.save((IMObject[])new Entity[]{supplier, product1, product2});
        List relationships = this.rules.getProductSuppliers(supplier);
        Assert.assertEquals((long)2L, (long)relationships.size());
        Assert.assertTrue((boolean)relationships.contains(rel1));
        Assert.assertTrue((boolean)relationships.contains(rel2));
        this.deactivateRelationship(rel1);
        this.save((IMObject[])new Entity[]{product1, supplier});
        relationships = this.rules.getProductSuppliers(supplier);
        Assert.assertEquals((long)1L, (long)relationships.size());
        Assert.assertFalse((boolean)relationships.contains(rel1));
        Assert.assertTrue((boolean)relationships.contains(rel2));
    }

    @Test
    public void testGetSupplierStockLocationRelationship() {
        Party supplier = this.getSupplier();
        Party stockLocation = this.getStockLocation();
        Act order = (Act)((TestOrderBuilder)((TestOrderBuilder)this.supplierFactory.newOrder().supplier(supplier)).stockLocation(stockLocation)).build(false);
        Assert.assertNull((Object)this.rules.getSupplierStockLocation(order));
        TestSupplierOrganisationBuilder builder = this.supplierFactory.updateSupplier(supplier);
        builder.addESCIConfiguration(stockLocation).build();
        EntityRelationship supplierStockLocation = builder.getESCIConfigs().get(0);
        Assert.assertEquals((Object)supplierStockLocation, (Object)this.rules.getSupplierStockLocation(order));
    }

    @Test
    public void testGetSupplierStockLocationRelationshipForSupplier() {
        Party supplier = this.getSupplier();
        Party stockLocation = this.getStockLocation();
        Assert.assertNull((Object)this.rules.getSupplierStockLocation(supplier, stockLocation));
        TestSupplierOrganisationBuilder builder = this.supplierFactory.updateSupplier(supplier).addESCIConfiguration(stockLocation);
        builder.build(false);
        EntityRelationship supplierStockLocation = builder.getESCIConfigs().get(0);
        Assert.assertEquals((Object)supplierStockLocation, (Object)this.rules.getSupplierStockLocation(supplier, stockLocation));
    }

    @Test
    public void testGetAccountId() {
        Party supplier = this.getSupplier();
        Party location = this.getPracticeLocation();
        Assert.assertNull((Object)this.rules.getAccountId(supplier.getId(), location));
        Assert.assertNull((Object)this.rules.getAccountId(supplier, location));
        Assert.assertNull((Object)this.rules.getAccountId(-1L, location));
        IMObjectBean supplierBean = this.getBean((IMObject)supplier);
        Relationship relationship = supplierBean.addTarget("locations", (IMObject)location);
        IMObjectBean bean = this.getBean((IMObject)relationship);
        String expected = "1234567";
        bean.setValue("accountId", (Object)expected);
        supplierBean.save();
        Assert.assertEquals((Object)expected, (Object)this.rules.getAccountId(supplier.getId(), location));
        Assert.assertEquals((Object)expected, (Object)this.rules.getAccountId(supplier, location));
    }

    @Test
    public void testGetBackOrder() {
        Product product = this.getProduct();
        Party supplier = this.getSupplier();
        Party stockLocation = this.getStockLocation();
        Assert.assertEquals((long)0L, (long)this.rules.getOrders(product, stockLocation).size());
        Act order = (Act)((TestOrderBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderBuilder)((TestOrderBuilder)((TestOrderBuilder)this.supplierFactory.newOrder().supplier(supplier)).stockLocation(stockLocation)).status("POSTED")).item().product(product)).quantity(10)).receivedQuantity(2).cancelledQuantity(3).add()).build();
        List productOrders = this.rules.getOrders(product, stockLocation);
        Assert.assertEquals((long)1L, (long)productOrders.size());
        ProductOrder productOrder = (ProductOrder)productOrders.get(0);
        Assert.assertEquals((Object)order, (Object)this.get(productOrder.getOrder()));
        Assert.assertEquals((Object)supplier, (Object)this.get(productOrder.getSupplier()));
        this.checkEquals(BigDecimal.valueOf(5L), productOrder.getUndelivered());
        Assert.assertEquals((Object)DateUtils.truncate((Date)order.getActivityStartTime(), (int)13), (Object)productOrder.getDate());
    }

    private void deactivateRelationship(ProductSupplier relationship) {
        relationship.getRelationship().setActive(false);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

