/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.supplier;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.tax.TaxRules;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.rules.supplier.DeliveryStatus;
import org.openvpms.archetype.rules.supplier.OrderGenerator;
import org.openvpms.archetype.rules.supplier.Stock;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.object.AbstractTestIMObjectBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderBuilder;
import org.openvpms.archetype.test.builder.supplier.order.TestOrderItemBuilder;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderGeneratorTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;
    private Lookup gst;
    private OrderGenerator generator;

    @Before
    public void setUp() {
        this.gst = this.lookupFactory.createTaxType(BigDecimal.TEN);
        Party practice = (Party)this.practiceFactory.newPractice().addTaxType(this.gst).build(false);
        TaxRules taxRules = new TaxRules(practice, (ArchetypeService)this.getArchetypeService());
        this.generator = new OrderGenerator(taxRules, this.getArchetypeService());
    }

    @Test
    public void testGetOrderableStock() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMedication();
        Product product3 = this.productFactory.createMedication();
        Product product4 = this.productFactory.createMedication();
        Product product5 = this.productFactory.createMedication();
        Product product6 = this.productFactory.createMedication();
        this.addRelationships(product1, stockLocation, supplier, true, 1, 10, 5);
        this.addRelationships(product2, stockLocation, supplier, true, 5, 10, 5);
        this.addRelationships(product3, stockLocation, supplier, true, 6, 10, 5);
        this.addRelationships(product4, stockLocation, supplier, true, 9, 10, 5);
        this.addRelationships(product5, stockLocation, supplier, true, 10, 10, 5);
        this.addRelationships(product6, stockLocation, supplier, true, 11, 10, 5);
        List atOrBelowCritical = this.generator.getOrderableStock(supplier, stockLocation, false);
        Assert.assertEquals((long)2L, (long)atOrBelowCritical.size());
        this.checkStock(atOrBelowCritical, product1, supplier, stockLocation, 1, 0, 9);
        this.checkStock(atOrBelowCritical, product2, supplier, stockLocation, 5, 0, 5);
        List atOrBelowIdeal = this.generator.getOrderableStock(supplier, stockLocation, true);
        Assert.assertEquals((long)4L, (long)atOrBelowIdeal.size());
        this.checkStock(atOrBelowIdeal, product1, supplier, stockLocation, 1, 0, 9);
        this.checkStock(atOrBelowIdeal, product2, supplier, stockLocation, 5, 0, 5);
        this.checkStock(atOrBelowIdeal, product3, supplier, stockLocation, 6, 0, 4);
        this.checkStock(atOrBelowIdeal, product4, supplier, stockLocation, 9, 0, 1);
    }

    @Test
    public void testGetOrderableStockForPendingOrders() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier1 = this.supplierFactory.createSupplier();
        Party supplier2 = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMedication();
        Product product3 = this.productFactory.createMedication();
        this.addRelationships(product1, stockLocation, supplier1, true, 1, 10, 6);
        this.addRelationships(product2, stockLocation, supplier1, true, 2, 10, 5);
        this.addRelationships(product3, stockLocation, supplier2, true, 1, 10, 5);
        this.createOrder(product1, supplier1, stockLocation, 2, "IN_PROGRESS");
        this.createOrder(product1, supplier1, stockLocation, 1, "COMPLETED");
        this.createOrder(product1, supplier1, stockLocation, 1, "POSTED");
        this.createOrder(product1, supplier1, stockLocation, 1, "ACCEPTED");
        this.createOrder(product2, supplier1, stockLocation, 3, "ACCEPTED");
        this.createOrder(product1, supplier1, stockLocation, 1, "CANCELLED");
        this.createOrder(product2, supplier1, stockLocation, 1, "CANCELLED");
        this.createOrder(product1, supplier1, stockLocation, 1, "REJECTED");
        this.createOrder(product2, supplier1, stockLocation, 1, "REJECTED");
        this.createOrder(product3, supplier2, stockLocation, 1, "IN_PROGRESS");
        this.createOrder(product3, supplier2, stockLocation, 1, "COMPLETED");
        this.createOrder(product3, supplier2, stockLocation, 1, "POSTED");
        this.createOrder(product3, supplier2, stockLocation, 1, "ACCEPTED");
        supplier1 = this.get(supplier1);
        List stock = this.generator.getOrderableStock(supplier1, stockLocation, false);
        Assert.assertEquals((long)2L, (long)stock.size());
        this.checkStock(stock, product1, supplier1, stockLocation, 1, 5, 4);
        this.checkStock(stock, product2, supplier1, stockLocation, 2, 3, 5);
    }

    @Test
    public void testGetOrderableStockIgnoresInactiveProducts() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier1 = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMedication();
        Product product3 = this.productFactory.createMedication();
        this.addRelationships(product1, stockLocation, supplier1, true, 1, 10, 6);
        ProductSupplier ps = this.addRelationships(product2, stockLocation, supplier1, true, 2, 10, 5);
        this.addProductSupplierRelationship(product3, supplier1, true, 1, 1);
        EntityLink er = this.addProductStockLocationRelationship(product3, stockLocation, null, 1, 10, 5);
        supplier1 = this.get(supplier1);
        List stock = this.generator.getOrderableStock(supplier1, stockLocation, false);
        Assert.assertEquals((long)3L, (long)stock.size());
        this.checkStock(stock, product1, supplier1, stockLocation, 1, 0, 9);
        this.checkStock(stock, product2, supplier1, stockLocation, 2, 0, 8);
        this.checkStock(stock, product3, supplier1, stockLocation, 1, 0, 9);
        product1.setActive(false);
        this.save((IMObject)product1);
        stock = this.generator.getOrderableStock(supplier1, stockLocation, false);
        Assert.assertEquals((long)2L, (long)stock.size());
        this.checkStock(stock, product2, supplier1, stockLocation, 2, 0, 8);
        this.checkStock(stock, product3, supplier1, stockLocation, 1, 0, 9);
        ps.setActiveEndTime(new Date(System.currentTimeMillis() - 1000L));
        ps.save();
        stock = this.generator.getOrderableStock(supplier1, stockLocation, false);
        Assert.assertEquals((long)1L, (long)stock.size());
        this.checkStock(stock, product3, supplier1, stockLocation, 1, 0, 9);
        er.setActiveEndTime(new Date(System.currentTimeMillis() - 1000L));
        this.save((IMObject)er);
        stock = this.generator.getOrderableStock(supplier1, stockLocation, false);
        Assert.assertEquals((long)0L, (long)stock.size());
    }

    @Test
    public void testGetOrderableStockWhereReceivedQtyGreaterThanOrdered() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier = this.supplierFactory.createSupplier();
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().newProductStockLocation().stockLocation(stockLocation).quantity(0).idealQuantity(200).criticalQuantity(10).add()).newProductSupplier().supplier(supplier).preferred(true).packageSize(1).nettPrice(1).add()).build();
        List<FinancialAct> acts = this.createOrder(product, supplier, stockLocation, 100, 1, "ACCEPTED", 20, 0, DeliveryStatus.PART);
        List stock1 = this.generator.getOrderableStock(supplier, stockLocation, true);
        this.checkOnlyStock(stock1, product, supplier, stockLocation, 0, 80, 120);
        this.supplierFactory.updateOrderItem(acts.get(1)).receivedQuantity(150).build();
        List stock2 = this.generator.getOrderableStock(supplier, stockLocation, true);
        this.checkOnlyStock(stock2, product, supplier, stockLocation, 0, 0, 200);
    }

    @Test
    public void testGetOrderableStockWhereReceivedQtyGreaterThanOrderedForMultipleOrders() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier = this.supplierFactory.createSupplier();
        Product product = (Product)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().newProductStockLocation().stockLocation(stockLocation).quantity(0).idealQuantity(8).criticalQuantity(4).add()).newProductSupplier().supplier(supplier).preferred(true).packageSize(1).nettPrice(1).add()).build();
        List stock1 = this.generator.getOrderableStock(supplier, stockLocation, true);
        this.checkOnlyStock(stock1, product, supplier, stockLocation, 0, 0, 8);
        this.createOrder(product, supplier, stockLocation, 6, 1, "ACCEPTED", 0, 6, DeliveryStatus.PART);
        List stock2 = this.generator.getOrderableStock(supplier, stockLocation, true);
        this.checkOnlyStock(stock2, product, supplier, stockLocation, 0, 0, 8);
        this.createOrder(product, supplier, stockLocation, 1, 1, "ACCEPTED", 8, 0, DeliveryStatus.PART);
        List stock3 = this.generator.getOrderableStock(supplier, stockLocation, true);
        this.checkOnlyStock(stock3, product, supplier, stockLocation, 0, 0, 8);
        this.createOrder(product, supplier, stockLocation, 4, 1, "ACCEPTED", 0, 0, DeliveryStatus.PART);
        List stock4 = this.generator.getOrderableStock(supplier, stockLocation, true);
        this.checkOnlyStock(stock4, product, supplier, stockLocation, 0, 4, 4);
        this.createOrder(product, supplier, stockLocation, 4, 1, "ACCEPTED", 0, 0, DeliveryStatus.PART);
        List stock5 = this.generator.getOrderableStock(supplier, stockLocation, true);
        Assert.assertEquals((long)0L, (long)stock5.size());
    }

    @Test
    public void testGetOrderableStockForPackageSizeChange() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier1 = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        this.createOrder(product1, supplier1, stockLocation, 10, 2, "ACCEPTED", 0, 0, DeliveryStatus.PENDING);
        this.addRelationships(product1, stockLocation, supplier1, true, 0, 200, 10, BigDecimal.valueOf(4L), 5);
        List stock = this.generator.getOrderableStock(supplier1, stockLocation, true);
        Assert.assertEquals((long)1L, (long)stock.size());
        this.checkStock(stock, product1, supplier1, stockLocation, 0, 20, 36);
    }

    @Test
    public void testGetOrderForStockForStockOrderAtDifferentStockLocations() {
        Party stockLocation1 = this.practiceFactory.createStockLocation(new Party[0]);
        Party stockLocation2 = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier1 = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMedication();
        this.addRelationships(product1, stockLocation1, supplier1, true, 1, 10, 6);
        this.addRelationships(product2, stockLocation1, supplier1, true, 2, 10, 5);
        this.addRelationships(product1, stockLocation2, supplier1, true, 1, 10, 6);
        this.addRelationships(product2, stockLocation2, supplier1, true, 2, 10, 5);
        this.createOrder(product1, supplier1, stockLocation1, 5, "IN_PROGRESS");
        this.createOrder(product2, supplier1, stockLocation1, 3, "ACCEPTED");
        this.createOrder(product1, supplier1, stockLocation2, 5, "IN_PROGRESS");
        this.createOrder(product2, supplier1, stockLocation2, 3, "ACCEPTED");
        supplier1 = this.get(supplier1);
        List stock = this.generator.getOrderableStock(supplier1, stockLocation1, false);
        Assert.assertEquals((long)2L, (long)stock.size());
        this.checkStock(stock, product1, supplier1, stockLocation1, 1, 5, 4);
        this.checkStock(stock, product2, supplier1, stockLocation1, 2, 3, 5);
    }

    @Test
    public void testCreateOrder() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        Product product2 = this.productFactory.createMedication();
        this.addRelationships(product1, stockLocation, supplier, true, 1, 10, 5, new BigDecimal("2.0"), 1);
        this.addRelationships(product2, stockLocation, supplier, true, 1, 10, 5, BigDecimal.ONE, 1);
        List order = this.generator.createOrder(supplier, stockLocation, false);
        Assert.assertEquals((long)3L, (long)order.size());
        this.save(order);
        BigDecimal total = new BigDecimal("29.70");
        BigDecimal tax = new BigDecimal("2.70");
        this.checkOrder((FinancialAct)order.get(0), supplier, stockLocation, total, tax);
        this.checkOrderItem(order, product1, BigDecimal.valueOf(9L), new BigDecimal("19.80"), new BigDecimal("1.80"));
        this.checkOrderItem(order, product2, BigDecimal.valueOf(9L), new BigDecimal("9.90"), new BigDecimal("0.90"));
    }

    @Test
    public void testCreateOrderForQuantityLessThanPackageSize() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        this.addRelationships(product1, stockLocation, supplier, true, 0, 2, 2, new BigDecimal("2.0"), 10);
        List order = this.generator.createOrder(supplier, stockLocation, false);
        Assert.assertEquals((long)2L, (long)order.size());
        this.save(order);
        BigDecimal total = new BigDecimal("2.20");
        BigDecimal tax = new BigDecimal("0.20");
        this.checkOrder((FinancialAct)order.get(0), supplier, stockLocation, total, tax);
        this.checkOrderItem((FinancialAct)order.get(1), product1, BigDecimal.ONE, total, tax);
    }

    @Test
    public void testCreateOrderForQuantityGreaterThanPackageSize() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        this.addRelationships(product1, stockLocation, supplier, true, 0, 22, 22, new BigDecimal("2.0"), 10);
        BigDecimal total = new BigDecimal("6.60");
        BigDecimal tax = new BigDecimal("0.60");
        List order = this.generator.createOrder(supplier, stockLocation, false);
        Assert.assertEquals((long)2L, (long)order.size());
        this.save(order);
        this.checkOrder((FinancialAct)order.get(0), supplier, stockLocation, total, tax);
        this.checkOrderItem((FinancialAct)order.get(1), product1, BigDecimal.valueOf(3L), total, tax);
    }

    @Test
    public void testCreateOrderForProductWithTax() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier = this.supplierFactory.createSupplier();
        Product product = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().addTaxTypes(this.gst)).build();
        BigDecimal total = new BigDecimal("1292.54");
        BigDecimal taxAmount = new BigDecimal("117.50");
        BigDecimal quantity = new BigDecimal("96");
        this.addRelationships(product, stockLocation, supplier, true, 0, quantity.intValue(), 0, new BigDecimal("12.24"), 1);
        List order = this.generator.createOrder(supplier, stockLocation, false);
        this.save(order);
        this.checkOrder((FinancialAct)order.get(0), supplier, stockLocation, total, taxAmount);
        this.checkOrderItem((FinancialAct)order.get(1), product, quantity, total, taxAmount);
    }

    @Test
    public void testCreateOrderWithPriorDeliveries() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier = this.supplierFactory.createSupplier();
        Product product = this.productFactory.createMedication();
        this.save((IMObject)product);
        this.createOrder(product, supplier, stockLocation, 200, 1, "CANCELLED", 0, 0, DeliveryStatus.PENDING);
        this.createOrder(product, supplier, stockLocation, 100, 1, "ACCEPTED", 100, 0, DeliveryStatus.FULL);
        this.createOrder(product, supplier, stockLocation, 100, 1, "ACCEPTED", 50, 0, DeliveryStatus.PART);
        this.createOrder(product, supplier, stockLocation, 200, 1, "REJECTED", 0, 0, DeliveryStatus.PENDING);
        this.addRelationships(product, stockLocation, supplier, true, 0, 100, 100, new BigDecimal("2.0"), 1);
        BigDecimal total = new BigDecimal("110.0");
        BigDecimal taxAmount = new BigDecimal("10.0");
        BigDecimal quantity = new BigDecimal("50");
        List order = this.generator.createOrder(supplier, stockLocation, true);
        Assert.assertEquals((long)2L, (long)order.size());
        this.save(order);
        this.checkOrder((FinancialAct)order.get(0), supplier, stockLocation, total, taxAmount);
        this.checkOrderItem((FinancialAct)order.get(1), product, quantity, total, taxAmount);
    }

    @Test
    public void testStockLocationSupplier() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier1 = this.supplierFactory.createSupplier();
        Party supplier2 = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        this.addProductSupplierRelationship(product1, supplier1, true, 2, 1);
        this.addProductSupplierRelationship(product1, supplier2, false, 3, 1);
        this.addProductStockLocationRelationship(product1, stockLocation, supplier2, 1, 10, 5);
        this.save((IMObject[])new Entity[]{product1, supplier1, supplier2, stockLocation});
        List order1 = this.generator.createOrder(supplier1, stockLocation, false);
        Assert.assertEquals((long)0L, (long)order1.size());
        BigDecimal total = new BigDecimal("29.70");
        BigDecimal tax = new BigDecimal("2.70");
        List order2 = this.generator.createOrder(supplier2, stockLocation, false);
        Assert.assertEquals((long)2L, (long)order2.size());
        this.save(order2);
        this.checkOrder((FinancialAct)order2.get(0), supplier2, stockLocation, total, tax);
        this.checkOrderItem((FinancialAct)order2.get(1), product1, BigDecimal.valueOf(9L), total, tax);
    }

    @Test
    public void testMultipleProductSupplierRelationshipsForProductSelectsPreferred() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier1 = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        this.addProductSupplierRelationship(product1, supplier1, false, 3, 1);
        this.addProductSupplierRelationship(product1, supplier1, true, 2, 1);
        this.addProductStockLocationRelationship(product1, stockLocation, null, 1, 10, 5);
        List order = this.generator.createOrder(supplier1, stockLocation, false);
        Assert.assertEquals((long)2L, (long)order.size());
        this.save(order);
        BigDecimal total = new BigDecimal("19.80");
        BigDecimal tax = new BigDecimal("1.80");
        this.checkOrder((FinancialAct)order.get(0), supplier1, stockLocation, total, tax);
        this.checkOrderItem((FinancialAct)order.get(1), product1, BigDecimal.valueOf(9L), total, tax);
    }

    @Test
    public void testMultiplePreferredProductSupplierRelationshipsSelectsLowestId() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier1 = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        this.addProductSupplierRelationship(product1, supplier1, true, 2, 1);
        this.addProductSupplierRelationship(product1, supplier1, true, 3, 1);
        this.addProductStockLocationRelationship(product1, stockLocation, null, 1, 10, 5);
        List order = this.generator.createOrder(supplier1, stockLocation, false);
        Assert.assertEquals((long)2L, (long)order.size());
        this.save(order);
        BigDecimal total = new BigDecimal("19.80");
        BigDecimal tax = new BigDecimal("1.80");
        this.checkOrder((FinancialAct)order.get(0), supplier1, stockLocation, total, tax);
        this.checkOrderItem((FinancialAct)order.get(1), product1, BigDecimal.valueOf(9L), total, tax);
    }

    @Test
    public void testMultipleSupplierRelationshipsWithPreferredStockLocationSelectsLowestId() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier1 = this.supplierFactory.createSupplier();
        Party supplier2 = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        this.addProductSupplierRelationship(product1, supplier1, false, 2, 1);
        this.addProductSupplierRelationship(product1, supplier1, false, 3, 1);
        this.addProductSupplierRelationship(product1, supplier2, true, 4, 1);
        this.addProductStockLocationRelationship(product1, stockLocation, supplier1, 1, 10, 5);
        List order = this.generator.createOrder(supplier1, stockLocation, false);
        Assert.assertEquals((long)2L, (long)order.size());
        this.save(order);
        BigDecimal total = new BigDecimal("19.80");
        BigDecimal tax = new BigDecimal("1.80");
        this.checkOrder((FinancialAct)order.get(0), supplier1, stockLocation, total, tax);
        this.checkOrderItem((FinancialAct)order.get(1), product1, BigDecimal.valueOf(9L), total, tax);
    }

    @Test
    public void testMultiplePreferredSupplierRelationshipsWithPreferredStockLocationSelectsLowestId() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier1 = this.supplierFactory.createSupplier();
        Party supplier2 = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        this.addProductSupplierRelationship(product1, supplier1, true, 2, 1);
        this.addProductSupplierRelationship(product1, supplier1, true, 3, 1);
        this.addProductSupplierRelationship(product1, supplier2, true, 4, 1);
        this.addProductStockLocationRelationship(product1, stockLocation, supplier1, 1, 10, 5);
        List order = this.generator.createOrder(supplier1, stockLocation, false);
        Assert.assertEquals((long)2L, (long)order.size());
        this.save(order);
        BigDecimal total = new BigDecimal("19.80");
        BigDecimal tax = new BigDecimal("1.80");
        this.checkOrder((FinancialAct)order.get(0), supplier1, stockLocation, total, tax);
        this.checkOrderItem((FinancialAct)order.get(1), product1, BigDecimal.valueOf(9L), total, tax);
    }

    @Test
    public void testFractionalStockOnHand() {
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Party supplier1 = this.supplierFactory.createSupplier();
        Product product1 = this.productFactory.createMedication();
        this.addProductSupplierRelationship(product1, supplier1, true, 2, 10);
        this.addProductStockLocationRelationship(product1, stockLocation, supplier1, new BigDecimal("9.63"), 10, 10);
        List order = this.generator.createOrder(supplier1, stockLocation, false);
        Assert.assertEquals((long)2L, (long)order.size());
        this.save(order);
        BigDecimal total = new BigDecimal("2.20");
        BigDecimal tax = new BigDecimal("0.20");
        this.checkOrder((FinancialAct)order.get(0), supplier1, stockLocation, total, tax);
        this.checkOrderItem((FinancialAct)order.get(1), product1, BigDecimal.ONE, total, tax);
    }

    private void checkOrder(FinancialAct order, Party supplier, Party stockLocation, BigDecimal total, BigDecimal tax) {
        IMObjectBean bean = this.getBean((IMObject)order);
        Assert.assertTrue((boolean)bean.isA(new String[]{"act.supplierOrder"}));
        Assert.assertEquals((Object)supplier.getObjectReference(), (Object)bean.getTargetRef("supplier"));
        Assert.assertEquals((Object)stockLocation.getObjectReference(), (Object)bean.getTargetRef("stockLocation"));
        this.checkEquals(total, order.getTotal());
        this.checkEquals(tax, order.getTaxAmount());
    }

    private void checkOrderItem(List<FinancialAct> order, Product product, BigDecimal quantity, BigDecimal total, BigDecimal tax) {
        for (FinancialAct act : order) {
            IMObjectBean bean = this.getBean((IMObject)act);
            if (!bean.isA(new String[]{"act.supplierOrderItem"}) || !Objects.equals(product.getObjectReference(), bean.getTargetRef("product"))) continue;
            this.checkOrderItem(act, product, quantity, total, tax);
            return;
        }
        Assert.fail((String)"Order item not found");
    }

    private void checkOrderItem(FinancialAct item, Product product, BigDecimal quantity, BigDecimal total, BigDecimal tax) {
        IMObjectBean bean = this.getBean((IMObject)item);
        Assert.assertTrue((boolean)bean.isA(new String[]{"act.supplierOrderItem"}));
        Assert.assertEquals((Object)product.getObjectReference(), (Object)bean.getTargetRef("product"));
        this.checkEquals(quantity, item.getQuantity());
        this.checkEquals(total, item.getTotal());
        this.checkEquals(tax, item.getTaxAmount());
    }

    private void checkOnlyStock(List<Stock> stock, Product product, Party supplier, Party stockLocation, int quantity, int onOrder, int toOrder) {
        Assert.assertEquals((long)1L, (long)stock.size());
        this.checkStock(stock.get(0), product, supplier, stockLocation, quantity, onOrder, toOrder);
    }

    private void checkStock(List<Stock> stock, Product product, Party supplier, Party stockLocation, int quantity, int onOrder, int toOrder) {
        Stock s = this.getStock(stock, product);
        Assert.assertNotNull((Object)s);
        this.checkStock(s, product, supplier, stockLocation, quantity, onOrder, toOrder);
    }

    private Stock getStock(List<Stock> stock, Product product) {
        Stock result = null;
        for (Stock s : stock) {
            if (!s.getProduct().equals(product)) continue;
            Assert.assertNull(result);
            result = s;
        }
        return result;
    }

    private void checkStock(Stock stock, Product product, Party supplier, Party stockLocation, int quantity, int onOrder, int toOrder) {
        Assert.assertEquals((Object)product, (Object)stock.getProduct());
        Assert.assertEquals((Object)supplier, (Object)stock.getSupplier());
        Assert.assertEquals((Object)stockLocation, (Object)stock.getStockLocation());
        this.checkEquals(BigDecimal.valueOf(quantity), stock.getQuantity());
        this.checkEquals(BigDecimal.valueOf(onOrder), stock.getOnOrder());
        this.checkEquals(BigDecimal.valueOf(toOrder), stock.getToOrder());
    }

    private void createOrder(Product product, Party supplier, Party stockLocation, int quantity, String status) {
        this.createOrder(product, supplier, stockLocation, quantity, 1, status, 0, 0, DeliveryStatus.PENDING);
    }

    private List<FinancialAct> createOrder(Product product, Party supplier, Party stockLocation, int quantity, int packageSize, String status, int receivedQuantity, int cancelledQuantity, DeliveryStatus deliveryStatus) {
        TestOrderBuilder builder = (TestOrderBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderItemBuilder)((TestOrderBuilder)((TestOrderBuilder)((TestOrderBuilder)this.supplierFactory.newOrder().supplier(supplier)).stockLocation(stockLocation)).status(status)).deliveryStatus(deliveryStatus).item().product(product)).quantity(quantity)).packageSize(packageSize)).unitPrice(1)).receivedQuantity(receivedQuantity).cancelledQuantity(cancelledQuantity).add();
        FinancialAct order = (FinancialAct)builder.build();
        List<FinancialAct> items = builder.getItems();
        Assert.assertEquals((long)1L, (long)items.size());
        return Arrays.asList(order, items.get(0));
    }

    private ProductSupplier addRelationships(Product product, Party stockLocation, Party supplier, boolean preferred, int quantity, int idealQty, int criticalQty) {
        return this.addRelationships(product, stockLocation, supplier, preferred, quantity, idealQty, criticalQty, BigDecimal.ONE, 1);
    }

    private ProductSupplier addRelationships(Product product, Party stockLocation, Party supplier, boolean preferred, int quantity, int idealQty, int criticalQty, BigDecimal unitPrice, int packageSize) {
        this.addProductStockLocationRelationship(product, stockLocation, null, quantity, idealQty, criticalQty);
        return this.addProductSupplierRelationship(product, supplier, preferred, unitPrice, packageSize);
    }

    private void addProductSupplierRelationship(Product product, Party supplier, boolean preferred, int unitPrice, int packageSize) {
        this.addProductSupplierRelationship(product, supplier, preferred, BigDecimal.valueOf(unitPrice), packageSize);
    }

    private ProductSupplier addProductSupplierRelationship(Product product, Party supplier, boolean preferred, BigDecimal unitPrice, int packageSize) {
        Object builder = this.productFactory.updateProduct(product).newProductSupplier().supplier(supplier).preferred(preferred).packageSize(packageSize).nettPrice(unitPrice).add();
        ((AbstractTestIMObjectBuilder)builder).build();
        List<EntityLink> productSuppliers = ((TestProductBuilder)builder).getProductSuppliers();
        Assert.assertEquals((long)1L, (long)productSuppliers.size());
        return new ProductSupplier((Relationship)productSuppliers.get(0), this.getArchetypeService());
    }

    private EntityLink addProductStockLocationRelationship(Product product, Party stockLocation, Party supplier, int quantity, int idealQty, int criticalQty) {
        return this.addProductStockLocationRelationship(product, stockLocation, supplier, BigDecimal.valueOf(quantity), idealQty, criticalQty);
    }

    private EntityLink addProductStockLocationRelationship(Product product, Party stockLocation, Party supplier, BigDecimal quantity, int idealQty, int criticalQty) {
        Object builder = this.productFactory.updateProduct(product).newProductStockLocation().stockLocation(stockLocation).quantity(quantity).idealQuantity(idealQty).criticalQuantity(criticalQty).supplier(supplier).add();
        ((AbstractTestIMObjectBuilder)builder).build();
        List<EntityLink> productStockLocations = ((TestProductBuilder)builder).getProductStockLocations();
        Assert.assertEquals((long)1L, (long)productStockLocations.size());
        return productStockLocations.get(0);
    }
}

