/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.stock.io;

import au.com.bytecode.opencsv.CSVWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.doc.DocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.rules.stock.io.StockCSVReader;
import org.openvpms.archetype.rules.stock.io.StockCSVWriter;
import org.openvpms.archetype.rules.stock.io.StockData;
import org.openvpms.archetype.rules.stock.io.StockDataSet;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.service.archetype.ArchetypeService;

public class StockCSVWriterReaderTestCase
extends ArchetypeServiceTest {
    private DocumentHandlers handlers;

    @Before
    public void setUp() {
        this.handlers = new DocumentHandlers((ArchetypeService)this.getArchetypeService());
    }

    @Test
    public void testWriteRead() {
        Party stockLocation = ProductTestHelper.createStockLocation();
        Product product = TestHelper.createProduct();
        StockData data = new StockData(stockLocation.getId(), stockLocation.getName(), product.getId(), product.getName(), "Mls", BigDecimal.ONE, BigDecimal.TEN);
        StockCSVWriter writer = new StockCSVWriter(this.handlers, ',');
        Document document = writer.write("test.csv", Collections.singletonList(data).iterator());
        StockCSVReader reader = new StockCSVReader(this.handlers, ',');
        StockDataSet read = reader.read((org.openvpms.component.model.document.Document)document);
        Assert.assertEquals((long)1L, (long)read.getData().size());
        Assert.assertEquals((long)0L, (long)read.getErrors().size());
        Assert.assertNull((Object)read.getAdjustment());
        StockData d = (StockData)read.getData().get(0);
        Assert.assertEquals((long)stockLocation.getId(), (long)d.getStockLocationId());
        Assert.assertEquals((Object)stockLocation.getName(), (Object)d.getStockLocationName());
        Assert.assertEquals((long)product.getId(), (long)d.getProductId());
        Assert.assertEquals((Object)product.getName(), (Object)d.getProductName());
        Assert.assertEquals((Object)"Mls", (Object)d.getSellingUnits());
        this.checkEquals(BigDecimal.ONE, d.getQuantity());
        this.checkEquals(BigDecimal.TEN, d.getNewQuantity());
    }

    @Test
    public void testMissingStockLocationId() throws IOException {
        String[] data = new String[]{"", "stock location", "10", "product", "Mls", "10", "0"};
        this.checkError(data, "A value for Stock Location Identifier is required");
    }

    @Test
    public void testMissingStockLocationName() throws IOException {
        String[] data = new String[]{"104", "", "10", "product", "Mls", "10", "0"};
        this.checkError(data, "A value for Stock Location Name is required");
    }

    @Test
    public void testMissingProductIdentifier() throws IOException {
        String[] data = new String[]{"104", "stock location", "", "product", "Mls", "10", "0"};
        this.checkError(data, "A value for Product Identifier is required");
    }

    @Test
    public void testMissingProductName() throws IOException {
        String[] data = new String[]{"104", "stock location", "10", "", "Mls", "10", "0"};
        this.checkError(data, "A value for Product Name is required");
    }

    @Test
    public void testMissingQuantity() throws IOException {
        String[] data = new String[]{"104", "stock location", "10", "product", "Mls", "", "0"};
        this.checkError(data, "A value for Quantity is required");
    }

    @Test
    public void testMissingNewQuantity() throws IOException {
        String[] data = new String[]{"104", "stock location", "10", "product", "Mls", "10", ""};
        this.checkError(data, "A value for New Quantity is required");
    }

    private void checkError(String[] line, String expectedError) throws IOException {
        StockDataSet read = this.createStockDataSet(line);
        Assert.assertEquals((long)0L, (long)read.getData().size());
        Assert.assertEquals((long)1L, (long)read.getErrors().size());
        Assert.assertEquals((Object)expectedError, (Object)((StockData)read.getErrors().get(0)).getError());
        Assert.assertNull((Object)read.getAdjustment());
    }

    private StockDataSet createStockDataSet(String[] data) throws IOException {
        Document document = this.createCSV(data, this.handlers);
        StockCSVReader reader = new StockCSVReader(this.handlers, ',');
        return reader.read((org.openvpms.component.model.document.Document)document);
    }

    private Document createCSV(String[] data, DocumentHandlers handlers) throws IOException {
        StringWriter writer = new StringWriter();
        CSVWriter csv = new CSVWriter((Writer)writer, ',');
        csv.writeNext(StockCSVWriter.HEADER);
        csv.writeNext(data);
        csv.close();
        DocumentHandler handler = handlers.get("Dummy.csv", "text/csv");
        return handler.create("Dummy.csv", (InputStream)new ByteArrayInputStream(writer.toString().getBytes(StandardCharsets.UTF_8)), "text/csv", -1);
    }
}

