/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product.io;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.io.AbstractProductIOTest;
import org.openvpms.archetype.rules.product.io.PriceData;
import org.openvpms.archetype.rules.product.io.ProductData;
import org.openvpms.archetype.rules.product.io.ProductDataFilter;
import org.openvpms.archetype.rules.product.io.ProductDataSet;
import org.openvpms.archetype.rules.product.io.ProductImporter;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;

public class ProductImporterTestCase
extends AbstractProductIOTest {
    private Product product1;
    private Product product2;
    private ProductPrice fixed1;
    private ProductPrice unit1;
    private ProductPrice fixed2;
    private ProductPrice unit2;
    private ProductImporter importer;
    private ProductPriceRules rules;

    @Before
    public void setUp() {
        this.rules = new ProductPriceRules((ArchetypeService)this.getArchetypeService());
        this.importer = new ProductImporter(this.rules, this.getArchetypeService());
        this.product1 = this.createProduct("Product 1", "P1", new ProductPrice[0]);
        this.product2 = this.createProduct("Product 2", "P2", new ProductPrice[0]);
        this.fixed1 = this.createFixedPrice("1.0", "0.5", "100", "10", "2013-02-01", "2013-04-01", true);
        this.unit1 = this.createUnitPrice("1.92", "1.2", "60", "10", "2013-02-02", "2013-04-02");
        this.product1.addProductPrice(this.fixed1);
        this.product1.addProductPrice(this.unit1);
        this.fixed2 = this.createFixedPrice("1.08", "0.6", "80", "10", "2013-04-02", "2013-06-01", true);
        this.unit2 = this.createUnitPrice("2.55", "1.5", "70", "10", "2013-04-03", "2013-06-02");
        this.product2.addProductPrice(this.fixed2);
        this.product2.addProductPrice(this.unit2);
        this.save((IMObject[])new Product[]{this.product1, this.product2});
    }

    @Test
    public void testImportNoChanges() {
        ProductData data1 = this.createProduct(this.product1);
        ProductData data2 = this.createProduct(this.product2);
        this.importProducts(data1, data2);
        this.product1 = this.get(this.product1);
        this.product2 = this.get(this.product2);
        Assert.assertEquals((long)2L, (long)this.product1.getProductPrices().size());
        Assert.assertEquals((long)2L, (long)this.product2.getProductPrices().size());
        this.checkPrice(this.product1, this.fixed1);
        this.checkPrice(this.product1, this.unit1);
        this.checkPrice(this.product2, this.fixed2);
        this.checkPrice(this.product2, this.unit2);
    }

    @Test
    public void testUpdateExisting() {
        ProductData data = this.createProduct(this.product1);
        BigDecimal fixedPrice = new BigDecimal("2.0");
        BigDecimal fixedCost = new BigDecimal("1.0");
        BigDecimal fixedDiscount = new BigDecimal("25");
        BigDecimal markup = new BigDecimal("100");
        BigDecimal unitPrice = new BigDecimal("1.0");
        BigDecimal unitCost = new BigDecimal("0.5");
        BigDecimal unitDiscount = new BigDecimal("20");
        PriceData fixed = (PriceData)data.getFixedPrices().get(0);
        fixed.setPrice(fixedPrice);
        fixed.setCost(fixedCost);
        fixed.setMaxDiscount(fixedDiscount);
        PriceData unit = (PriceData)data.getUnitPrices().get(0);
        unit.setPrice(unitPrice);
        unit.setCost(unitCost);
        unit.setMaxDiscount(unitDiscount);
        this.importProducts(data);
        this.product1 = this.get(this.product1);
        Assert.assertEquals((long)2L, (long)this.product1.getProductPrices().size());
        this.checkFixedPrice(this.product1, fixedPrice, fixedCost, markup, fixedDiscount, fixed.getFrom(), fixed.getTo(), true);
        this.checkUnitPrice(this.product1, unitPrice, unitCost, markup, unitDiscount, unit.getFrom(), unit.getTo());
    }

    @Test
    public void testCreatePrice() {
        this.fixed1.setToDate(null);
        this.unit1.setToDate(null);
        this.save((IMObject)this.product1);
        ProductData data = this.createProduct(this.product1);
        BigDecimal fixedPrice = new BigDecimal("2.0");
        BigDecimal fixedCost = new BigDecimal("1.0");
        BigDecimal fixedDiscount = new BigDecimal("50");
        BigDecimal markup = new BigDecimal("100");
        BigDecimal unitPrice = new BigDecimal("1.0");
        BigDecimal unitDiscount = new BigDecimal("25");
        BigDecimal unitCost = new BigDecimal("0.5");
        Set groups = Collections.emptySet();
        data.addFixedPrice(-1L, fixedPrice, fixedCost, fixedDiscount, TestHelper.getDate("2013-06-02"), null, true, groups, 1);
        data.addUnitPrice(-1L, unitPrice, unitCost, unitDiscount, TestHelper.getDate("2013-06-03"), null, groups, 1);
        this.importProducts(data);
        this.product1 = this.get(this.product1);
        Assert.assertEquals((long)4L, (long)this.product1.getProductPrices().size());
        this.checkPrice(this.product1, this.createFixedPrice("1.0", "0.5", "100", "10", "2013-02-01", "2013-06-02", true));
        this.checkPrice(this.product1, this.createUnitPrice("1.92", "1.2", "60", "10", "2013-02-02", "2013-06-03"));
        this.checkFixedPrice(this.product1, fixedPrice, fixedCost, markup, fixedDiscount, TestHelper.getDate("2013-06-02"), null, true);
        this.checkUnitPrice(this.product1, unitPrice, unitCost, markup, unitDiscount, TestHelper.getDate("2013-06-03"), null);
    }

    @Test
    public void testFilteredImport() {
        this.fixed1.setToDate(null);
        this.unit1.setToDate(null);
        this.save((IMObject)this.product1);
        ProductData data = this.createProduct(this.product1);
        data.setReference(null);
        BigDecimal fixedPrice = new BigDecimal("2.0");
        BigDecimal fixedCost = new BigDecimal("1.0");
        BigDecimal fixedDiscount = new BigDecimal("5");
        BigDecimal markup = new BigDecimal("100");
        BigDecimal unitPrice = new BigDecimal("1.0");
        BigDecimal unitCost = new BigDecimal("0.5");
        BigDecimal unitDiscount = new BigDecimal("15");
        Set groups = Collections.emptySet();
        data.addFixedPrice(-1L, fixedPrice, fixedCost, fixedDiscount, TestHelper.getDate("2014-01-01"), TestHelper.getDate("2014-06-01"), true, groups, 1);
        data.addUnitPrice(-1L, unitPrice, unitCost, unitDiscount, TestHelper.getDate("2014-01-01"), TestHelper.getDate("2014-06-01"), groups, 1);
        List input = Collections.singletonList(data);
        ProductDataFilter filter = new ProductDataFilter(this.rules, this.getArchetypeService());
        ProductDataSet filtered = filter.filter(input);
        Assert.assertTrue((boolean)filtered.getErrors().isEmpty());
        input = filtered.getData();
        Assert.assertEquals((long)1L, (long)input.size());
        Assert.assertEquals((Object)this.product1.getObjectReference(), (Object)((ProductData)input.get(0)).getReference());
        this.importProducts((ProductData)input.get(0));
        this.product1 = this.get(this.product1);
        Assert.assertEquals((long)4L, (long)this.product1.getProductPrices().size());
        this.checkPrice(this.product1, this.createFixedPrice("1.0", "0.5", "100", "10", "2013-02-01", "2014-01-01", true));
        this.checkPrice(this.product1, this.createUnitPrice("1.92", "1.2", "60", "10", "2013-02-02", "2014-01-01"));
        this.checkFixedPrice(this.product1, fixedPrice, fixedCost, markup, fixedDiscount, TestHelper.getDate("2014-01-01"), TestHelper.getDate("2014-06-01"), true);
        this.checkUnitPrice(this.product1, unitPrice, unitCost, markup, unitDiscount, TestHelper.getDate("2014-01-01"), TestHelper.getDate("2014-06-01"));
    }

    private void importProducts(ProductData ... data) {
        List<ProductData> products = Arrays.asList(data);
        this.importer.run(products);
    }
}

