/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product.io;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.junit.Assert;
import org.openvpms.archetype.rules.product.PricingGroup;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.io.PriceData;
import org.openvpms.archetype.rules.product.io.ProductData;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.product.TestFixedPriceBuilder;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.product.TestUnitPriceBuilder;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractProductIOTest
extends ArchetypeServiceTest {
    @Autowired
    protected TestProductFactory productFactory;

    protected Product createProduct(String name, String printedName, ProductPrice ... prices) {
        return (Product)this.newProduct(name, printedName, prices).build();
    }

    protected TestMedicationProductBuilder newProduct(String name, String printedName, ProductPrice ... prices) {
        return (TestMedicationProductBuilder)((TestMedicationProductBuilder)((TestMedicationProductBuilder)this.productFactory.newMedication().name(name)).printedName(printedName)).addPrices(prices);
    }

    protected ProductData createProduct(Product product) {
        return this.createProduct(product, BigDecimal.ZERO, true);
    }

    protected ProductData createProduct(Product product, BigDecimal taxRate, boolean copyPrices) {
        IArchetypeService service = this.getArchetypeService();
        ProductPriceRules rules = new ProductPriceRules((ArchetypeService)service);
        IMObjectBean bean = this.getBean((IMObject)product);
        ProductData result = new ProductData(product.getId(), product.getName(), bean.getString("printedName"), taxRate, 1);
        result.setReference(product.getObjectReference());
        if (copyPrices) {
            PriceData priceDate;
            for (ProductPrice price : rules.getProductPrices(product, "productPrice.fixedPrice", PricingGroup.ALL)) {
                priceDate = new PriceData(price, (ArchetypeService)service);
                result.addPrice(priceDate);
            }
            for (ProductPrice price : rules.getProductPrices(product, "productPrice.unitPrice", PricingGroup.ALL)) {
                priceDate = new PriceData(price, (ArchetypeService)service);
                result.addPrice(priceDate);
            }
        }
        return result;
    }

    protected void checkPrice(Product product, ProductPrice expected) {
        IMObjectBean bean = this.getBean((IMObject)expected);
        BigDecimal expectedPrice = expected.getPrice();
        BigDecimal expectedCost = bean.getBigDecimal("cost");
        BigDecimal expectedMarkup = bean.getBigDecimal("markup");
        BigDecimal expectedMaxDiscount = bean.getBigDecimal("maxDiscount");
        Date expectedFrom = expected.getFromDate();
        Date expectedTo = expected.getToDate();
        boolean isDefault = bean.hasNode("default") && bean.getBoolean("default");
        String shortName = expected.getArchetype();
        this.checkPrice(product, shortName, expectedPrice, expectedCost, expectedMarkup, expectedMaxDiscount, expectedFrom, expectedTo, isDefault);
    }

    protected void checkFixedPrice(Product product, BigDecimal expectedPrice, BigDecimal expectedCost, BigDecimal expectedMarkup, BigDecimal expectedMaxDiscount, Date expectedFrom, Date expectedTo, boolean expectedDefault) {
        this.checkPrice(product, "productPrice.fixedPrice", expectedPrice, expectedCost, expectedMarkup, expectedMaxDiscount, expectedFrom, expectedTo, expectedDefault);
    }

    protected void checkUnitPrice(Product product, BigDecimal expectedPrice, BigDecimal expectedCost, BigDecimal expectedMarkup, BigDecimal expectedMaxDiscount, Date expectedFrom, Date expectedTo) {
        this.checkPrice(product, "productPrice.unitPrice", expectedPrice, expectedCost, expectedMarkup, expectedMaxDiscount, expectedFrom, expectedTo, false);
    }

    protected void checkPrice(Product product, String shortName, BigDecimal expectedPrice, BigDecimal expectedCost, BigDecimal expectedMarkup, BigDecimal expectedMaxDiscount, Date expectedFrom, Date expectedTo, boolean expectedDefault) {
        boolean found = false;
        for (ProductPrice price : product.getProductPrices()) {
            IMObjectBean priceBean = this.getBean((IMObject)price);
            if (!price.getArchetype().equals(shortName) || price.getPrice().compareTo(expectedPrice) != 0 || priceBean.getBigDecimal("cost").compareTo(expectedCost) != 0 || priceBean.getBigDecimal("markup").compareTo(expectedMarkup) != 0 || priceBean.getBigDecimal("maxDiscount").compareTo(expectedMaxDiscount) != 0 || !Objects.equals(expectedFrom, price.getFromDate()) || !Objects.equals(expectedTo, price.getToDate())) continue;
            found = !priceBean.hasNode("default") || priceBean.getBoolean("default") == expectedDefault;
            break;
        }
        Assert.assertTrue((String)"Failed to find price", (boolean)found);
    }

    protected ProductPrice createFixedPrice(String price, String cost, String markup, String maxDiscount, Date from, Date to, boolean defaultPrice) {
        return this.newFixedPrice(price, cost, markup, maxDiscount, from, to, defaultPrice).build();
    }

    protected ProductPrice createFixedPrice(String price, String cost, String markup, String maxDiscount, String from, String to, boolean defaultPrice) {
        return ((TestFixedPriceBuilder)this.newFixedPrice(price, cost, markup, maxDiscount, defaultPrice).dateRange(from, to)).build();
    }

    protected TestFixedPriceBuilder<?> newFixedPrice(String price, String cost, String markup, String maxDiscount, Date from, Date to, boolean defaultPrice) {
        return (TestFixedPriceBuilder)this.newFixedPrice(price, cost, markup, maxDiscount, defaultPrice).dateRange(from, to);
    }

    private TestFixedPriceBuilder<?> newFixedPrice(String price, String cost, String markup, String maxDiscount, boolean defaultPrice) {
        return ((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)((TestFixedPriceBuilder)this.productFactory.newFixedPrice().price(price)).cost(cost)).markup(markup)).maxDiscount(maxDiscount)).defaultPrice(defaultPrice);
    }

    protected ProductPrice createUnitPrice(String price, String cost, String markup, String maxDiscount, Date from, Date to) {
        return this.newUnitPrice(price, cost, markup, maxDiscount, from, to).build();
    }

    protected ProductPrice createUnitPrice(String price, String cost, String markup, String maxDiscount, String from, String to) {
        return ((TestUnitPriceBuilder)this.newUnitPrice(price, cost, markup, maxDiscount).dateRange(from, to)).build();
    }

    protected TestUnitPriceBuilder<?> newUnitPrice(String price, String cost, String markup, String maxDiscount, Date from, Date to) {
        return (TestUnitPriceBuilder)this.newUnitPrice(price, cost, markup, maxDiscount).dateRange(from, to);
    }

    private TestUnitPriceBuilder<?> newUnitPrice(String price, String cost, String markup, String maxDiscount) {
        return (TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)((TestUnitPriceBuilder)this.productFactory.newUnitPrice().price(price)).cost(cost)).markup(markup)).maxDiscount(maxDiscount);
    }
}

