/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.product.ProductQueryFactory;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;

public class ProductQueryFactoryTestCase
extends ArchetypeServiceTest {
    private static final String FELINE = "FELINE";
    private static final String CANINE = "CANINE";

    @Test
    public void testCreateForSpeciesAndName() {
        ArchetypeQuery canine = ProductQueryFactory.create((String[])new String[]{"product.medication", "product.template", "product.service", "product.merchandise"}, null, (String)CANINE, (boolean)false, null, null);
        this.checkQuery((IArchetypeQuery)canine, true, false, true);
        ArchetypeQuery feline = ProductQueryFactory.create((String[])new String[]{"product.medication"}, null, (String)FELINE, (boolean)false, null, null);
        this.checkQuery((IArchetypeQuery)feline, false, true, false);
        ArchetypeQuery canine2 = ProductQueryFactory.create((String[])new String[]{"product.medication", "product.template", "product.service", "product.merchandise"}, (String)"XProduct*", (String)CANINE, (boolean)false, null, null);
        this.checkQuery((IArchetypeQuery)canine2, true, false, true);
        ArchetypeQuery feline2 = ProductQueryFactory.create((String[])new String[]{"product.medication"}, (String)"XProduct*", (String)FELINE, (boolean)false, null, null);
        this.checkQuery((IArchetypeQuery)feline2, false, true, false);
    }

    @Test
    public void testCreateForStockLocation() {
        Party location1 = TestHelper.createLocation();
        Party location2 = TestHelper.createLocation();
        Party stockLocation1 = ProductTestHelper.createStockLocation(location1);
        Party stockLocation2 = ProductTestHelper.createStockLocation(location2);
        Product medicationA = ProductTestHelper.createMedication();
        Product medicationB = ProductTestHelper.createMedication();
        Product medicationC = ProductTestHelper.createMedication();
        Product medicationD = ProductTestHelper.createMedication();
        Product merchandiseA = ProductTestHelper.createMerchandise();
        Product merchandiseB = ProductTestHelper.createMerchandise();
        Product merchandiseC = ProductTestHelper.createMerchandise();
        ProductTestHelper.setStockQuantity(medicationA, stockLocation1, BigDecimal.TEN);
        ProductTestHelper.setStockQuantity(medicationA, stockLocation2, BigDecimal.TEN);
        ProductTestHelper.setStockQuantity(medicationB, stockLocation1, BigDecimal.TEN);
        ProductTestHelper.setStockQuantity(medicationC, stockLocation2, BigDecimal.TEN);
        ProductTestHelper.setStockQuantity(merchandiseA, stockLocation1, BigDecimal.TEN);
        ProductTestHelper.setStockQuantity(merchandiseB, stockLocation2, BigDecimal.TEN);
        this.checkQuery(false, location1, stockLocation1, true, medicationA, medicationB, medicationD, merchandiseA, merchandiseC);
        this.checkQuery(false, location1, stockLocation1, false, medicationC, merchandiseB);
        this.checkQuery(true, location1, stockLocation1, true, medicationA, medicationB, merchandiseA);
        this.checkQuery(true, location1, stockLocation1, false, medicationC, medicationD, merchandiseB, merchandiseC);
    }

    @Test
    public void testCreateForLocation() {
        Party location1 = TestHelper.createLocation();
        Party location2 = TestHelper.createLocation();
        Product serviceA = ProductTestHelper.createService();
        Product serviceB = ProductTestHelper.createService();
        Product serviceC = ProductTestHelper.createService();
        Product serviceD = ProductTestHelper.createService();
        Product templateA = ProductTestHelper.createTemplate();
        Product templateB = ProductTestHelper.createTemplate();
        Product templateC = ProductTestHelper.createTemplate();
        ProductTestHelper.addLocationExclusion(serviceA, location2);
        ProductTestHelper.addLocationExclusion(serviceB, location1);
        ProductTestHelper.addLocationExclusion(serviceC, location1);
        ProductTestHelper.addLocationExclusion(serviceC, location2);
        ProductTestHelper.addLocationExclusion(templateA, location2);
        ProductTestHelper.addLocationExclusion(templateB, location1);
        this.checkQuery(false, location1, null, true, serviceA, serviceB, serviceC, serviceD, templateA, templateB);
        this.checkQuery(true, location1, null, true, serviceA, serviceD, templateA, templateC);
        this.checkQuery(true, location1, null, false, serviceB, serviceC, templateB);
    }

    private void checkQuery(IArchetypeQuery query, boolean expectCanine, boolean expectFeline, boolean expectMerchandise) {
        IArchetypeService service = this.getArchetypeService();
        query.setCountResults(true);
        int count = service.get(query).getTotalResults();
        Product canineProduct = TestHelper.createProduct("product.service", CANINE);
        Product felineProduct = TestHelper.createProduct("product.medication", FELINE);
        Product merchProduct = TestHelper.createProduct("product.merchandise", null);
        boolean canineFound = false;
        boolean felineFound = false;
        boolean merchandiseFound = false;
        int matches = 0;
        if (expectCanine) {
            ++matches;
        }
        if (expectFeline) {
            ++matches;
        }
        if (expectMerchandise) {
            ++matches;
        }
        int newCount = service.get(query).getTotalResults();
        Assert.assertEquals((long)(count + matches), (long)newCount);
        IMObjectQueryIterator iterator = new IMObjectQueryIterator(query);
        while (iterator.hasNext()) {
            Product product = (Product)iterator.next();
            if (product.equals(canineProduct)) {
                canineFound = true;
                continue;
            }
            if (product.equals(felineProduct)) {
                felineFound = true;
                continue;
            }
            if (!product.equals(merchProduct)) continue;
            merchandiseFound = true;
        }
        Assert.assertEquals((Object)expectCanine, (Object)canineFound);
        Assert.assertEquals((Object)expectFeline, (Object)felineFound);
        Assert.assertEquals((Object)expectMerchandise, (Object)merchandiseFound);
    }

    private void checkQuery(boolean useLocationProducts, Party location, Party stockLocation, boolean exists, Product ... products) {
        String[] archetypes = new String[]{"product.*"};
        ArchetypeQuery query = ProductQueryFactory.create((String[])archetypes, null, null, (boolean)useLocationProducts, (Party)location, (Party)stockLocation);
        ArrayList<Product> list = new ArrayList<Product>(Arrays.asList(products));
        IMObjectQueryIterator iterator = new IMObjectQueryIterator((IArchetypeQuery)query);
        while (iterator.hasNext()) {
            Product next = (Product)iterator.next();
            if (!list.contains(next)) continue;
            Assert.assertTrue((boolean)exists);
        }
    }
}

