/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.product;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.product.DemographicUpdater;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.springframework.beans.factory.annotation.Autowired;

public class DemographicUpdaterTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestProductFactory productFactory;

    @Test
    public void testEvaluate() {
        Lookup desex = this.productFactory.createDemographicUpdate("party:setPatientDesexed(.)");
        Party patient = this.patientFactory.createPatient();
        this.checkEvaluateDesex(desex, (IMObject)patient, patient);
        Lookup deceased = this.productFactory.createDemographicUpdate("openvpms:set(., 'deceased', true())");
        this.checkEvaluateDeceased(deceased, (IMObject)patient, patient);
    }

    @Test
    public void testEvaluateWithNode() {
        Party patient = this.patientFactory.createPatient();
        Act invoiceItem = (Act)((TestInvoiceItemBuilder)this.accountFactory.newInvoiceItem().patient(patient)).build(false);
        Lookup desex = this.productFactory.createDemographicUpdate("patient.entity", "party:setPatientDesexed(.)");
        this.checkEvaluateDesex(desex, (IMObject)invoiceItem, patient);
        Lookup deceased = this.productFactory.createDemographicUpdate("patient.entity", "openvpms:set(., 'deceased', true())");
        this.checkEvaluateDeceased(deceased, (IMObject)invoiceItem, patient);
    }

    @Test
    public void testEvaluateCollection() {
        Lookup desex = this.productFactory.createDemographicUpdate("party:setPatientDesexed(.)");
        Lookup deceased = this.productFactory.createDemographicUpdate("party:setPatientDeceased(.)");
        List<Lookup> lookups = Arrays.asList(desex, deceased);
        Party patient = this.patientFactory.createPatient();
        DemographicUpdater updater = new DemographicUpdater(this.getArchetypeService());
        updater.evaluate((IMObject)patient, lookups);
        IMObjectBean bean = this.getBean((IMObject)this.get(patient));
        Assert.assertTrue((boolean)bean.getBoolean("desexed"));
        Assert.assertTrue((boolean)bean.getBoolean("deceased"));
    }

    private void checkEvaluateDesex(Lookup desex, IMObject context, Party patient) {
        IMObjectBean bean = this.getBean((IMObject)patient);
        Assert.assertFalse((boolean)bean.getBoolean("desexed"));
        DemographicUpdater updater = new DemographicUpdater(this.getArchetypeService());
        updater.evaluate(context, desex);
        patient = this.get(patient);
        bean = this.getBean((IMObject)patient);
        Assert.assertTrue((boolean)bean.getBoolean("desexed"));
    }

    private void checkEvaluateDeceased(Lookup deceased, IMObject context, Party patient) {
        IMObjectBean bean = this.getBean((IMObject)patient);
        Assert.assertFalse((boolean)bean.getBoolean("deceased"));
        DemographicUpdater updater = new DemographicUpdater(this.getArchetypeService());
        updater.evaluate(context, deceased);
        patient = this.get(patient);
        bean = this.getBean((IMObject)patient);
        Assert.assertTrue((boolean)bean.getBoolean("deceased"));
    }
}

