/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient.reminder;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.reminder.ReminderQueueQueryFactory;
import org.openvpms.archetype.rules.patient.reminder.ReminderTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;

public class ReminderQueueQueryFactoryTestCase
extends ArchetypeServiceTest {
    @Test
    public void testRemindersWithNoItems() {
        ReminderQueueQueryFactory factory = new ReminderQueueQueryFactory();
        Date date = DateRules.getToday();
        Entity reminderType = ReminderTestHelper.createReminderType(1, DateUnits.YEARS, new Lookup[0]);
        Party customer = TestHelper.createCustomer();
        Party patient = TestHelper.createPatient(customer);
        Act reminder1 = ReminderTestHelper.createReminder(date, patient, reminderType, "IN_PROGRESS", new Act[0]);
        Act reminder2 = ReminderTestHelper.createReminder(date, patient, reminderType, "CANCELLED", new Act[0]);
        Act reminder3 = ReminderTestHelper.createReminder(date, patient, reminderType, "COMPLETED", new Act[0]);
        this.checkExists(factory, DateRules.getTomorrow(), reminder1);
        this.checkNotExists(factory, DateRules.getTomorrow(), reminder2, reminder3);
        this.checkNotExists(factory, DateRules.getToday(), reminder1, reminder2, reminder3);
    }

    @Test
    public void testRemindersWithItems() {
        ReminderQueueQueryFactory factory = new ReminderQueueQueryFactory();
        Date date = DateRules.getToday();
        Entity reminderType = ReminderTestHelper.createReminderType(1, DateUnits.YEARS, new Lookup[0]);
        Party customer = TestHelper.createCustomer();
        Party patient = TestHelper.createPatient(customer);
        Act email1 = ReminderTestHelper.createEmailReminder(date, date, "PENDING", 0);
        Act sms1 = ReminderTestHelper.createEmailReminder(date, date, "PENDING", 0);
        Act reminder1 = ReminderTestHelper.createReminder(date, patient, reminderType, "IN_PROGRESS", email1, sms1);
        Act email2 = ReminderTestHelper.createSMSReminder(date, date, "ERROR", 0);
        Act sms2 = ReminderTestHelper.createSMSReminder(date, date, "ERROR", 0);
        Act reminder2 = ReminderTestHelper.createReminder(date, patient, reminderType, "IN_PROGRESS", email2, sms2);
        Act email3 = ReminderTestHelper.createPrintReminder(date, date, "COMPLETED", 0);
        Act print3 = ReminderTestHelper.createPrintReminder(date, date, "COMPLETED", 0);
        Act reminder3 = ReminderTestHelper.createReminder(date, patient, reminderType, "IN_PROGRESS", email3, print3);
        Act email4 = ReminderTestHelper.createExportReminder(date, date, "CANCELLED", 0);
        Act export4 = ReminderTestHelper.createExportReminder(date, date, "CANCELLED", 0);
        Act reminder4 = ReminderTestHelper.createReminder(date, patient, reminderType, "IN_PROGRESS", email4, export4);
        Act email5 = ReminderTestHelper.createExportReminder(date, date, "PENDING", 0);
        Act sms5 = ReminderTestHelper.createExportReminder(date, date, "COMPLETED", 0);
        Act reminder5 = ReminderTestHelper.createReminder(date, patient, reminderType, "IN_PROGRESS", email5, sms5);
        this.checkNotExists(factory, DateRules.getTomorrow(), reminder1, reminder2, reminder5);
        this.checkExists(factory, DateRules.getTomorrow(), reminder3, reminder4);
        this.checkNotExists(factory, DateRules.getToday(), reminder1, reminder2, reminder3, reminder4, reminder5);
    }

    private void checkExists(ReminderQueueQueryFactory factory, Date date, Act ... reminders) {
        int matches = this.getMatches(factory, date, reminders);
        Assert.assertEquals((long)reminders.length, (long)matches);
    }

    private void checkNotExists(ReminderQueueQueryFactory factory, Date date, Act ... reminders) {
        int matches = this.getMatches(factory, date, reminders);
        Assert.assertEquals((long)0L, (long)matches);
    }

    private int getMatches(ReminderQueueQueryFactory factory, Date date, Act[] reminders) {
        int matches = 0;
        IMObjectQueryIterator iterator = new IMObjectQueryIterator((IArchetypeQuery)factory.createQuery(date));
        HashSet<Act> set = new HashSet<Act>(Arrays.asList(reminders));
        while (iterator.hasNext()) {
            Act actual = (Act)iterator.next();
            if (!set.contains(actual)) continue;
            ++matches;
        }
        return matches;
    }
}

