/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.PatientRelationshipRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.EntityRelationship;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.springframework.beans.factory.annotation.Autowired;

public class PatientRelationshipRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private PatientRules rules;

    @Test
    public void testCheckRelationships() {
        Party patient = TestHelper.createPatient();
        Party owner1 = TestHelper.createCustomer();
        Party owner2 = TestHelper.createCustomer();
        Party owner3 = TestHelper.createCustomer();
        EntityRelationship r1 = this.rules.addPatientOwnerRelationship(owner1, patient);
        EntityRelationship r2 = this.rules.addPatientOwnerRelationship(owner2, patient);
        r1.setActiveEndTime(new Date(r2.getActiveStartTime().getTime() - 1000L));
        this.save((IMObject)patient);
        Assert.assertNotNull((Object)r1.getActiveEndTime());
        Assert.assertNull((Object)r2.getActiveEndTime());
        EntityRelationship r3 = this.rules.addPatientOwnerRelationship(owner3, patient);
        this.save((IMObject)patient);
        Assert.assertNotNull((Object)r2.getActiveEndTime());
        Assert.assertNull((Object)r3.getActiveEndTime());
    }

    @Test
    public void testCreatePatientRelationshipQuery() {
        Party customer = TestHelper.createCustomer();
        Party patient1 = TestHelper.createPatient(customer);
        Party patient2 = TestHelper.createPatient(customer);
        Party patient3 = TestHelper.createPatient(customer);
        IMObjectBean patientBean = this.getBean((IMObject)patient2);
        patientBean.setValue("deceased", (Object)true);
        patientBean.save();
        patient3.setActive(false);
        this.save((IMObject)patient3);
        IMObjectBean bean = this.getBean((IMObject)customer);
        EntityRelationship rel1 = (EntityRelationship)bean.getValue("patients", EntityRelationship.class, Predicates.targetEquals((IMObject)patient1));
        EntityRelationship rel2 = (EntityRelationship)bean.getValue("patients", EntityRelationship.class, Predicates.targetEquals((IMObject)patient2));
        EntityRelationship rel3 = (EntityRelationship)bean.getValue("patients", EntityRelationship.class, Predicates.targetEquals((IMObject)patient3));
        IArchetypeQuery query = PatientRelationshipRules.createPatientRelationshipQuery((Party)customer, (String[])new String[]{"entityRelationship.patientOwner"});
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(query);
        Assert.assertTrue((boolean)iterator.hasNext());
        this.checkObjectSet((ObjectSet)iterator.next(), rel1.getId(), patient1.getId(), patient1.getName(), patient1.getDescription(), true, false);
        this.checkObjectSet((ObjectSet)iterator.next(), rel2.getId(), patient2.getId(), patient2.getName(), patient2.getDescription(), true, true);
        this.checkObjectSet((ObjectSet)iterator.next(), rel3.getId(), patient3.getId(), patient3.getName(), patient3.getDescription(), false, false);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    private void checkObjectSet(ObjectSet set, long relationshipId, long patientId, String name, String description, boolean active, boolean deceased) {
        Assert.assertEquals((long)relationshipId, (long)set.getLong("relationship.id"));
        Assert.assertEquals((long)patientId, (long)set.getLong("patient.id"));
        Assert.assertEquals((Object)name, (Object)set.getString("patient.name"));
        Assert.assertEquals((Object)description, (Object)set.getString("patient.description"));
        Assert.assertEquals((Object)active, (Object)set.getBoolean("patient.active"));
        Assert.assertEquals((Object)deceased, (Object)set.getBoolean("patient.deceased"));
    }
}

