/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.patient;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.patient.MedicalRecordRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.customer.account.TestCustomerAccountFactory;
import org.openvpms.archetype.test.builder.customer.account.TestInvoiceItemBuilder;
import org.openvpms.archetype.test.builder.doc.TestDocumentFactory;
import org.openvpms.archetype.test.builder.patient.TestAttachmentBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientMedicationBuilder;
import org.openvpms.archetype.test.builder.patient.TestProblemBuilder;
import org.openvpms.archetype.test.builder.patient.TestVisitBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.springframework.beans.factory.annotation.Autowired;

public class MedicalRecordRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestCustomerAccountFactory accountFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestDocumentFactory documentFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;
    @Autowired
    private TestUserFactory userFactory;
    private Party patient;
    private User clinician;
    private Party location;
    private MedicalRecordRules rules;

    @Before
    public void setUp() {
        this.clinician = this.userFactory.createClinician();
        this.patient = this.patientFactory.createPatient();
        this.location = this.practiceFactory.createLocation();
        this.rules = new MedicalRecordRules(this.getArchetypeService());
    }

    @Test
    public void testDeleteClinicalProblem() {
        Act event = this.createEvent();
        Act problem = this.createProblem();
        Act note = this.createNote();
        this.patientFactory.updateVisit(event).addItems(problem, note).build();
        this.patientFactory.updateProblem(problem).addItem(note).build();
        Assert.assertNotNull((Object)this.get(event.getObjectReference()));
        Assert.assertNotNull((Object)this.get(problem.getObjectReference()));
        this.remove((IMObject)problem);
        Assert.assertNotNull((Object)this.get(event));
        Assert.assertNull((Object)this.get(problem));
        Assert.assertNotNull((Object)this.get(note));
    }

    @Test
    public void testGetEvent() {
        Act event1 = this.createEvent(TestHelper.getDate("2007-01-01"), null, "IN_PROGRESS");
        this.checkGetEvent(event1);
        Act event2 = this.createEvent(TestHelper.getDate("2007-01-02"), null, "COMPLETED");
        this.checkGetEvent(event2);
        Act event3 = this.createEvent(TestHelper.getDate("2008-01-01"), null, "IN_PROGRESS");
        this.checkGetEvent(event3);
        Act event4 = this.createEvent(TestHelper.getDate("2008-01-01"), null, "IN_PROGRESS");
        this.checkGetEvent(event4);
    }

    @Test
    public void testGetEventByDate() {
        Date jan1 = TestHelper.getDate("2007-01-01");
        Date jan2 = TestHelper.getDate("2007-01-02");
        Date jan3 = TestHelper.getDatetime("2007-01-03 10:43:55");
        this.checkGetEvent(jan2, null);
        Act event1 = this.createEvent(jan2);
        this.checkGetEvent(jan2, event1);
        this.checkGetEvent(jan1, null);
        this.checkGetEvent(jan3, event1);
        event1.setActivityEndTime(jan2);
        this.save((IMObject)event1);
        this.checkGetEvent(jan1, null);
        this.checkGetEvent(jan3, null);
        Act event2 = this.createEvent(jan3);
        this.checkGetEvent(jan3, event2);
        this.checkGetEvent(TestHelper.getDate("2007-01-03"), event2);
        this.checkGetEvent(jan2, event1);
        Act event2dup = this.createEvent(jan3);
        this.save((IMObject)event2dup);
        this.checkGetEvent(jan3, event2);
    }

    @Test
    public void testCreateNote() {
        Date startTime = TestHelper.getDate("2012-07-17");
        String text = "Test note";
        Act note = this.rules.createNote(startTime, this.patient, text, this.clinician);
        IMObjectBean bean = this.getBean((IMObject)note);
        Assert.assertEquals((Object)startTime, (Object)note.getActivityStartTime());
        Assert.assertEquals((Object)text, (Object)bean.getString("note"));
        Assert.assertEquals((Object)this.patient, (Object)bean.getTarget("patient"));
        Assert.assertEquals((Object)this.clinician, (Object)bean.getTarget("clinician"));
    }

    @Test
    public void testAddToEventForNonExistentEvent() {
        Date date = TestHelper.getDate("2007-04-05");
        Act medication = this.createMedication(this.patient);
        this.rules.addToEvent(medication, date, this.practiceFactory.createLocation());
        Act event = this.rules.getEvent(this.patient);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)event.getStatus());
        Assert.assertEquals((Object)date, (Object)event.getActivityStartTime());
        this.checkContains(event, medication);
    }

    @Test
    public void testAddToEventForExistingInProgressEvent() {
        Date date = TestHelper.getDate("2007-04-05");
        Act medication = (Act)((TestPatientMedicationBuilder)this.patientFactory.newMedication().patient(this.patient)).product(this.productFactory.createMedication()).build();
        Act expected = this.createEvent(date);
        this.save((IMObject)expected);
        this.rules.addToEvent(medication, date, this.location);
        Act event = this.rules.getEvent(this.patient);
        this.checkContains(event, medication);
        Assert.assertEquals((Object)expected, (Object)event);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)event.getStatus());
    }

    @Test
    public void testAddToEventForExistingOldInProgressEvent() {
        Date date = TestHelper.getDate("2007-04-05");
        Act medication = this.createMedication(this.patient);
        Date old = DateRules.getDate((Date)date, (int)-8, (DateUnits)DateUnits.DAYS);
        Act oldEvent = this.createEvent(old);
        this.save((IMObject)oldEvent);
        this.rules.addToEvent(medication, date, this.location);
        Act event = this.rules.getEvent(this.patient);
        this.checkContains(event, medication);
        Assert.assertNotEquals((Object)oldEvent, (Object)event);
        Assert.assertEquals((Object)date, (Object)event.getActivityStartTime());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)event.getStatus());
    }

    public void testAddToEventForExistingOldCompletedEvent() {
        Date date = TestHelper.getDate("2007-04-05");
        Act medication = this.createMedication(this.patient);
        Date old = DateRules.getDate((Date)date, (int)-8, (DateUnits)DateUnits.DAYS);
        Act oldEvent = this.createEvent(old);
        oldEvent.setStatus("COMPLETED");
        this.save((IMObject)oldEvent);
        this.rules.addToEvent(medication, date, this.location);
        Act event = this.rules.getEvent(this.patient);
        this.checkContains(event, medication);
        Assert.assertNotEquals((Object)oldEvent, (Object)event);
        Assert.assertEquals((Object)date, (Object)event.getActivityStartTime());
        Assert.assertEquals((Object)"COMPLETED", (Object)event.getStatus());
    }

    @Test
    public void testAddToEventForExistingCompletedEvent() {
        Date date = TestHelper.getDate("2007-04-05");
        Act medication = this.createMedication(this.patient);
        Act completed = this.createEvent(TestHelper.getDate("2007-04-03"), TestHelper.getDate("2007-04-06"), "COMPLETED");
        this.rules.addToEvent(medication, date, this.location);
        Act event = this.rules.getEvent(this.patient);
        this.checkContains(event, medication);
        Assert.assertEquals((Object)completed, (Object)event);
    }

    @Test
    public void testAddToEventForExistingNonOverlappingCompletedEvent() {
        Date date = TestHelper.getDate("2007-04-05");
        Act medication = this.patientFactory.createMedication(this.patient, this.productFactory.createMedication());
        Act completed = this.createEvent(TestHelper.getDate("2007-04-03"));
        completed.setActivityEndTime(TestHelper.getDate("2007-04-04"));
        completed.setStatus("COMPLETED");
        this.save((IMObject)completed);
        this.rules.addToEvent(medication, date, this.location);
        Act event = this.rules.getEvent(this.patient);
        this.checkContains(event, medication);
        Assert.assertNotEquals((Object)completed, (Object)event);
        Assert.assertEquals((Object)date, (Object)event.getActivityStartTime());
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)event.getStatus());
    }

    @Test
    public void testGetEventForAdditionForInProgressEventAtDifferentLocationCreatesNewEvent() {
        Date start1 = DateRules.getYesterday();
        Date end1 = DateRules.getDate((Date)start1, (int)1, (DateUnits)DateUnits.HOURS);
        Act event1 = this.createEvent(start1, end1, "IN_PROGRESS");
        Party location2 = this.practiceFactory.createLocation();
        Date start2 = DateRules.getToday();
        Act event2 = this.rules.getEventForAddition(this.patient, start2, null, location2);
        Assert.assertNotEquals((Object)event1, (Object)event2);
        this.checkEvent(event2, start2, null, "IN_PROGRESS", location2);
    }

    @Test
    public void testGetEventForAdditionForCompletedEventAtDifferentLocationCreatesNewEvent() {
        Date start1 = DateRules.getYesterday();
        Date end1 = DateRules.getDate((Date)start1, (int)1, (DateUnits)DateUnits.HOURS);
        Act event1 = this.createEvent(start1, end1, "COMPLETED");
        Party location2 = this.practiceFactory.createLocation();
        Date start2 = DateRules.getToday();
        Act event2 = this.rules.getEventForAddition(this.patient, start2, null, location2);
        Assert.assertNotEquals((Object)event1, (Object)event2);
        this.checkEvent(event2, start2, null, "IN_PROGRESS", location2);
    }

    @Test
    public void testGetEventForAdditionWhereExistingVisitHasNoLocation() {
        Date start1 = DateRules.getYesterday();
        Act event1 = (Act)((TestVisitBuilder)this.newEvent(start1, null).location(null)).build();
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)event1.getStatus());
        Party location2 = this.practiceFactory.createLocation();
        Date start2 = DateRules.getToday();
        Act event2 = this.rules.getEventForAddition(this.patient, start2, null, location2);
        Assert.assertEquals((Object)event1, (Object)event2);
        this.checkEvent(event2, start1, null, "IN_PROGRESS", null);
        Act event3 = this.rules.getEventForAddition(this.patient, start2, null, null);
        Assert.assertEquals((Object)event1, (Object)event3);
    }

    @Test
    public void testGetEventForAdditionForFutureDate() {
        Date tomorrow = DateRules.getTomorrow();
        Act event1 = this.rules.getEventForAddition(this.patient, tomorrow, (Entity)this.clinician, this.location);
        Assert.assertTrue((boolean)event1.isNew());
        Date now = new Date();
        Assert.assertTrue((event1.getActivityStartTime().compareTo(now) <= 0 ? 1 : 0) != 0);
        this.save((IMObject)event1);
        Act event2 = this.rules.getEventForAddition(this.patient, tomorrow, (Entity)this.clinician, this.location);
        Assert.assertEquals((Object)event1, (Object)event2);
    }

    @Test
    public void testLinkMedicalRecords() {
        Act event = this.createEvent();
        Act problem = this.createProblem();
        Act note = this.createNote();
        Act addendum = this.createAddendum();
        this.rules.linkMedicalRecords(event, problem, note, addendum);
        event = this.get(event);
        problem = this.get(problem);
        note = this.get(note);
        addendum = this.get(addendum);
        IMObjectBean eventBean = this.getBean((IMObject)event);
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)problem));
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)note));
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)addendum));
        IMObjectBean problemBean = this.getBean((IMObject)problem);
        Assert.assertTrue((boolean)problemBean.hasTarget("items", (IMObject)note));
        Assert.assertTrue((boolean)problemBean.hasTarget("items", (IMObject)addendum));
        this.rules.linkMedicalRecords(event, problem, note, addendum);
    }

    @Test
    public void testLinkMedicalRecordsWithItem() {
        Act event = this.createEvent();
        Act note = this.createNote();
        this.rules.linkMedicalRecords(event, note);
        event = this.get(event);
        note = this.get(note);
        IMObjectBean eventBean = this.getBean((IMObject)event);
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)note));
        Assert.assertEquals((long)1L, (long)event.getActRelationships().size());
        this.rules.linkMedicalRecords(event, note);
        Assert.assertEquals((long)1L, (long)event.getActRelationships().size());
    }

    @Test
    public void testLinkMedicalRecordsWithInvoiceItem() {
        Act event = this.createEvent();
        Act invoiceItem = (Act)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)((TestInvoiceItemBuilder)this.accountFactory.newInvoiceItem().patient(this.patient)).product(this.productFactory.createMedication())).quantity(1)).build();
        this.rules.linkMedicalRecords(event, invoiceItem);
        event = this.get(event);
        invoiceItem = this.get(invoiceItem);
        IMObjectBean eventBean = this.getBean((IMObject)event);
        Assert.assertTrue((boolean)eventBean.hasTarget("chargeItems", (IMObject)invoiceItem));
        Assert.assertEquals((long)1L, (long)event.getActRelationships().size());
        this.rules.linkMedicalRecords(event, invoiceItem);
        Assert.assertEquals((long)1L, (long)event.getActRelationships().size());
    }

    @Test
    public void testLinkMedicalRecordsWithProblem() {
        Act event = this.createEvent();
        Act problem = this.createProblem();
        Act note = this.createNote();
        IMObjectBean problemBean = this.getBean((IMObject)problem);
        problemBean.addTarget("items", (IMObject)note, "problem");
        this.save((IMObject[])new Act[]{problem, note});
        this.rules.linkMedicalRecords(event, problem);
        event = this.get(event);
        problem = this.get(problem);
        note = this.get(note);
        IMObjectBean eventBean = this.getBean((IMObject)event);
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)note));
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)problem));
        Assert.assertEquals((long)2L, (long)event.getActRelationships().size());
        Assert.assertEquals((long)2L, (long)problem.getActRelationships().size());
        this.rules.linkMedicalRecords(event, problem);
        Assert.assertEquals((long)2L, (long)event.getActRelationships().size());
        Assert.assertEquals((long)2L, (long)problem.getActRelationships().size());
    }

    @Test
    public void testLinkMedicalRecordsForMissingLinks() {
        Act event = this.createEvent();
        Act problem = this.createProblem();
        Act note1 = this.createNote();
        Act note2 = this.createNote();
        Act medication = this.patientFactory.createMedication(this.patient, this.productFactory.createMedication());
        IMObjectBean problemBean = this.getBean((IMObject)problem);
        problemBean.addTarget("items", (IMObject)note1, "problem");
        problemBean.addTarget("items", (IMObject)medication, "problem");
        this.save((IMObject[])new Act[]{problem, note1, medication});
        this.rules.linkMedicalRecords(event, problem, note2, null);
        event = this.get(event);
        problem = this.get(problem);
        note1 = this.get(note1);
        note2 = this.get(note2);
        medication = this.get(medication);
        IMObjectBean eventBean = this.getBean((IMObject)event);
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)problem));
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)note1));
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)note2));
        Assert.assertTrue((boolean)eventBean.hasTarget("items", (IMObject)medication));
        problemBean = this.getBean((IMObject)problem);
        Assert.assertTrue((boolean)problemBean.hasTarget("items", (IMObject)note1));
        Assert.assertTrue((boolean)problemBean.hasTarget("items", (IMObject)note2));
        Assert.assertTrue((boolean)problemBean.hasTarget("items", (IMObject)medication));
    }

    @Test
    public void testAddToEvents() {
        Date date = TestHelper.getDate("2007-04-05");
        Party patient2 = this.patientFactory.createPatient();
        Act med1 = this.patientFactory.createMedication(this.patient, this.productFactory.createMedication());
        Act med2 = this.patientFactory.createMedication(this.patient, this.productFactory.createMedication());
        Act med3 = this.patientFactory.createMedication(patient2, this.productFactory.createMedication());
        Act med4 = this.patientFactory.createMedication(patient2, this.productFactory.createMedication());
        List<Act> acts = Arrays.asList(med1, med2, med3, med4);
        Act event1 = this.createEvent(date);
        this.save((IMObject)event1);
        this.rules.addToEvents(acts, date, this.location);
        event1 = this.rules.getEvent(this.patient, date, this.location);
        this.checkContains(event1, med1, med2);
        Act event2 = this.rules.getEvent(patient2, date, this.location);
        Assert.assertNotNull((Object)event2);
        this.checkContains(event2, med3, med4);
    }

    @Test
    public void testAddToEventsForDifferentPatient() {
        Date date = TestHelper.getDate("2014-03-22");
        Party patient2 = this.patientFactory.createPatient();
        Party patient3 = this.patientFactory.createPatient();
        Act med1 = this.patientFactory.createMedication(this.patient, this.productFactory.createMedication());
        Act med2 = this.patientFactory.createMedication(this.patient, this.productFactory.createMedication());
        Act med3 = this.patientFactory.createMedication(patient2, this.productFactory.createMedication());
        Act med4 = this.patientFactory.createMedication(patient2, this.productFactory.createMedication());
        List<Act> acts = Arrays.asList(med1, med2, med3, med4);
        Act event1 = this.createEvent(date);
        this.save((IMObject)event1);
        this.rules.addToEvents(acts, date, this.location);
        event1 = this.rules.getEvent(this.patient, date, this.location);
        this.checkContains(event1, med1, med2);
        Act event2 = this.rules.getEvent(patient2, date, this.location);
        Assert.assertNotNull((Object)event2);
        this.checkContains(event2, med3, med4);
        this.setPatient(med2, patient3);
        this.setPatient(med4, patient3);
        this.rules.addToEvents(acts, date, this.location);
        event1 = this.rules.getEvent(this.patient, date, this.location);
        Assert.assertNotNull((Object)event1);
        this.checkContains(event1, med1);
        event2 = this.rules.getEvent(patient2, date, this.location);
        Assert.assertNotNull((Object)event2);
        this.checkContains(event2, med3);
        Act event3 = this.rules.getEvent(patient3, date, this.location);
        Assert.assertNotNull((Object)event3);
        this.checkContains(event3, med2, med4);
    }

    @Test
    public void testGetEventForAdditionForWithCompletedEventOnSameDay() {
        Act event1 = this.createEvent(TestHelper.getDatetime("2013-11-21 10:00:00"), TestHelper.getDatetime("2013-11-21 11:00:00"), "COMPLETED");
        Act event2 = this.createEvent(TestHelper.getDatetime("2013-11-21 12:00:05"), null, "IN_PROGRESS");
        this.checkGetEventForAddition(null, "2013-11-20 00:00:00", this.location);
        this.checkGetEventForAddition(event1, "2013-11-21 00:00:00", this.location);
        this.checkGetEventForAddition(event1, "2013-11-21 09:00:00", this.location);
        this.checkGetEventForAddition(event1, "2013-11-21 10:00:00", this.location);
        this.checkGetEventForAddition(event1, "2013-11-21 11:00:00", this.location);
        this.checkGetEventForAddition(event2, "2013-11-21 12:00:00", this.location);
        this.checkGetEventForAddition(event2, "2013-11-21 13:00:00", this.location);
        this.checkGetEventForAddition(event2, "2013-11-22 00:00:00", this.location);
        this.checkGetEventForAddition(event2, "2013-11-28 00:00:00", this.location);
        this.checkGetEventForAddition(null, "2013-11-29 00:00:00", this.location);
        Party customer = this.customerFactory.createCustomer();
        Entity cageType = this.schedulingFactory.createCageType();
        Entity schedule = (Entity)this.schedulingFactory.newSchedule().location(this.practiceFactory.createLocation()).cageType(cageType).build();
        ((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime("2013-11-21 11:50:00")).endTime("2013-11-30 17:00:00")).schedule(schedule).appointmentType(this.schedulingFactory.createAppointmentType()).customer(customer)).patient(this.patient)).event(event2).build();
        this.checkGetEventForAddition(event2, "2013-11-29 00:00:00", this.location);
    }

    @Test
    public void testGetEventWithCompletedEventWithNoEndDate() {
        Act event1 = this.createEvent(TestHelper.getDatetime("2013-11-15 10:00:00"), null, "COMPLETED");
        Act event2 = this.createEvent(TestHelper.getDatetime("2013-11-21 12:00:05"), null, "IN_PROGRESS");
        this.checkGetEventForAddition(null, "2013-11-14 00:00:00", this.location);
        this.checkGetEventForAddition(event1, "2013-11-15 00:00:00", this.location);
        this.checkGetEventForAddition(event1, "2013-11-15 23:59:59", this.location);
        this.checkGetEventForAddition(null, "2013-11-16 00:00:00", this.location);
        this.checkGetEventForAddition(null, "2013-11-20 23:59:59", this.location);
        this.checkGetEventForAddition(event2, "2013-11-21 00:00:00", this.location);
        this.checkGetEventForAddition(event2, "2013-11-21 12:00:00", this.location);
        this.checkGetEventForAddition(event2, "2013-11-21 12:00:05", this.location);
        this.checkGetEventForAddition(event2, "2013-11-22 00:00:00", this.location);
        this.checkGetEventForAddition(event2, "2013-11-28 00:00:00", this.location);
        this.checkGetEventForAddition(null, "2013-11-29 13:00:00", this.location);
        Party customer = this.customerFactory.createCustomer();
        Entity cageType = this.schedulingFactory.createCageType();
        Entity schedule = (Entity)this.schedulingFactory.newSchedule().location(this.practiceFactory.createLocation()).cageType(cageType).build();
        ((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime("2013-11-21 11:50:00")).endTime("2013-11-30 17:00:00")).schedule(schedule).appointmentType(this.schedulingFactory.createAppointmentType()).customer(customer)).patient(this.patient)).event(event2).build();
        this.checkGetEventForAddition(event2, "2013-11-29 13:00:00", this.location);
    }

    @Test
    public void testGetLockableRecords() {
        List<String> shortNames = Arrays.asList(this.rules.getLockableRecords());
        Assert.assertEquals((long)14L, (long)shortNames.size());
        Assert.assertTrue((boolean)shortNames.contains("act.patientClinicalAddendum"));
        Assert.assertTrue((boolean)shortNames.contains("act.patientClinicalNote"));
        Assert.assertTrue((boolean)shortNames.contains("act.patientDocumentAttachment"));
        Assert.assertTrue((boolean)shortNames.contains("act.patientDocumentAttachmentVersion"));
        Assert.assertTrue((boolean)shortNames.contains("act.patientDocumentForm"));
        Assert.assertTrue((boolean)shortNames.contains("act.patientDocumentImage"));
        Assert.assertTrue((boolean)shortNames.contains("act.patientDocumentImageVersion"));
        Assert.assertTrue((boolean)shortNames.contains("act.patientDocumentLetter"));
        Assert.assertTrue((boolean)shortNames.contains("act.patientDocumentLetterVersion"));
        Assert.assertTrue((boolean)shortNames.contains("act.patientInvestigation"));
        Assert.assertTrue((boolean)shortNames.contains("act.patientInvestigationVersion"));
        Assert.assertTrue((boolean)shortNames.contains("act.patientMedication"));
        Assert.assertTrue((boolean)shortNames.contains("act.patientWeight"));
        Assert.assertTrue((boolean)shortNames.contains("act.patientClinicalLink"));
    }

    @Test
    public void testLockableRecordStartTimeAndStatusNodes() {
        IArchetypeService service = this.getArchetypeService();
        for (String shortName : this.rules.getLockableRecords()) {
            NodeDescriptor startTime = DescriptorHelper.getNode((String)shortName, (String)"startTime", (ArchetypeService)service);
            Assert.assertNotNull((String)shortName, (Object)startTime);
            NodeDescriptor status = DescriptorHelper.getNode((String)shortName, (String)"status", (ArchetypeService)service);
            Assert.assertNotNull((String)shortName, (Object)status);
            if (!status.isHidden()) continue;
            Assert.assertTrue((String)shortName, (boolean)status.isReadOnly());
        }
    }

    @Test
    public void testGetAttachment() {
        Act event = this.createEvent();
        Assert.assertNull((Object)this.rules.getAttachment("notes.pdf", event));
        DocumentAct act1 = this.createAttachment("2017-04-22 10:00:00", "notes.pdf");
        DocumentAct act2 = this.createAttachment("2017-04-22 11:00:00", "billing.pdf");
        this.patientFactory.updateVisit(event).addItems(new Act[]{act1, act2}).build();
        Assert.assertEquals((Object)act1, (Object)this.rules.getAttachment("notes.pdf", event));
        Assert.assertEquals((Object)act2, (Object)this.rules.getAttachment("billing.pdf", event));
        DocumentAct act3 = this.createAttachment("2017-04-22 12:00:00", "notes.pdf");
        this.patientFactory.updateVisit(event).addItem((Act)act3).build();
        Assert.assertEquals((Object)act3, (Object)this.rules.getAttachment("notes.pdf", event));
    }

    @Test
    public void testGetAttachmentWithIdentity() {
        Act event = this.createEvent();
        IMObjectBean bean = this.getBean((IMObject)event);
        String archetype = "actIdentity.smartflowsheet";
        String identity1 = UUID.randomUUID().toString();
        String identity2 = UUID.randomUUID().toString();
        Assert.assertNull((Object)this.rules.getAttachment("anaesthetic.pdf", event, archetype, identity1));
        DocumentAct act1a = this.createAttachment("2017-04-22 10:00:00", "anaesthetic.pdf", identity1);
        DocumentAct act1b = this.createAttachment("2017-04-22 10:00:00", "anaesthetic records.pdf", identity1);
        DocumentAct act2 = this.createAttachment("2017-04-22 11:00:00", "anaesthetic.pdf", identity2);
        bean.addTarget("items", (IMObject)act1a, "event");
        bean.addTarget("items", (IMObject)act1b, "event");
        bean.addTarget("items", (IMObject)act2, "event");
        bean.save();
        Assert.assertEquals((Object)act1a, (Object)this.rules.getAttachment("anaesthetic.pdf", event, archetype, identity1));
        Assert.assertEquals((Object)act1b, (Object)this.rules.getAttachment("anaesthetic records.pdf", event, archetype, identity1));
        Assert.assertEquals((Object)act2, (Object)this.rules.getAttachment("anaesthetic.pdf", event, archetype, identity2));
    }

    protected Act createEvent() {
        return (Act)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().patient(this.patient)).clinician(this.clinician)).location(this.location)).build();
    }

    protected Act createEvent(Date startTime, Date endTime, String status) {
        return (Act)((TestVisitBuilder)this.newEvent(startTime, endTime).status(status)).build();
    }

    protected Act createEvent(Date startTime, Date endTime) {
        return (Act)this.newEvent(startTime, endTime).build();
    }

    protected Act createEvent(Date startTime) {
        return this.createEvent(startTime, null);
    }

    protected Act createProblem() {
        return (Act)((TestProblemBuilder)((TestProblemBuilder)((TestProblemBuilder)this.patientFactory.newProblem().reason("HEART_MURMUR")).patient(this.patient)).clinician(this.clinician)).build();
    }

    protected Act createMedication(Party patient) {
        return (Act)((TestPatientMedicationBuilder)this.patientFactory.newMedication().patient(patient)).product(this.productFactory.createMedication()).build();
    }

    protected Act createNote() {
        return this.patientFactory.createNote(this.patient, "a note");
    }

    protected Act createAddendum() {
        return this.patientFactory.createAddendum(this.patient, "an addendum");
    }

    private DocumentAct createAttachment(String datetime, String filename) {
        return (DocumentAct)((TestAttachmentBuilder)((TestAttachmentBuilder)((TestAttachmentBuilder)this.patientFactory.newAttachment().startTime(datetime)).patient(this.patient)).document(this.documentFactory.createPDF(filename))).build();
    }

    private DocumentAct createAttachment(String datetime, String filename, String identity) {
        return (DocumentAct)((TestAttachmentBuilder)((TestAttachmentBuilder)((TestAttachmentBuilder)((TestAttachmentBuilder)this.patientFactory.newAttachment().startTime(datetime)).patient(this.patient)).addIdentity("actIdentity.smartflowsheet", identity)).document(this.documentFactory.createPDF(filename))).build();
    }

    private TestVisitBuilder newEvent(Date startTime, Date endTime) {
        return (TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)((TestVisitBuilder)this.patientFactory.newVisit().startTime(startTime)).endTime(endTime)).patient(this.patient)).location(this.location)).clinician(this.clinician);
    }

    private void checkGetEvent(Act expected) {
        Act event = this.rules.getEvent(this.patient);
        if (expected == null) {
            Assert.assertNull((Object)event);
        } else {
            Assert.assertEquals((Object)expected, (Object)event);
        }
    }

    private void checkGetEvent(Date date, Act expected) {
        Act event = this.rules.getEvent(this.patient, date, this.location);
        if (expected == null) {
            Assert.assertNull((Object)event);
        } else {
            Assert.assertEquals((Object)expected, (Object)event);
        }
    }

    private void checkEvent(Act event, Date startTime, Date endTime, String status, Party location) {
        Assert.assertEquals((Object)startTime, (Object)event.getActivityStartTime());
        Assert.assertEquals((Object)endTime, (Object)event.getActivityEndTime());
        Assert.assertEquals((Object)status, (Object)event.getStatus());
        IMObjectBean bean = this.getBean((IMObject)event);
        Assert.assertEquals((Object)this.patient, (Object)bean.getTarget("patient"));
        Assert.assertEquals((Object)location, (Object)bean.getTarget("location"));
    }

    private void checkContains(Act event, Act ... acts) {
        List<Act> items = this.getActs(event);
        Assert.assertEquals((long)acts.length, (long)items.size());
        for (Act act : acts) {
            boolean found = false;
            for (Act item : items) {
                if (!item.equals(act)) continue;
                found = true;
                break;
            }
            Assert.assertTrue((boolean)found);
        }
    }

    private List<Act> getActs(Act event) {
        IMObjectBean bean = this.getBean((IMObject)event);
        return bean.getTargets("items", Act.class);
    }

    private void checkGetEventForAddition(Act expected, String date, Party location) {
        Date startTime = TestHelper.getDatetime(date);
        Act actual = this.rules.getEventForAddition(this.patient, startTime, null, location);
        if (expected != null) {
            Assert.assertEquals((Object)expected, (Object)actual);
        } else {
            Assert.assertTrue((boolean)actual.isNew());
            Assert.assertEquals((Object)startTime, (Object)actual.getActivityStartTime());
            Assert.assertEquals((Object)"IN_PROGRESS", (Object)actual.getStatus());
        }
    }

    private void setPatient(Act act, Party patient) {
        IMObjectBean itemBean = this.getBean((IMObject)act);
        itemBean.setTarget("patient", (IMObject)patient);
        itemBean.save();
    }
}

