/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.party;

import java.util.Collection;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.customer.TestCustomerBuilder;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.object.ValueStrategy;
import org.openvpms.archetype.test.builder.party.TestContactFactory;
import org.openvpms.archetype.test.builder.party.TestLocationContactBuilder;
import org.openvpms.archetype.test.builder.party.TestPhoneContactBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.springframework.beans.factory.annotation.Autowired;

public class PartyRulesTestCase
extends ArchetypeServiceTest {
    private PartyRules rules;
    @Autowired
    private TestContactFactory contactFactory;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;

    @Test
    public void testGetFullName() {
        Party customer1 = (Party)this.customerFactory.newCustomer().title("MR").firstName("Foo").lastName("Bar").build(false);
        Assert.assertEquals((Object)"Mr Foo Bar", (Object)this.rules.getFullName(customer1));
        Assert.assertEquals((Object)"Foo Bar", (Object)this.rules.getFullName(customer1, false));
        Assert.assertEquals((Object)"Mr Foo Bar", (Object)this.rules.getFullName(customer1, true));
        Party customer2 = (Party)this.customerFactory.newCustomer().title("MS").firstName(ValueStrategy.unset()).lastName("Jones").build(false);
        Assert.assertEquals((Object)"Ms Jones", (Object)this.rules.getFullName(customer2));
        Assert.assertEquals((Object)"Jones", (Object)this.rules.getFullName(customer2, false));
        Assert.assertEquals((Object)"Ms Jones", (Object)this.rules.getFullName(customer2, true));
        Party customer3 = (Party)this.customerFactory.newCustomer().title(null).firstName(ValueStrategy.unset()).lastName("Jones").build(false);
        Assert.assertEquals((Object)"Jones", (Object)this.rules.getFullName(customer3));
        Assert.assertEquals((Object)"Jones", (Object)this.rules.getFullName(customer3, false));
        Assert.assertEquals((Object)"Jones", (Object)this.rules.getFullName(customer3, true));
        Party vet = (Party)this.supplierFactory.newVet().title("DR").firstName("Jenny").lastName("Smith").build(false);
        Assert.assertEquals((Object)"Dr Jenny Smith", (Object)this.rules.getFullName(vet));
        Assert.assertEquals((Object)"Jenny Smith", (Object)this.rules.getFullName(vet, false));
        Assert.assertEquals((Object)"Dr Jenny Smith", (Object)this.rules.getFullName(vet, true));
        Party pet = (Party)((TestPatientBuilder)this.patientFactory.newPatient().name("T Rex")).build(false);
        pet.setName("T Rex");
        Assert.assertEquals((Object)"T Rex", (Object)this.rules.getFullName(pet));
        Assert.assertEquals((Object)"T Rex", (Object)this.rules.getFullName(pet, false));
        Assert.assertEquals((Object)"T Rex", (Object)this.rules.getFullName(pet, true));
    }

    @Test
    public void testDefaultContacts() {
        Set contacts = this.rules.getDefaultContacts();
        Assert.assertNotNull((Object)contacts);
        Assert.assertEquals((long)2L, (long)contacts.size());
        Assert.assertNotNull((Object)this.getContact(contacts, "contact.location"));
        Assert.assertNotNull((Object)this.getContact(contacts, "contact.phoneNumber"));
    }

    @Test
    public void testGetPreferredContacts() {
        Party party = (Party)this.customerFactory.newCustomer().firstName("ZFoo").lastName("ZBar").build(false);
        Assert.assertEquals((long)0L, (long)party.getContacts().size());
        for (Contact contact : this.rules.getDefaultContacts()) {
            party.addContact(contact);
        }
        Assert.assertEquals((long)2L, (long)party.getContacts().size());
        Contact location = this.getContact(party, "contact.location");
        Contact phone = this.getContact(party, "contact.phoneNumber");
        ((TestLocationContactBuilder)this.contactFactory.updateLocation(location).preferred(false)).build();
        ((TestPhoneContactBuilder)this.contactFactory.updatePhone(phone).preferred(false)).build();
        Assert.assertEquals((Object)"", (Object)this.rules.getPreferredContacts(party));
        ((TestLocationContactBuilder)((TestLocationContactBuilder)this.contactFactory.updateLocation(location).preferred()).address("1 Foo St").suburb("BAR", "Bar").state("VIC", "Vic").postcode("3071").purposes("HOME")).build();
        String address = "1 Foo St Bar 3071 (Home)";
        Assert.assertEquals((Object)address, (Object)this.rules.getPreferredContacts(party));
        ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.updatePhone(phone).preferred()).areaCode("03").phone("1234567").purposes("WORK")).build();
        String phoneNo = "(03) 1234567 (Work)";
        this.save((IMObject)party);
        String contacts = this.rules.getPreferredContacts(party);
        if (location.getId() < phone.getId()) {
            Assert.assertEquals((Object)(address + ", " + phoneNo), (Object)contacts);
        } else {
            Assert.assertEquals((Object)(phoneNo + ", " + address), (Object)contacts);
        }
    }

    @Test
    public void testGetContactPurposes() {
        Contact contact = this.contactFactory.newLocation().build();
        Assert.assertEquals((Object)"", (Object)this.rules.getContactPurposes(contact));
        ((TestLocationContactBuilder)this.contactFactory.updateLocation(contact).purposes("HOME")).build();
        Assert.assertEquals((Object)"(Home)", (Object)this.rules.getContactPurposes(contact));
        ((TestLocationContactBuilder)this.contactFactory.updateLocation(contact).purposes("WORK")).build();
        String purposes = this.rules.getContactPurposes(contact);
        Assert.assertEquals((Object)"(Home, Work)", (Object)purposes);
    }

    @Test
    public void testGetBillingAddress() {
        Party party = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().title("MR").name("Foo", "Bar").addContact(this.createLocation("1 Foo St", null))).build(false);
        Assert.assertEquals((Object)"1 Foo St, Coburg Victoria 3071", (Object)this.rules.getBillingAddress(party, true));
        Assert.assertEquals((Object)"1 Foo St\nCoburg Victoria 3071", (Object)this.rules.getBillingAddress(party, false));
        ((TestCustomerBuilder)this.customerFactory.updateCustomer(party).addContact(this.createLocation("3 Bar St", "BILLING"))).build();
        Assert.assertEquals((Object)"3 Bar St, Coburg Victoria 3071", (Object)this.rules.getBillingAddress(party, true));
        Assert.assertEquals((Object)"3 Bar St\nCoburg Victoria 3071", (Object)this.rules.getBillingAddress(party, false));
        Contact location = this.rules.getContact(party, "contact.location", "BILLING");
        Assert.assertNotNull((Object)location);
        IMObjectBean locationBean = this.getBean((IMObject)location);
        locationBean.setValue("state", (Object)"BAD_STATE");
        Assert.assertEquals((Object)"3 Bar St, 3071", (Object)this.rules.getBillingAddress(party, true));
        Assert.assertEquals((Object)"3 Bar St\n3071", (Object)this.rules.getBillingAddress(party, false));
        locationBean.setValue("state", (Object)"VIC");
        locationBean.setValue("suburb", (Object)"BAD_SUBURB");
        Assert.assertEquals((Object)"3 Bar St, Victoria 3071", (Object)this.rules.getBillingAddress(party, true));
        Assert.assertEquals((Object)"3 Bar St\nVictoria 3071", (Object)this.rules.getBillingAddress(party, false));
        party.getContacts().clear();
        Assert.assertEquals((Object)"", (Object)this.rules.getBillingAddress(party, true));
        Assert.assertEquals((Object)"", (Object)this.rules.getBillingAddress(party, false));
        Assert.assertEquals((Object)"", (Object)this.rules.getBillingAddress(null, true));
        Assert.assertEquals((Object)"", (Object)this.rules.getBillingAddress(null, false));
    }

    @Test
    public void testGetCorrespondenceAddress() {
        Contact[] contacts;
        Party party = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().title("MR").name("Foo", "Bar").addContact(this.createLocation("1 Foo St", null))).build(false);
        Assert.assertEquals((Object)"1 Foo St, Coburg Victoria 3071", (Object)this.rules.getCorrespondenceAddress(party, true));
        Assert.assertEquals((Object)"1 Foo St\nCoburg Victoria 3071", (Object)this.rules.getCorrespondenceAddress(party, false));
        party.addContact(this.createLocation("3 Bar St", "CORRESPONDENCE"));
        Assert.assertEquals((Object)"3 Bar St, Coburg Victoria 3071", (Object)this.rules.getCorrespondenceAddress(party, true));
        Assert.assertEquals((Object)"3 Bar St\nCoburg Victoria 3071", (Object)this.rules.getCorrespondenceAddress(party, false));
        for (Contact c : contacts = party.getContacts().toArray(new Contact[0])) {
            party.removeContact(c);
        }
        Assert.assertEquals((Object)"", (Object)this.rules.getCorrespondenceAddress(party, true));
        Assert.assertEquals((Object)"", (Object)this.rules.getCorrespondenceAddress(party, false));
    }

    @Test
    public void testGetTelephone() {
        Party party1 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addContact(this.createPhone("12345", false, null))).build(false);
        Assert.assertEquals((Object)"(03) 12345", (Object)this.rules.getTelephone(party1));
        party1.addContact(this.createPhone("56789", true, null));
        Assert.assertEquals((Object)"(03) 56789", (Object)this.rules.getTelephone(party1));
        Party party2 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().newPhone().areaCode("03").add()).build(false);
        Party party3 = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().newPhone().areaCode("").phone("  ").add()).build(false);
        Assert.assertEquals((Object)"(03) ", (Object)this.rules.getTelephone(party2));
        Assert.assertEquals((Object)"", (Object)this.rules.getTelephone(party3));
    }

    @Test
    public void testGetHomeTelephone() {
        Contact phone1 = this.createPhone("12345", false, null);
        Party party = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addContact(phone1)).build(false);
        Assert.assertEquals((Object)"(03) 12345", (Object)this.rules.getHomeTelephone(party));
        ((TestPhoneContactBuilder)this.contactFactory.updatePhone(phone1).purposes("HOME")).build();
        Assert.assertEquals((Object)"(03) 12345", (Object)this.rules.getHomeTelephone(party));
        Contact phone2 = this.createPhone("56789", true, null);
        party.addContact(phone2);
        Assert.assertEquals((Object)"(03) 12345", (Object)this.rules.getHomeTelephone(party));
        ((TestPhoneContactBuilder)this.contactFactory.updatePhone(phone2).purposes("HOME")).build();
        Assert.assertEquals((Object)"(03) 56789", (Object)this.rules.getHomeTelephone(party));
    }

    @Test
    public void testGetWorkTelephone() {
        Contact phone1 = this.createPhone("12345", false, null);
        Party party = (Party)((TestCustomerBuilder)this.customerFactory.newCustomer().addContact(phone1)).build(false);
        Assert.assertEquals((Object)"", (Object)this.rules.getWorkTelephone(party));
        ((TestPhoneContactBuilder)this.contactFactory.updatePhone(phone1).purposes("WORK")).build();
        Assert.assertEquals((Object)"(03) 12345", (Object)this.rules.getWorkTelephone(party));
        Contact phone2 = this.createPhone("56789", true, null);
        party.addContact(phone2);
        Assert.assertEquals((Object)"(03) 12345", (Object)this.rules.getWorkTelephone(party));
        ((TestPhoneContactBuilder)this.contactFactory.updatePhone(phone2).purposes("WORK")).build();
        Assert.assertEquals((Object)"(03) 56789", (Object)this.rules.getWorkTelephone(party));
    }

    @Test
    public void testGetSMSTelephone() {
        Party party = (Party)this.customerFactory.newCustomer().build(false);
        Assert.assertEquals((Object)"", (Object)this.rules.getSMSTelephone(party));
        Contact contact1 = ((TestPhoneContactBuilder)this.contactFactory.newPhone().phone("1234").preferred(false)).sms(false).build();
        party.addContact(contact1);
        Assert.assertEquals((Object)"", (Object)this.rules.getSMSTelephone(party));
        this.contactFactory.updatePhone(contact1).sms().build();
        Assert.assertEquals((Object)"1234", (Object)this.rules.getSMSTelephone(party));
        Contact contact2 = ((TestPhoneContactBuilder)this.contactFactory.newPhone().phone("5678").preferred()).sms(false).build();
        party.addContact(contact2);
        Assert.assertEquals((Object)"1234", (Object)this.rules.getSMSTelephone(party));
        this.contactFactory.updatePhone(contact2).sms().build();
        Assert.assertEquals((Object)"5678", (Object)this.rules.getSMSTelephone(party));
    }

    @Test
    public void testGetSMSContact() {
        Party party = (Party)this.customerFactory.newCustomer().build(false);
        Assert.assertNull((Object)this.rules.getSMSContact(party));
        Contact phone1 = ((TestPhoneContactBuilder)this.contactFactory.newPhone().sms(true).preferred()).build();
        Contact phone2 = ((TestPhoneContactBuilder)this.contactFactory.newPhone().sms(true).areaCode("03").preferred()).build();
        party.addContact(phone1);
        party.addContact(phone2);
        Assert.assertNull((Object)this.rules.getSMSContact(party));
        Contact phone3 = ((TestPhoneContactBuilder)this.contactFactory.newPhone().sms(true).areaCode("03").phone("1235678").preferred(false)).build();
        party.addContact(phone3);
        Assert.assertEquals((Object)phone3, (Object)this.rules.getSMSContact(party));
        Contact phone4 = ((TestPhoneContactBuilder)this.contactFactory.newPhone().sms(true).phone("1235678").preferred(true)).build();
        party.addContact(phone4);
        Assert.assertEquals((Object)phone4, (Object)this.rules.getSMSContact(party));
    }

    @Test
    public void testGetFaxNumber() {
        Party party = (Party)this.customerFactory.newCustomer().build(false);
        Assert.assertEquals((Object)"", (Object)this.rules.getFaxNumber(party));
        Contact fax1 = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().areaCode("03").phone("12345").preferred(false)).purposes("FAX")).build();
        party.addContact(fax1);
        Assert.assertEquals((Object)"(03) 12345", (Object)this.rules.getFaxNumber(party));
        party.removeContact(fax1);
        Contact fax2 = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().phone("12345").preferred(false)).purposes("FAX")).build();
        party.addContact(fax2);
        Assert.assertEquals((Object)"12345", (Object)this.rules.getFaxNumber(party));
    }

    @Test
    public void testGetIdentities() {
        Party pet = (Party)this.patientFactory.newPatient().addPetTag("1234567").build(false);
        String tagString = "Pet Tag: 1234567";
        Assert.assertEquals((Object)tagString, (Object)this.rules.getIdentities(pet));
        this.patientFactory.updatePatient(pet).addAlias("Foo").addAlias("Bar").build();
        String identities = this.rules.getIdentities(pet);
        Assert.assertEquals((Object)("Alias: Bar, Alias: Foo, " + tagString), (Object)identities);
    }

    @Test
    public void testGetContact() {
        Party party = (Party)this.customerFactory.newCustomer().name("Foo", "Bar").build();
        Contact phone1 = this.createPhone("12345", false, null);
        ((TestCustomerBuilder)this.customerFactory.updateCustomer(party).addContact(phone1)).build();
        Contact phone2 = this.createPhone("45678", false, "HOME");
        ((TestCustomerBuilder)this.customerFactory.updateCustomer(party).addContact(phone2)).build();
        Contact phone3 = this.createPhone("90123", false, "HOME");
        ((TestCustomerBuilder)this.customerFactory.updateCustomer(party).addContact(phone3)).build();
        Assert.assertEquals((Object)phone1, (Object)this.rules.getContact(party, "contact.phoneNumber", null));
        Assert.assertEquals((Object)phone2, (Object)this.rules.getContact(party, "contact.phoneNumber", "HOME"));
        ((TestPhoneContactBuilder)this.contactFactory.updatePhone(phone3).preferred()).build();
        Assert.assertEquals((Object)phone3, (Object)this.rules.getContact(party, "contact.phoneNumber", "HOME"));
        ((TestPhoneContactBuilder)this.contactFactory.updatePhone(phone2).preferred()).build();
        Assert.assertEquals((Object)phone2, (Object)this.rules.getContact(party, "contact.phoneNumber", "HOME"));
    }

    @Test
    public void getPhoneExcludesFaxContacts() {
        Party customer = (Party)this.customerFactory.newCustomer().name("Foo", "Bar").build(false);
        Contact fax = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().phone("7777 1234").preferred()).purposes("FAX")).build();
        ((TestCustomerBuilder)this.customerFactory.updateCustomer(customer).addContact(fax)).build();
        Contact phone = ((TestPhoneContactBuilder)this.contactFactory.newPhone().areaCode("03").phone("9999 6789").preferred(false)).build();
        ((TestCustomerBuilder)this.customerFactory.updateCustomer(customer).addContact(phone)).build();
        Assert.assertEquals((Object)"(03) 9999 6789", (Object)this.rules.getTelephone(customer));
        Assert.assertEquals((Object)"(03) 9999 6789", (Object)this.rules.getHomeTelephone(customer));
        Assert.assertEquals((Object)"", (Object)this.rules.getWorkTelephone(customer));
        Assert.assertEquals((Object)"", (Object)this.rules.getMobileTelephone(customer));
        Contact work = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().areaCode("03").phone("8888 1234").preferred(false)).purposes("WORK")).build();
        ((TestCustomerBuilder)this.customerFactory.updateCustomer(customer).addContact(work)).build();
        Assert.assertEquals((Object)"(03) 9999 6789", (Object)this.rules.getTelephone(customer));
        Assert.assertEquals((Object)"(03) 9999 6789", (Object)this.rules.getHomeTelephone(customer));
        Assert.assertEquals((Object)"(03) 8888 1234", (Object)this.rules.getWorkTelephone(customer));
        Assert.assertEquals((Object)"", (Object)this.rules.getMobileTelephone(customer));
        Contact mobile = ((TestPhoneContactBuilder)((TestPhoneContactBuilder)this.contactFactory.newPhone().areaCode("03").phone("6666 5432").preferred(false)).purposes("MOBILE")).build();
        ((TestCustomerBuilder)this.customerFactory.updateCustomer(customer).addContact(mobile)).build();
        Assert.assertEquals((Object)"(03) 9999 6789", (Object)this.rules.getTelephone(customer));
        Assert.assertEquals((Object)"(03) 9999 6789", (Object)this.rules.getHomeTelephone(customer));
        Assert.assertEquals((Object)"(03) 8888 1234", (Object)this.rules.getWorkTelephone(customer));
        Assert.assertEquals((Object)"(03) 6666 5432", (Object)this.rules.getMobileTelephone(customer));
        ((TestPhoneContactBuilder)this.contactFactory.updatePhone(work).purposes("FAX")).build();
        Assert.assertEquals((Object)"(03) 9999 6789", (Object)this.rules.getTelephone(customer));
        Assert.assertEquals((Object)"(03) 9999 6789", (Object)this.rules.getHomeTelephone(customer));
        Assert.assertEquals((Object)"", (Object)this.rules.getWorkTelephone(customer));
        Assert.assertEquals((Object)"(03) 6666 5432", (Object)this.rules.getMobileTelephone(customer));
    }

    @Test
    public void testGetPracticeAddress() {
        ((TestPracticeBuilder)this.practiceFactory.newPractice().addContact(this.createLocation("123 Foo St", null))).build();
        Assert.assertEquals((Object)"123 Foo St, Coburg Victoria 3071", (Object)this.rules.getPracticeAddress(true));
        Assert.assertEquals((Object)"123 Foo St\nCoburg Victoria 3071", (Object)this.rules.getPracticeAddress(false));
    }

    @Before
    public void setUp() {
        this.rules = new PartyRules(this.getArchetypeService(), this.getLookupService());
    }

    private Contact getContact(Party party, String shortName) {
        return this.getContact(party.getContacts(), shortName);
    }

    private Contact getContact(Collection<Contact> contacts, String shortName) {
        for (Contact contact : contacts) {
            if (!TypeHelper.isA((IMObject)contact, (String)shortName)) continue;
            return contact;
        }
        return null;
    }

    private Contact createLocation(String address, String purpose) {
        Contact contact = this.contactFactory.newLocation().build();
        this.populateLocation(contact, address, purpose);
        return contact;
    }

    private void populateLocation(Contact contact, String address, String purpose) {
        TestLocationContactBuilder<?, ?> builder = this.contactFactory.updateLocation(contact).address(address).state("VIC", "Victoria").suburb("COBURG", "Coburg").postcode("3071");
        if (purpose != null) {
            builder.purposes(purpose);
        }
        builder.build();
    }

    private Contact createPhone(String number, boolean preferred, String purpose) {
        return this.createPhone("03", number, preferred, purpose);
    }

    private Contact createPhone(String areaCode, String number, boolean preferred, String purpose) {
        Contact contact = this.contactFactory.newPhone().build();
        this.populatePhone(contact, areaCode, number, preferred, purpose);
        return contact;
    }

    private void populatePhone(Contact contact, String areaCode, String number, boolean preferred, String purpose) {
        TestPhoneContactBuilder<?, ?> builder = this.contactFactory.updatePhone(contact);
        builder.areaCode(areaCode).phone(number).preferred(preferred);
        if (purpose != null) {
            builder.purposes(purpose);
        }
        builder.build();
    }
}

