/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.party;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.openvpms.archetype.rules.finance.account.CustomerAccountQueryFactory;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.finance.statement.StatementService;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.party.AbstractPartyMergerTest;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.party.MergeException;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.util.DateUnits;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IMObjectQueryIterator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class CustomerMergerTestCase
extends AbstractPartyMergerTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private CustomerRules customerRules;
    @Autowired
    private PatientRules patientRules;
    @Autowired
    private CustomerAccountRules customerAccountRules;
    @Autowired
    private LaboratoryRules laboratoryRules;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;
    @Autowired
    private PlatformTransactionManager transactionManager;
    private TransactionTemplate template;
    private StatementService statementService;

    @Before
    public void setUp() {
        this.template = new TransactionTemplate(this.transactionManager);
        Party practice = this.create("party.organisationPractice", Party.class);
        PracticeService practiceService = (PracticeService)Mockito.mock(PracticeService.class);
        Mockito.when((Object)practiceService.getPractice()).thenReturn((Object)practice);
        this.statementService = new StatementService((IArchetypeRuleService)this.getArchetypeService(), this.customerAccountRules, this.laboratoryRules, practiceService);
    }

    @Test
    public void testMergeContacts() {
        Party from = this.customerFactory.createCustomer();
        Party to = this.customerFactory.createCustomer();
        int fromContactsSize = from.getContacts().size();
        int toContactsSize = to.getContacts().size();
        Party merged = this.checkMerge(from, to);
        Assert.assertEquals((long)(fromContactsSize + toContactsSize), (long)merged.getContacts().size());
    }

    @Test
    public void testMergeAccountType() {
        Party from = this.customerFactory.createCustomer();
        Party to = this.customerFactory.createCustomer();
        Lookup accountType = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).build();
        from.addClassification(accountType);
        Party merged = this.checkMerge(from, to);
        Assert.assertEquals((Object)accountType, (Object)this.customerRules.getAccountTypeLookup(merged));
    }

    @Test
    public void testMergeAccountTypes() {
        Party from = this.customerFactory.createCustomer();
        Party to = this.customerFactory.createCustomer();
        Lookup accountType1 = (Lookup)this.customerFactory.newAccountType().paymentTerms(30, DateUnits.DAYS).build();
        Lookup accountType2 = (Lookup)this.customerFactory.newAccountType().paymentTerms(15, DateUnits.DAYS).build();
        from.addClassification(accountType1);
        to.addClassification(accountType2);
        Lookup fromAccountType = this.customerRules.getAccountTypeLookup(from);
        Lookup toAccountType = this.customerRules.getAccountTypeLookup(to);
        Assert.assertEquals((Object)accountType1, (Object)fromAccountType);
        Assert.assertEquals((Object)accountType2, (Object)toAccountType);
        Party merged = this.checkMerge(from, to);
        Assert.assertEquals((Object)accountType2, (Object)this.customerRules.getAccountTypeLookup(merged));
    }

    @Test
    public void testMergeEntityRelationships() {
        Party from = this.customerFactory.createCustomer();
        Party to = this.customerFactory.createCustomer();
        Party patient1 = this.patientFactory.createPatient(from);
        Party patient2 = this.patientFactory.createPatient(to);
        Party merged = this.checkMerge(from, to);
        patient1 = this.get(patient1);
        patient2 = this.get(patient2);
        Assert.assertTrue((boolean)this.patientRules.isOwner(merged, patient1));
        Assert.assertTrue((boolean)this.patientRules.isOwner(merged, patient2));
    }

    @Test
    public void testMergeEntityIdentities() {
        Party from = (Party)this.customerFactory.newCustomer().addCodeIdentity("ABC1234").build();
        Party to = (Party)this.customerFactory.newCustomer().addCodeIdentity("XYZ1234").build();
        EntityIdentity id1 = from.getIdentities().stream().findFirst().orElse(null);
        Assert.assertNotNull((Object)id1);
        EntityIdentity id2 = to.getIdentities().stream().findFirst().orElse(null);
        Assert.assertNotNull((Object)id2);
        Party merged = this.checkMerge(from, to);
        Assert.assertEquals((long)2L, (long)merged.getIdentities().size());
        Assert.assertFalse((boolean)merged.getIdentities().contains(id1));
        Assert.assertTrue((boolean)merged.getIdentities().stream().anyMatch(identity -> identity.getIdentity().equals("ABC1234")));
        Assert.assertTrue((boolean)merged.getIdentities().contains(id2));
    }

    @Test
    public void testMergeParticipations() {
        Party from = this.customerFactory.createCustomer();
        Party to = this.customerFactory.createCustomer();
        Party patient = this.patientFactory.createPatient();
        Product product = this.productFactory.createMedication();
        Assert.assertEquals((long)0L, (long)this.countParticipations(from));
        Assert.assertEquals((long)0L, (long)this.countParticipations(to));
        for (int i = 0; i < 10; ++i) {
            List<FinancialAct> invoice = FinancialTestHelper.createChargesInvoice(MathRules.ONE_HUNDRED, from, patient, product, "POSTED");
            this.save(invoice);
        }
        int fromRefs = this.countParticipations(from);
        Assert.assertTrue((fromRefs >= 10 ? 1 : 0) != 0);
        this.checkMerge(from, to);
        Assert.assertEquals((long)0L, (long)this.countParticipations(from));
        int toRefs = this.countParticipations(to);
        Assert.assertEquals((long)toRefs, (long)fromRefs);
    }

    @Test
    public void testMergeInvalidParty() {
        Party from = this.customerFactory.createCustomer();
        Party to = this.supplierFactory.createSupplier();
        try {
            this.checkMerge(from, to);
            Assert.fail((String)"Expected merge to invalid party to fail");
        }
        catch (MergeException expected) {
            Assert.assertEquals((Object)MergeException.ErrorCode.InvalidType, (Object)expected.getErrorCode());
        }
    }

    @Test
    public void testMergeToSameCustomer() {
        Party from = this.customerFactory.createCustomer();
        try {
            this.checkMerge(from, from);
            Assert.fail((String)"Expected merge to same customer to fail");
        }
        catch (MergeException expected) {
            Assert.assertEquals((Object)MergeException.ErrorCode.CannotMergeToSameObject, (Object)expected.getErrorCode());
        }
    }

    @Test
    public void testMergeAccounts() {
        Money eighty = new Money(80);
        Money forty = new Money(40);
        Money fifty = new Money(50);
        Money ninety = new Money(90);
        Party from = this.customerFactory.createCustomer();
        Party fromPatient = this.patientFactory.createPatient();
        Party to = this.customerFactory.createCustomer();
        Party toPatient = this.patientFactory.createPatient();
        Product product = this.productFactory.createMedication();
        Date firstStartTime = TestHelper.getDatetime("2007-01-02 10:0:0");
        this.addInvoice(firstStartTime, (BigDecimal)eighty, from, fromPatient, product);
        this.addPayment(TestHelper.getDatetime("2007-01-02 11:0:0"), forty, from);
        this.runEOP(from, TestHelper.getDate("2007-02-01"));
        this.addInvoice(TestHelper.getDatetime("2007-01-01 10:0:0"), (BigDecimal)fifty, to, toPatient, product);
        this.runEOP(to, TestHelper.getDate("2007-01-01"));
        this.runEOP(to, TestHelper.getDate("2007-02-01"));
        Assert.assertEquals((long)0L, (long)forty.compareTo(this.customerAccountRules.getBalance(from)));
        Assert.assertEquals((long)0L, (long)fifty.compareTo(this.customerAccountRules.getBalance(to)));
        to = this.checkMerge(from, to);
        Assert.assertEquals((long)0L, (long)BigDecimal.ZERO.compareTo(this.customerAccountRules.getBalance(from)));
        Assert.assertEquals((long)0L, (long)ninety.compareTo(this.customerAccountRules.getBalance(to)));
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery((Party)to, (String[])new String[]{"act.customerAccountOpeningBalance", "act.customerAccountClosingBalance"});
        IMObjectQueryIterator iter = new IMObjectQueryIterator((IArchetypeQuery)query);
        int count = 0;
        while (iter.hasNext()) {
            Act act = (Act)iter.next();
            long startTime = act.getActivityStartTime().getTime();
            Assert.assertTrue((startTime < firstStartTime.getTime() ? 1 : 0) != 0);
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        Assert.assertEquals((long)0L, (long)this.countParticipations(from));
    }

    @Test
    public void testMergeLocationInFrom() {
        Party location = this.practiceFactory.createLocation();
        Party from = (Party)this.customerFactory.newCustomer().practice(location).build();
        Party to = this.customerFactory.createCustomer();
        Party merged = this.checkMerge(from, to);
        IMObjectBean bean = this.getBean((IMObject)merged);
        Assert.assertEquals((Object)location, (Object)bean.getTarget("practice"));
    }

    @Test
    public void testMergeLocationInTo() {
        Party location = this.practiceFactory.createLocation();
        Party from = this.customerFactory.createCustomer();
        Party to = (Party)this.customerFactory.newCustomer().practice(location).build();
        Party merged = this.checkMerge(from, to);
        IMObjectBean bean = this.getBean((IMObject)merged);
        Assert.assertEquals((Object)location, (Object)bean.getTarget("practice"));
    }

    @Test
    public void testMergeLocation() {
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party from = (Party)this.customerFactory.newCustomer().practice(location1).build();
        Party to = (Party)this.customerFactory.newCustomer().practice(location2).build();
        Party merged = this.checkMerge(from, to);
        IMObjectBean bean = this.getBean((IMObject)merged);
        Assert.assertEquals((Object)location2, (Object)bean.getTarget("practice"));
    }

    @Test
    public void testMergeSameLocation() {
        Party location1 = this.practiceFactory.createLocation();
        Party from = (Party)this.customerFactory.newCustomer().practice(location1).build();
        Party to = (Party)this.customerFactory.newCustomer().practice(location1).build();
        Party merged = this.checkMerge(from, to);
        IMObjectBean bean = this.getBean((IMObject)merged);
        Assert.assertEquals((Object)location1, (Object)bean.getTarget("practice"));
    }

    private void runEOP(Party customer, Date statementDate) {
        this.statementService.endPeriod(customer, statementDate, true);
    }

    private Party checkMerge(Party from, Party to) {
        this.template.execute(transactionStatus -> {
            this.customerRules.mergeCustomers(from, to);
            return null;
        });
        Assert.assertNull((Object)this.get(from));
        Party merged = this.get(to);
        Assert.assertNotNull((Object)merged);
        return merged;
    }

    private void addInvoice(Date startTime, BigDecimal amount, Party customer, Party patient, Product product) {
        List<FinancialAct> acts = FinancialTestHelper.createChargesInvoice(amount, customer, patient, product, "POSTED");
        FinancialAct act = acts.get(0);
        act.setActivityStartTime(startTime);
        this.save(acts);
    }

    private void addPayment(Date startTime, Money amount, Party customer) {
        FinancialAct act = FinancialTestHelper.createPaymentCash((BigDecimal)amount, customer, FinancialTestHelper.createTill());
        act.setActivityStartTime(startTime);
        this.save((IMObject)act);
    }
}

