/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.laboratory;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.laboratory.TestLaboratoryFactory;
import org.openvpms.archetype.test.builder.patient.TestInvestigationBuilder;
import org.openvpms.archetype.test.builder.patient.TestPatientFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.springframework.beans.factory.annotation.Autowired;

public class LaboratoryRulesTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestLaboratoryFactory laboratoryFactory;
    @Autowired
    private TestPatientFactory patientFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestUserFactory userFactory;
    private LaboratoryRules rules;

    @Before
    public void setUp() {
        this.rules = new LaboratoryRules(this.getArchetypeService());
    }

    @Test
    public void testGetLaboratory() {
        Party locationA = this.practiceFactory.createLocation();
        Party locationB = this.practiceFactory.createLocation();
        Party locationC = this.practiceFactory.createLocation();
        Entity laboratory1 = this.laboratoryFactory.createLaboratory(locationA);
        Entity investigationType1 = this.laboratoryFactory.createInvestigationType(laboratory1);
        Assert.assertEquals((Object)laboratory1, (Object)this.rules.getLaboratory(investigationType1, locationA));
        Assert.assertNull((Object)this.rules.getLaboratory(investigationType1, locationB));
        Entity laboratory2 = this.laboratoryFactory.createLaboratory(locationA, locationB);
        Entity investigationType2 = this.laboratoryFactory.createInvestigationType(laboratory2);
        Assert.assertEquals((Object)laboratory2, (Object)this.rules.getLaboratory(investigationType2, locationA));
        Assert.assertEquals((Object)laboratory2, (Object)this.rules.getLaboratory(investigationType2, locationB));
        Assert.assertNull((Object)this.rules.getLaboratory(investigationType2, locationC));
        Entity laboratory3 = this.laboratoryFactory.createLaboratory();
        Entity investigationType3 = this.laboratoryFactory.createInvestigationType(laboratory3);
        Assert.assertEquals((Object)laboratory3, (Object)this.rules.getLaboratory(investigationType3, locationA));
        Assert.assertEquals((Object)laboratory3, (Object)this.rules.getLaboratory(investigationType3, locationB));
        Assert.assertEquals((Object)laboratory3, (Object)this.rules.getLaboratory(investigationType3, locationC));
        Entity investigationType4 = this.laboratoryFactory.createInvestigationType();
        Assert.assertNull((Object)this.rules.getLaboratory(investigationType4, locationA));
    }

    @Test
    public void testGetLaboratoryForHL7() {
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = this.practiceFactory.createLocation();
        User user = this.userFactory.createUser();
        Entity laboratory1 = this.laboratoryFactory.createHL7Laboratory(location1, user);
        Entity laboratory2 = this.laboratoryFactory.createHL7Laboratory(location2, user);
        Entity group = this.laboratoryFactory.createHL7LaboratoryGroup(laboratory1, laboratory2);
        Entity investigationType1 = this.laboratoryFactory.createInvestigationType(laboratory1);
        Entity investigationType2 = this.laboratoryFactory.createInvestigationType(group);
        Assert.assertEquals((Object)laboratory1, (Object)this.rules.getLaboratory(investigationType1, location1));
        Assert.assertNull((Object)this.rules.getLaboratory(investigationType1, location2));
        Assert.assertEquals((Object)laboratory1, (Object)this.rules.getLaboratory(investigationType2, location1));
        Assert.assertEquals((Object)laboratory2, (Object)this.rules.getLaboratory(investigationType2, location2));
        Assert.assertNull((Object)this.rules.getLaboratory(investigationType2, location3));
    }

    @Test
    public void testCreateOrder() {
        Party patient = this.patientFactory.createPatient();
        Party location = this.practiceFactory.createLocation();
        Entity investigationType = this.laboratoryFactory.createInvestigationType();
        Entity laboratory = this.laboratoryFactory.createLaboratory(location);
        Entity device = this.laboratoryFactory.createDevice(laboratory);
        Entity test1 = this.laboratoryFactory.createTest(investigationType);
        Entity test2 = this.laboratoryFactory.createTest(investigationType);
        User clinician = this.userFactory.createClinician();
        Act investigation = (Act)((TestInvestigationBuilder)((TestInvestigationBuilder)((TestInvestigationBuilder)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).location(location)).investigationType(investigationType).laboratory(laboratory).device(device).addTests(test1, test2).clinician(clinician)).description("some notes")).build();
        Act order = this.rules.createOrder(investigation);
        Assert.assertNotNull((Object)order);
        Assert.assertTrue((boolean)order.isNew());
        this.save((IMObject)order);
        investigation = this.get(investigation);
        order = this.get(order);
        IMObjectBean bean = this.getBean((IMObject)order);
        Assert.assertEquals((Object)investigation.getActivityStartTime(), (Object)order.getActivityStartTime());
        Assert.assertEquals((Object)"PENDING", (Object)order.getStatus());
        Assert.assertEquals((Object)"PENDING", (Object)order.getStatus2());
        ActIdentity investigationId = (ActIdentity)bean.getObject("investigationId", ActIdentity.class);
        Assert.assertNotNull((Object)investigationId);
        Assert.assertEquals((Object)Long.toString(investigation.getId()), (Object)investigationId.getIdentity());
        Assert.assertEquals((Object)"some notes", (Object)order.getDescription());
        Assert.assertEquals((Object)"NEW", (Object)bean.getString("type"));
        Assert.assertEquals((Object)patient, (Object)bean.getTarget("patient"));
        Assert.assertEquals((Object)laboratory, (Object)bean.getTarget("laboratory"));
        Assert.assertEquals((Object)investigationType, (Object)bean.getTarget("investigationType"));
        Assert.assertEquals((Object)device, (Object)bean.getTarget("device"));
        Assert.assertEquals((Object)location, (Object)bean.getTarget("location"));
        List tests = bean.getTargets("tests", Entity.class);
        Assert.assertEquals((long)2L, (long)tests.size());
        Assert.assertTrue((boolean)tests.contains(test1));
        Assert.assertTrue((boolean)tests.contains(test2));
        Assert.assertEquals((Object)clinician, (Object)bean.getTarget("clinician"));
        Assert.assertEquals((Object)investigation, (Object)bean.getSource("investigation"));
    }

    @Test
    public void testIsUnsubmittedInvestigation() {
        Act investigation;
        Party patient = this.patientFactory.createPatient();
        Party location = this.practiceFactory.createLocation();
        Entity investigationType = this.laboratoryFactory.createInvestigationType();
        Entity laboratory = this.laboratoryFactory.createLaboratory(location);
        String[] unsubmitted = new String[]{"PENDING", "CONFIRM", "CONFIRM_DEFERRED"};
        String[] submitted = new String[]{"SENT", "ERROR", "RECEIVED", "WAITING_FOR_SAMPLE", "PARTIAL_RESULTS", "RECEIVED", "REVIEWED"};
        Act pendingInvestigation = (Act)((TestInvestigationBuilder)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).investigationType(investigationType).laboratory(laboratory).location(location)).build();
        Assert.assertTrue((boolean)this.rules.isUnsubmittedInvestigation(pendingInvestigation));
        for (String status2 : unsubmitted) {
            investigation = (Act)((TestInvestigationBuilder)((TestInvestigationBuilder)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).investigationType(investigationType).laboratory(laboratory).location(location)).status2(status2)).build();
            Assert.assertTrue((boolean)this.rules.isUnsubmittedInvestigation(investigation));
        }
        for (String status2 : submitted) {
            investigation = (Act)((TestInvestigationBuilder)((TestInvestigationBuilder)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).investigationType(investigationType).laboratory(laboratory).location(location)).status2(status2)).build();
            Assert.assertFalse((boolean)this.rules.isUnsubmittedInvestigation(investigation));
        }
        Act noLabInvestigation = (Act)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).investigationType(investigationType).build();
        Assert.assertFalse((boolean)this.rules.isUnsubmittedInvestigation(noLabInvestigation));
        Act hl7investigation = (Act)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).investigationType(investigationType).laboratory(this.laboratoryFactory.createHL7Laboratory(location, this.userFactory.createUser())).build();
        Assert.assertFalse((boolean)this.rules.isUnsubmittedInvestigation(hl7investigation));
        Act cancelledInvestigation = (Act)((TestInvestigationBuilder)((TestInvestigationBuilder)((TestInvestigationBuilder)((TestInvestigationBuilder)this.patientFactory.newInvestigation().patient(patient)).investigationType(investigationType).laboratory(laboratory).location(location)).status("CANCELLED")).status2("PENDING")).build();
        Assert.assertFalse((boolean)this.rules.isUnsubmittedInvestigation(cancelledInvestigation));
    }

    @Test
    public void testCanUseLaboratoryAtLocation() {
        Party locationA = this.practiceFactory.createLocation();
        Party locationB = this.practiceFactory.createLocation();
        Party locationC = this.practiceFactory.createLocation();
        Entity laboratory1 = this.laboratoryFactory.createLaboratory(locationA);
        Assert.assertTrue((boolean)this.rules.canUseLaboratoryAtLocation(laboratory1, locationA));
        Assert.assertFalse((boolean)this.rules.canUseLaboratoryAtLocation(laboratory1, locationB));
        Entity laboratory2 = this.laboratoryFactory.createLaboratory(locationA, locationB);
        Assert.assertTrue((boolean)this.rules.canUseLaboratoryAtLocation(laboratory2, locationA));
        Assert.assertTrue((boolean)this.rules.canUseLaboratoryAtLocation(laboratory2, locationB));
        Assert.assertFalse((boolean)this.rules.canUseLaboratoryAtLocation(laboratory2, locationC));
        Entity laboratory3 = this.laboratoryFactory.createLaboratory();
        Assert.assertTrue((boolean)this.rules.canUseLaboratoryAtLocation(laboratory3, locationA));
        Assert.assertTrue((boolean)this.rules.canUseLaboratoryAtLocation(laboratory3, locationB));
    }

    @Test
    public void testUseLaboratoryAtLocationForHL7() {
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = this.practiceFactory.createLocation();
        User user = this.userFactory.createUser();
        Entity laboratory1 = this.laboratoryFactory.createHL7Laboratory(location1, user);
        Entity laboratory2 = this.laboratoryFactory.createHL7Laboratory(location2, user);
        Entity group = this.laboratoryFactory.createHL7LaboratoryGroup(laboratory1, laboratory2);
        Assert.assertTrue((boolean)this.rules.canUseLaboratoryAtLocation(laboratory1, location1));
        Assert.assertFalse((boolean)this.rules.canUseLaboratoryAtLocation(laboratory1, location2));
        Assert.assertTrue((boolean)this.rules.canUseLaboratoryAtLocation(group, location1));
        Assert.assertTrue((boolean)this.rules.canUseLaboratoryAtLocation(group, location2));
        Assert.assertFalse((boolean)this.rules.canUseLaboratoryAtLocation(group, location3));
    }

    @Test
    public void testCanUseDeviceAtLocation() {
        Party location1 = this.practiceFactory.createLocation();
        Party location2 = this.practiceFactory.createLocation();
        Party location3 = this.practiceFactory.createLocation();
        Entity laboratory = this.laboratoryFactory.createLaboratory();
        Entity device1 = this.laboratoryFactory.createDevice(laboratory, location1);
        Assert.assertTrue((boolean)this.rules.canUseDeviceAtLocation(device1, location1));
        Assert.assertFalse((boolean)this.rules.canUseDeviceAtLocation(device1, location2));
        Entity device2 = this.laboratoryFactory.createDevice(laboratory, location1, location2);
        Assert.assertTrue((boolean)this.rules.canUseDeviceAtLocation(device2, location1));
        Assert.assertTrue((boolean)this.rules.canUseDeviceAtLocation(device2, location2));
        Assert.assertFalse((boolean)this.rules.canUseDeviceAtLocation(device1, location3));
        Entity device3 = this.laboratoryFactory.createDevice(laboratory);
        Assert.assertTrue((boolean)this.rules.canUseDeviceAtLocation(device3, location1));
        Assert.assertTrue((boolean)this.rules.canUseDeviceAtLocation(device3, location3));
    }
}

