/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.till;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.finance.deposit.DepositHelper;
import org.openvpms.archetype.rules.finance.deposit.DepositTestHelper;
import org.openvpms.archetype.rules.finance.till.AbstractTillRulesTest;
import org.openvpms.archetype.rules.finance.till.TillHelper;
import org.openvpms.archetype.rules.finance.till.TillRuleException;
import org.openvpms.archetype.rules.finance.till.TillRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;

public class TillRulesTestCase
extends AbstractTillRulesTest {
    private Entity till;
    private TillRules rules;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;

    @Before
    public void setUp() {
        this.till = this.practiceFactory.createTill();
        this.rules = new TillRules((IArchetypeRuleService)this.getArchetypeService(), this.transactionManager);
    }

    @Test
    public void testNeedsDrawerOpen() {
        this.practiceFactory.updateTill(this.till).printer("foo").drawerCommand("27,112,0,50,250").build();
        Party customer = this.customerFactory.createCustomer();
        FinancialAct payment1 = this.createPayment(this.till, customer, "act.customerAccountPaymentCash", "IN_PROGRESS");
        Assert.assertFalse((boolean)this.rules.needsDrawerOpen((Act)payment1));
        payment1.setStatus("POSTED");
        Assert.assertTrue((boolean)this.rules.needsDrawerOpen((Act)payment1));
        FinancialAct payment2 = this.createPayment(this.till, customer, "act.customerAccountPaymentCheque", "POSTED");
        Assert.assertTrue((boolean)this.rules.needsDrawerOpen((Act)payment2));
        FinancialAct payment3 = this.createPaymentEFT(this.till, customer, "POSTED", BigDecimal.ZERO);
        Assert.assertFalse((boolean)this.rules.needsDrawerOpen((Act)payment3));
        FinancialAct payment4 = this.createPaymentEFT(this.till, customer, "POSTED", BigDecimal.TEN);
        Assert.assertTrue((boolean)this.rules.needsDrawerOpen((Act)payment4));
        FinancialAct payment5 = this.createPayment(this.till, customer, "act.customerAccountPaymentCredit", "POSTED");
        Assert.assertTrue((boolean)this.rules.needsDrawerOpen((Act)payment5));
        FinancialAct payment6 = this.createPayment(this.till, customer, "act.customerAccountPaymentDiscount", "POSTED");
        Assert.assertFalse((boolean)this.rules.needsDrawerOpen((Act)payment6));
        FinancialAct payment7 = this.createPayment(this.till, customer, "act.customerAccountPaymentOther", "POSTED");
        Assert.assertFalse((boolean)this.rules.needsDrawerOpen((Act)payment7));
        FinancialAct refund1 = this.createRefund(this.till, customer, "act.customerAccountRefundCash", "IN_PROGRESS");
        Assert.assertFalse((boolean)this.rules.needsDrawerOpen((Act)refund1));
        refund1.setStatus("POSTED");
        Assert.assertTrue((boolean)this.rules.needsDrawerOpen((Act)refund1));
        FinancialAct refund2 = this.createRefund(this.till, customer, "act.customerAccountRefundCheque", "POSTED");
        Assert.assertTrue((boolean)this.rules.needsDrawerOpen((Act)refund2));
        FinancialAct refund3 = this.createRefund(this.till, customer, "act.customerAccountRefundEFT", "POSTED");
        Assert.assertFalse((boolean)this.rules.needsDrawerOpen((Act)refund3));
        FinancialAct refund5 = this.createRefund(this.till, customer, "act.customerAccountRefundCredit", "POSTED");
        Assert.assertTrue((boolean)this.rules.needsDrawerOpen((Act)refund5));
        FinancialAct refund6 = this.createRefund(this.till, customer, "act.customerAccountRefundDiscount", "POSTED");
        Assert.assertFalse((boolean)this.rules.needsDrawerOpen((Act)refund6));
        FinancialAct refund7 = this.createRefund(this.till, customer, "act.customerAccountRefundOther", "POSTED");
        Assert.assertFalse((boolean)this.rules.needsDrawerOpen((Act)refund7));
    }

    @Test
    public void testClearTillWithNoAdjustment() {
        BigDecimal cashFloat = BigDecimal.ZERO;
        this.checkClearTillForUnclearedBalance(cashFloat, cashFloat);
    }

    @Test
    public void testClearTillWithCreditAdjustment() {
        BigDecimal cashFloat = new BigDecimal(40);
        BigDecimal newCashFloat = new BigDecimal(20);
        this.checkClearTillForUnclearedBalance(cashFloat, newCashFloat);
    }

    @Test
    public void testClearTillWithDebitAdjustment() {
        BigDecimal cashFloat = new BigDecimal(40);
        BigDecimal newCashFloat = new BigDecimal(100);
        this.checkClearTillForUnclearedBalance(cashFloat, newCashFloat);
    }

    @Test
    public void testClearTillAndReSave() {
        List<FinancialAct> payment = this.createPayment(this.till);
        payment.get(0).setStatus("POSTED");
        FinancialAct balance = this.checkAddToTillBalance(this.till, payment, false, BigDecimal.ONE);
        Party account = DepositTestHelper.createDepositAccount();
        this.rules.clearTill(balance, BigDecimal.ZERO, account);
        Act latest = (Act)this.get((IMObject)payment.get(0));
        this.save((IMObject)latest);
        latest = this.get(latest);
        IMObjectBean bean = this.getBean((IMObject)latest);
        List relationships = bean.getValues("items", ActRelationship.class);
        Assert.assertEquals((long)1L, (long)relationships.size());
    }

    @Test
    public void testTransfer() {
        List<FinancialAct> payment = this.createPayment(this.till);
        payment.get(0).setStatus("POSTED");
        FinancialAct balance = this.checkAddToTillBalance(this.till, payment, false, BigDecimal.ONE);
        Act act = (Act)this.get((IMObject)payment.get(0));
        Entity newTill = this.practiceFactory.createTill();
        this.rules.transfer((Act)balance, act, newTill);
        balance = (FinancialAct)this.get(balance.getObjectReference());
        Assert.assertEquals((long)0L, (long)this.countRelationships((Act)balance, (Act)payment.get(0)));
        this.checkEquals(BigDecimal.ZERO, balance.getTotal());
        FinancialAct newBalance = TillHelper.getUnclearedTillBalance((Entity)newTill, (IArchetypeService)this.getArchetypeService());
        Assert.assertNotNull((Object)newBalance);
        Assert.assertEquals((long)1L, (long)this.countRelationships((Act)newBalance, (Act)payment.get(0)));
        Assert.assertEquals((Object)"UNCLEARED", (Object)newBalance.getStatus());
        this.checkEquals(BigDecimal.ONE, newBalance.getTotal());
    }

    @Test
    public void testTransferWithInvalidBalance() {
        FinancialAct act = this.create("act.bankDeposit", FinancialAct.class);
        List<FinancialAct> payment = this.createPayment(this.till);
        this.save(payment);
        try {
            this.rules.transfer((Act)act, (Act)payment.get(0), this.till);
        }
        catch (TillRuleException expected) {
            Assert.assertEquals((Object)TillRuleException.ErrorCode.InvalidTillArchetype, (Object)expected.getErrorCode());
        }
    }

    @Test
    public void testTransferWithInvalidAct() {
        FinancialAct act = TillHelper.createTillBalance((Entity)this.till, (IArchetypeService)this.getArchetypeService());
        FinancialAct payment = this.create("act.bankDeposit", FinancialAct.class);
        try {
            this.rules.transfer((Act)act, (Act)payment, this.till);
        }
        catch (TillRuleException expected) {
            Assert.assertEquals((Object)TillRuleException.ErrorCode.CantAddActToTill, (Object)expected.getErrorCode());
        }
    }

    @Test
    public void testTransferWithClearedBalance() {
        FinancialAct act = TillHelper.createTillBalance((Entity)this.till, (IArchetypeService)this.getArchetypeService());
        act.setStatus("CLEARED");
        List<FinancialAct> payment = this.createPayment(this.till);
        payment.get(0).setStatus("POSTED");
        this.getArchetypeService().save(payment);
        try {
            this.rules.transfer((Act)act, (Act)payment.get(0), this.practiceFactory.createTill());
        }
        catch (TillRuleException expected) {
            Assert.assertEquals((Object)TillRuleException.ErrorCode.ClearedTill, (Object)expected.getErrorCode());
        }
    }

    @Test
    public void testTransferWithNoRelationship() {
        FinancialAct act = TillHelper.createTillBalance((Entity)this.till, (IArchetypeService)this.getArchetypeService());
        List<FinancialAct> payment = this.createPayment(this.till);
        payment.get(0).setStatus("POSTED");
        this.getArchetypeService().save(payment);
        try {
            this.rules.transfer((Act)act, (Act)payment.get(0), this.practiceFactory.createTill());
        }
        catch (TillRuleException expected) {
            Assert.assertEquals((Object)TillRuleException.ErrorCode.MissingRelationship, (Object)expected.getErrorCode());
        }
    }

    @Test
    public void testTransferWithNoParticipation() {
        FinancialAct balance = TillHelper.createTillBalance((Entity)this.till, (IArchetypeService)this.getArchetypeService());
        Party party = this.customerFactory.createCustomer();
        FinancialAct payment = this.create("act.customerAccountPayment", FinancialAct.class);
        payment.setStatus("POSTED");
        IMObjectBean bean = this.getBean((IMObject)payment);
        bean.setTarget("customer", (IMObject)party);
        IMObjectBean balanceBean = this.getBean((IMObject)balance);
        balanceBean.addTarget("items", (IMObject)payment, "tillBalance");
        try {
            this.rules.transfer((Act)balance, (Act)payment, this.practiceFactory.createTill());
        }
        catch (TillRuleException expected) {
            Assert.assertEquals((Object)TillRuleException.ErrorCode.MissingTill, (Object)expected.getErrorCode());
        }
    }

    @Test
    public void testTransferToSameTill() {
        List<FinancialAct> payment = this.createPayment(this.till);
        payment.get(0).setStatus("POSTED");
        FinancialAct balance = this.checkAddToTillBalance(this.till, payment, false, BigDecimal.ONE);
        try {
            this.rules.transfer((Act)balance, (Act)payment.get(0), this.till);
        }
        catch (TillRuleException expected) {
            Assert.assertEquals((Object)TillRuleException.ErrorCode.InvalidTransferTill, (Object)expected.getErrorCode());
        }
    }

    @Test
    public void testIsClearInProgress() {
        Assert.assertFalse((boolean)this.rules.isClearInProgress(this.till));
        FinancialAct balance = this.createBalance(this.till, "UNCLEARED");
        this.save((IMObject)balance);
        Assert.assertFalse((boolean)this.rules.isClearInProgress(this.till));
        balance.setStatus("IN_PROGRESS");
        this.save((IMObject)balance);
        Assert.assertTrue((boolean)this.rules.isClearInProgress(this.till));
        balance.setStatus("CLEARED");
        this.save((IMObject)balance);
        Assert.assertFalse((boolean)this.rules.isClearInProgress(this.till));
    }

    @Test
    public void testStartClearTill() {
        FinancialAct balance1 = this.createBalance(this.till, "UNCLEARED");
        this.rules.startClearTill(balance1, BigDecimal.ZERO);
        balance1 = this.get(balance1);
        Assert.assertEquals((Object)"IN_PROGRESS", (Object)balance1.getStatus());
        List<FinancialAct> payment = this.createPayment(this.till);
        payment.get(0).setStatus("POSTED");
        this.save(payment);
        FinancialAct balance2 = TillHelper.getUnclearedTillBalance((Entity)this.till, (IArchetypeService)this.getArchetypeService());
        Assert.assertNotNull((Object)balance2);
        Assert.assertNotEquals((long)balance1.getId(), (long)balance2.getId());
        IMObjectBean bean = this.getBean((IMObject)balance2);
        Assert.assertTrue((boolean)bean.hasTarget("items", (IMObject)payment.get(0)));
    }

    @Test
    public void testStartClearTillWithNoAdjustment() {
        BigDecimal cashFloat = BigDecimal.ZERO;
        this.checkStartClearTill(cashFloat, cashFloat);
    }

    @Test
    public void testStartClearTillWithCreditAdjustment() {
        BigDecimal cashFloat = new BigDecimal(40);
        BigDecimal newCashFloat = new BigDecimal(20);
        this.checkStartClearTill(cashFloat, newCashFloat);
    }

    @Test
    public void testStartClearTillWithDebitAdjustment() {
        BigDecimal cashFloat = new BigDecimal(40);
        BigDecimal newCashFloat = new BigDecimal(100);
        this.checkStartClearTill(cashFloat, newCashFloat);
    }

    private void checkClearTillForUnclearedBalance(BigDecimal initialCashFloat, BigDecimal newCashFloat) {
        this.setTillCashFloat(initialCashFloat);
        Party account = DepositTestHelper.createDepositAccount();
        FinancialAct balance = this.createBalance(this.till, "UNCLEARED");
        this.save((IMObject)balance);
        Assert.assertNull((Object)balance.getActivityEndTime());
        FinancialAct deposit = DepositHelper.getUndepositedDeposit((Entity)account, (IArchetypeService)this.getArchetypeService());
        Assert.assertNull((Object)deposit);
        this.rules.clearTill(balance, newCashFloat, account);
        BigDecimal expectedBalance = this.checkBalance(initialCashFloat, newCashFloat, balance, "CLEARED");
        this.checkDeposit(account, balance, expectedBalance);
    }

    private void checkDeposit(Party account, FinancialAct balance, BigDecimal expectedBalance) {
        FinancialAct deposit = DepositHelper.getUndepositedDeposit((Entity)account, (IArchetypeService)this.getArchetypeService());
        Assert.assertNotNull((Object)deposit);
        IMObjectBean depBean = this.getBean((IMObject)deposit);
        Assert.assertTrue((boolean)depBean.hasTarget("items", (IMObject)balance));
        this.checkEquals(expectedBalance, deposit.getTotal());
    }

    private void setTillCashFloat(BigDecimal tillFloat) {
        IMObjectBean tillBean = this.getBean((IMObject)this.till);
        tillBean.setValue("tillFloat", (Object)tillFloat);
        tillBean.save();
    }

    private void checkStartClearTill(BigDecimal initialCashFloat, BigDecimal newCashFloat) {
        this.setTillCashFloat(initialCashFloat);
        Party account = DepositTestHelper.createDepositAccount();
        FinancialAct balance = this.createBalance(this.till, "UNCLEARED");
        this.save((IMObject)balance);
        Assert.assertNull((Object)balance.getActivityEndTime());
        this.rules.startClearTill(balance, newCashFloat);
        BigDecimal expectedBalance = this.checkBalance(initialCashFloat, newCashFloat, balance, "IN_PROGRESS");
        this.rules.clearTill(balance, account);
        this.checkDeposit(account, balance, expectedBalance);
    }

    private BigDecimal checkBalance(BigDecimal initialCashFloat, BigDecimal newCashFloat, FinancialAct balance, String status) {
        Assert.assertEquals((Object)status, (Object)balance.getStatus());
        Date startTime = balance.getActivityStartTime();
        Date endTime = balance.getActivityEndTime();
        if ("CLEARED".equals(status)) {
            Assert.assertTrue((endTime.compareTo(startTime) >= 0 ? 1 : 0) != 0);
            Assert.assertTrue((endTime.compareTo(new Date()) <= 0 ? 1 : 0) != 0);
        } else {
            Assert.assertNull((Object)endTime);
        }
        BigDecimal total = newCashFloat.subtract(initialCashFloat);
        if (initialCashFloat.compareTo(newCashFloat) != 0) {
            Assert.assertEquals((long)1L, (long)balance.getSourceActRelationships().size());
            IMObjectBean balBean = this.getBean((IMObject)balance);
            Act target = (Act)balBean.getTarget("items", Act.class);
            Assert.assertTrue((boolean)target.isA("act.tillBalanceAdjustment"));
            IMObjectBean adjBean = this.getBean((IMObject)target);
            BigDecimal amount = adjBean.getBigDecimal("amount");
            boolean credit = newCashFloat.compareTo(initialCashFloat) < 0;
            BigDecimal adjustmentTotal = total.abs();
            this.checkEquals(adjustmentTotal, amount);
            Assert.assertEquals((Object)credit, (Object)adjBean.getBoolean("credit"));
        } else {
            Assert.assertTrue((boolean)balance.getSourceActRelationships().isEmpty());
        }
        BigDecimal expectedBalance = total.negate();
        this.checkEquals(expectedBalance, balance.getTotal());
        this.till = this.get(this.till);
        IMObjectBean bean = this.getBean((IMObject)this.till);
        BigDecimal currentFloat = bean.getBigDecimal("tillFloat");
        Date lastCleared = bean.getDate("lastCleared");
        Date now = new Date();
        this.checkEquals(currentFloat, newCashFloat);
        Assert.assertTrue((now.compareTo(lastCleared) >= 0 ? 1 : 0) != 0);
        return expectedBalance;
    }

    private FinancialAct createPayment(Entity till, Party customer, String itemShortName, String status) {
        FinancialAct payment = FinancialTestHelper.createPayment(BigDecimal.ONE, customer, till, status);
        FinancialAct item = FinancialTestHelper.createPaymentRefundItem(itemShortName, BigDecimal.ONE);
        return this.addItem(payment, item);
    }

    private FinancialAct createPaymentEFT(Entity till, Party customer, String status, BigDecimal cashout) {
        FinancialAct payment = FinancialTestHelper.createPayment(BigDecimal.TEN, customer, till, status);
        FinancialAct item = FinancialTestHelper.createPaymentRefundItem("act.customerAccountPaymentEFT", BigDecimal.ONE);
        IMObjectBean bean = this.getBean((IMObject)item);
        bean.setValue("cashout", (Object)cashout);
        return this.addItem(payment, item);
    }

    private FinancialAct createRefund(Entity till, Party customer, String itemShortName, String status) {
        FinancialAct refund = FinancialTestHelper.createRefund(BigDecimal.ONE, customer, till, status);
        FinancialAct item = FinancialTestHelper.createPaymentRefundItem(itemShortName, BigDecimal.ONE);
        return this.addItem(refund, item);
    }

    private FinancialAct addItem(FinancialAct act, FinancialAct item) {
        IMObjectBean bean = this.getBean((IMObject)act);
        ActRelationship relationship = (ActRelationship)bean.addTarget("items", (IMObject)item);
        item.addActRelationship(relationship);
        this.save((IMObject[])new FinancialAct[]{act, item});
        return act;
    }

    private int countRelationships(Act source, Act target) {
        int found = 0;
        for (Relationship relationship : source.getSourceActRelationships()) {
            if (!relationship.getTarget().equals((Object)target.getObjectReference())) continue;
            ++found;
        }
        return found;
    }
}

