/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.till;

import java.math.BigDecimal;
import java.util.List;
import org.junit.Assert;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.finance.till.TillHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;

public abstract class AbstractTillRulesTest
extends ArchetypeServiceTest {
    protected FinancialAct checkAddToTillBalance(Entity till, List<FinancialAct> acts, boolean balanceExists, BigDecimal expectedTotal) {
        boolean existsPriorToSave;
        IArchetypeService service = this.getArchetypeService();
        FinancialAct act = acts.get(0);
        boolean posted = "POSTED".equals(act.getStatus());
        FinancialAct balance = TillHelper.getUnclearedTillBalance((Entity)till, (IArchetypeService)service);
        boolean bl = existsPriorToSave = balance != null;
        if (balanceExists) {
            Assert.assertNotNull((Object)balance);
        } else {
            Assert.assertNull((Object)balance);
        }
        service.save(acts);
        balance = TillHelper.getUnclearedTillBalance((Entity)till, (IArchetypeService)service);
        if (posted || existsPriorToSave) {
            Assert.assertNotNull((Object)balance);
        } else {
            Assert.assertNull((Object)balance);
        }
        if (balance != null) {
            Act latest = (Act)this.get((IMObject)acts.get(0));
            int found = this.countRelationships((Act)balance, latest);
            if (posted) {
                Assert.assertNotEquals((String)"Act not added to till balance", (long)0L, (long)found);
                Assert.assertFalse((String)"Act added to till balance more than once", (found > 1 ? 1 : 0) != 0);
            } else {
                Assert.assertEquals((String)"Act without Posted status added to till balance", (long)0L, (long)found);
            }
            BigDecimal total = balance.getTotal();
            this.checkEquals(expectedTotal, total);
        }
        return balance;
    }

    protected FinancialAct createBalance(Entity till, String status) {
        FinancialAct act = FinancialTestHelper.createTillBalance(till);
        act.setStatus(status);
        return act;
    }

    protected List<FinancialAct> createPayment(Entity till) {
        Party party = TestHelper.createCustomer();
        return FinancialTestHelper.createPaymentCash((BigDecimal)Money.ONE, party, till, "IN_PROGRESS");
    }

    protected List<FinancialAct> createRefund(Entity till) {
        Party party = TestHelper.createCustomer();
        return FinancialTestHelper.createRefundCash((BigDecimal)Money.ONE, party, till, "IN_PROGRESS");
    }

    private int countRelationships(Act source, Act target) {
        int found = 0;
        for (Relationship relationship : source.getSourceActRelationships()) {
            if (!relationship.getTarget().equals((Object)target.getObjectReference())) continue;
            ++found;
        }
        return found;
    }
}

